/*
 * This file is part of Nuts.
 * Copyright(C) 2009-2012 Nuts Develop Team.
 *
 * Nuts is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 * 
 * Nuts is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.aems;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;

import nuts.core.lang.Classes;
import nuts.core.log.Log;
import nuts.core.log.LogFactory;




/**
 * ContextListener
 */
public class ServletListener implements ServletContextListener,
		HttpSessionListener, ServletRequestListener {

	private static Log log = LogFactory.getLog(ServletListener.class);

	/**
	 * Invoke {@link WebApplet#initialize(javax.servlet.ServletContext) ()} 
	 * @see javax.servlet.ServletContextListener#contextInitialized(javax.servlet.ServletContextEvent)
	 */
	public void contextInitialized(ServletContextEvent sce) {
		ServletContext sc = sce.getServletContext();
		String appcls = sc.getInitParameter("ApplicationClass");
		
		WebApplet wa = WebApplet.get();
		if (wa != null) {
			log.warn(appcls + " already intialized.");
			return;
		}

		try {
			wa = (WebApplet)Classes.newInstance(appcls);
		}
		catch (Exception e) {
			log.error("Failed to create WebApplet instance: " + appcls, e);
			throw new RuntimeException(e);
		}

		wa.initialize(sc);
	}

	/**
	 * Invoke {@link WebApplet#destroy()}
	 * @see javax.servlet.ServletContextListener#contextDestroyed(javax.servlet.ServletContextEvent)
	 */
	public void contextDestroyed(ServletContextEvent sce) {
		WebApplet.get().destroy();
	}

	/**
	 * @see javax.servlet.http.HttpSessionListener#sessionCreated(javax.servlet.http.HttpSessionEvent)
	 */
	public void sessionCreated(HttpSessionEvent httpsessionevent) {
		if (log.isDebugEnabled()) {
			log.debug("Session created: " + httpsessionevent.getSession().getId());
		}
	}

	/**
	 * @see javax.servlet.http.HttpSessionListener#sessionDestroyed(javax.servlet.http.HttpSessionEvent)
	 */
	public void sessionDestroyed(HttpSessionEvent httpsessionevent) {
		if (log.isDebugEnabled()) {
			log.debug("Session destroyed: " + httpsessionevent.getSession().getId());
		}
	}

	/**
	 * @see javax.servlet.ServletRequestListener#requestInitialized(javax.servlet.ServletRequestEvent)
	 */
	public void requestInitialized(ServletRequestEvent sre) {
	}

	/**
	 * @see javax.servlet.ServletRequestListener#requestDestroyed(javax.servlet.ServletRequestEvent)
	 */
	public void requestDestroyed(ServletRequestEvent sre) {
	}
}
