/*
 * This file is part of Nuts Framework.
 * Copyright (C) 2009 Nuts Develop Team.
 *
 * Nuts Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License any later version.
 *
 * Nuts Framework is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Nuts Framework. If not, see <http://www.gnu.org/licenses/>.
 */
package nuts.aems.action.ngfsfile;

import nuts.aems.action.ndfsfile.NdfsFileAction;
import nuts.core.orm.dao.DataAccessUtils;
import nuts.exts.struts2.util.StrutsContextUtils;
import nuts.gae.vfs.ngfs.GaeDataMetaData;
import nuts.gae.vfs.ngfs.GaeFileMetaData;
import nuts.gae.vfs.ngfs.provider.GaeFileProvider;

import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.interceptor.PreResultListener;

/**
 */
@SuppressWarnings("serial")
public class NgfsFileAction extends NdfsFileAction {
	/**
	 * Constructor
	 */
	public NgfsFileAction() {
		setModelName(GaeFileMetaData.TABLE_NAME);
		setNdfsDataModelName(GaeDataMetaData.TABLE_NAME);
	}
	
	public void prepare() throws Exception {
		setDataAccessSession(GaeFileProvider.getDataAccessClient().openSession());

		ActionInvocation invocation = StrutsContextUtils.getActionInvocation();
		invocation.addPreResultListener(new PreResultListener() {
			public void beforeResult(ActionInvocation invocation,
					String resultCode) {
				DataAccessUtils.closeQuietly(getDataAccessSession());
			}
		});
	}
}
