/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.annotation.Annotation;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.regex.Pattern;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResolverUtil<T> {
    private static final Log log = LogFactory.getLog(ResolverUtil.class);
    private static final byte[] JAR_MAGIC = new byte[]{80, 75, 3, 4};
    private static final Pattern JAVA_IDENTIFIER_PATTERN = Pattern.compile("\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*");
    private Set<Class<? extends T>> matches = new HashSet<Class<? extends T>>();
    private ClassLoader classloader;

    public Set<Class<? extends T>> getClasses() {
        return this.matches;
    }

    public ClassLoader getClassLoader() {
        return this.classloader == null ? Thread.currentThread().getContextClassLoader() : this.classloader;
    }

    public void setClassLoader(ClassLoader classloader) {
        this.classloader = classloader;
    }

    public ResolverUtil<T> findImplementations(Class<?> parent, String ... packageNames) {
        if (packageNames == null) {
            return this;
        }
        IsA test = new IsA(parent);
        for (String pkg : packageNames) {
            this.find(test, pkg);
        }
        return this;
    }

    public ResolverUtil<T> findAnnotated(Class<? extends Annotation> annotation, String ... packageNames) {
        if (packageNames == null) {
            return this;
        }
        AnnotatedWith test = new AnnotatedWith(annotation);
        for (String pkg : packageNames) {
            this.find(test, pkg);
        }
        return this;
    }

    public ResolverUtil<T> find(Test test, String packageName) {
        String path = this.getPackagePath(packageName);
        try {
            ArrayList<URL> urls = Collections.list(this.getClassLoader().getResources(path));
            for (URL url : urls) {
                List<String> children = this.listClassResources(url, path);
                for (String child : children) {
                    this.addIfMatching(test, child);
                }
            }
        }
        catch (IOException ioe) {
            log.error("Could not read package: " + packageName + " -- ", ioe);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<String> listClassResources(URL url, String path) throws IOException {
        ArrayList<String> arrayList;
        log.debug("Listing classes in " + url);
        InputStream is = null;
        try {
            ArrayList<String> resources = new ArrayList();
            URL jarUrl = this.findJarForResource(url, path);
            if (jarUrl != null) {
                is = jarUrl.openStream();
                resources = this.listClassResources(new JarInputStream(is), path);
            } else {
                List<String> children = new ArrayList<String>();
                try {
                    if (this.isJar(url)) {
                        JarEntry entry;
                        is = url.openStream();
                        JarInputStream jarInput = new JarInputStream(is);
                        while ((entry = jarInput.getNextJarEntry()) != null) {
                            log.debug("Jar entry: " + entry.getName());
                            if (!this.isRelevantResource(entry.getName())) continue;
                            children.add(entry.getName());
                        }
                    } else {
                        String line;
                        is = url.openStream();
                        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
                        while ((line = reader.readLine()) != null) {
                            log.debug("Reader entry: " + line);
                            if (!this.isRelevantResource(line)) continue;
                            children.add(line);
                        }
                    }
                }
                catch (FileNotFoundException e) {
                    if ("file".equals(url.getProtocol())) {
                        File file = new File(url.getFile());
                        log.debug("Listing directory " + file.getAbsolutePath());
                        if (file.isDirectory()) {
                            children = Arrays.asList(file.list(new FilenameFilter(){

                                public boolean accept(File dir, String name) {
                                    return ResolverUtil.this.isRelevantResource(name);
                                }
                            }));
                        }
                    }
                    throw e;
                }
                String prefix = url.toExternalForm();
                if (!prefix.endsWith("/")) {
                    prefix = prefix + "/";
                }
                for (String child : children) {
                    String resourcePath = path + "/" + child;
                    if (child.endsWith(".class")) {
                        log.debug("Found class file: " + resourcePath);
                        resources.add(resourcePath);
                        continue;
                    }
                    URL childUrl = new URL(prefix + child);
                    resources.addAll(this.listClassResources(childUrl, resourcePath));
                }
            }
            arrayList = resources;
            Object var13_13 = null;
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            try {
                is.close();
            }
            catch (Exception e) {}
            throw throwable;
        }
        try {
            is.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        return arrayList;
    }

    protected List<String> listClassResources(JarInputStream jar, String path) throws IOException {
        JarEntry entry;
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        ArrayList<String> resources = new ArrayList<String>();
        while ((entry = jar.getNextJarEntry()) != null) {
            if (entry.isDirectory()) continue;
            String name = entry.getName();
            if (!name.startsWith("/")) {
                name = "/" + name;
            }
            if (!name.endsWith(".class") || !name.startsWith(path)) continue;
            log.debug("Found class file: " + name);
            resources.add(name.substring(1));
        }
        return resources;
    }

    protected URL findJarForResource(URL url, String path) throws MalformedURLException {
        log.debug("Find JAR URL: " + url);
        try {
            while (true) {
                url = new URL(url.getFile());
                log.debug("Inner URL: " + url);
            }
        }
        catch (MalformedURLException e) {
            StringBuilder jarUrl = new StringBuilder(url.toExternalForm());
            int index = jarUrl.lastIndexOf(".jar");
            if (index < 0) {
                log.debug("Not a JAR: " + jarUrl);
                return null;
            }
            jarUrl.setLength(index + 4);
            log.debug("Extracted JAR URL: " + jarUrl);
            try {
                URL testUrl = new URL(jarUrl.toString());
                if (this.isJar(testUrl)) {
                    return testUrl;
                }
                log.debug("Not a JAR: " + jarUrl);
                jarUrl.replace(0, jarUrl.length(), testUrl.getFile());
                File file = new File(jarUrl.toString());
                if (file.exists()) {
                    log.debug("Trying real file: " + file.getAbsolutePath());
                    testUrl = file.toURI().toURL();
                    if (this.isJar(testUrl)) {
                        return testUrl;
                    }
                }
            }
            catch (MalformedURLException e2) {
                log.warn("Invalid JAR URL: " + jarUrl);
            }
            log.debug("Not a JAR: " + jarUrl);
            return null;
        }
    }

    protected String getPackagePath(String packageName) {
        return packageName == null ? null : packageName.replace('.', '/');
    }

    protected boolean isRelevantResource(String resourceName) {
        return resourceName != null && (resourceName.endsWith(".class") || JAVA_IDENTIFIER_PATTERN.matcher(resourceName).matches());
    }

    protected boolean isJar(URL url) {
        return this.isJar(url, new byte[JAR_MAGIC.length]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    protected boolean isJar(URL url, byte[] buffer) {
        block10: {
            InputStream is;
            block9: {
                is = null;
                is = url.openStream();
                is.read(buffer, 0, JAR_MAGIC.length);
                if (!Arrays.equals(buffer, JAR_MAGIC)) break block9;
                log.debug("Found JAR: " + url);
                boolean bl = true;
                Object var6_6 = null;
                try {
                    is.close();
                }
                catch (Exception e2) {
                    // empty catch block
                }
                return bl;
            }
            Object var6_7 = null;
            try {
                is.close();
            }
            catch (Exception e2) {}
            break block10;
            {
                catch (Exception e) {
                    Object var6_8 = null;
                    try {
                        is.close();
                    }
                    catch (Exception e2) {}
                }
            }
            catch (Throwable throwable) {
                Object var6_9 = null;
                try {
                    is.close();
                }
                catch (Exception e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return false;
    }

    protected void addIfMatching(Test test, String fqn) {
        try {
            String externalName = fqn.substring(0, fqn.indexOf(46)).replace('/', '.');
            ClassLoader loader = this.getClassLoader();
            log.debug("Checking to see if class " + externalName + " matches criteria [" + test + "]");
            Class<?> type = loader.loadClass(externalName);
            if (test.matches(type)) {
                this.matches.add(type);
            }
        }
        catch (Throwable t) {
            log.warn("Could not examine class '" + fqn + "'" + " due to a " + t.getClass().getName() + " with message: " + t.getMessage());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AnnotatedWith
    implements Test {
        private Class<? extends Annotation> annotation;

        public AnnotatedWith(Class<? extends Annotation> annotation) {
            this.annotation = annotation;
        }

        public boolean matches(Class type) {
            return type != null && type.isAnnotationPresent(this.annotation);
        }

        public String toString() {
            return "annotated with @" + this.annotation.getSimpleName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class IsA
    implements Test {
        private Class<?> parent;

        public IsA(Class<?> parentType) {
            this.parent = parentType;
        }

        public boolean matches(Class type) {
            return type != null && this.parent.isAssignableFrom(type);
        }

        public String toString() {
            return "is assignable to " + this.parent.getSimpleName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Test {
        public boolean matches(Class<?> var1);
    }
}

