/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.executor.keygen;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.executor.ExecutorException;
import org.apache.ibatis.executor.keygen.KeyGenerator;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.type.TypeHandler;
import org.apache.ibatis.type.TypeHandlerRegistry;

public class Jdbc3KeyGenerator
implements KeyGenerator {
    private String keyColumnName;

    public Jdbc3KeyGenerator(String keyColumnName) {
        this.keyColumnName = keyColumnName;
    }

    public void processBefore(Executor executor, MappedStatement ms, Statement stmt, Object parameter) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processAfter(Executor executor, MappedStatement ms, Statement stmt, Object parameter) {
        block12: {
            try {
                Class keyPropertyType;
                TypeHandler th;
                Configuration configuration = ms.getConfiguration();
                TypeHandlerRegistry typeHandlerRegistry = configuration.getTypeHandlerRegistry();
                if (parameter == null) break block12;
                String keyProperty = ms.getKeyProperty();
                MetaObject metaParam = configuration.newMetaObject(parameter);
                if (keyProperty == null || !metaParam.hasSetter(keyProperty) || (th = typeHandlerRegistry.getTypeHandler(keyPropertyType = metaParam.getSetterType(keyProperty))) == null) break block12;
                ResultSet rs = stmt.getGeneratedKeys();
                try {
                    ResultSetMetaData rsmd = rs.getMetaData();
                    int colCount = rsmd.getColumnCount();
                    if (colCount > 0) {
                        String colName = this.keyColumnName != null && this.keyColumnName.length() > 0 ? this.keyColumnName : rsmd.getColumnName(1);
                        while (rs.next()) {
                            Object value = th.getResult(rs, colName);
                            metaParam.setValue(keyProperty, value);
                        }
                    }
                }
                finally {
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                    }
                    catch (Exception e) {}
                }
            }
            catch (Exception e) {
                throw new ExecutorException("Error getting generated key or setting result to parameter object. Cause: " + e, e);
            }
        }
    }
}

