/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mock.web.portlet;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Locale;
import javax.portlet.PortalContext;
import javax.portlet.PortletURL;
import javax.portlet.RenderResponse;
import org.springframework.mock.web.portlet.MockPortletResponse;
import org.springframework.mock.web.portlet.MockPortletURL;

public class MockRenderResponse
extends MockPortletResponse
implements RenderResponse {
    private String contentType;
    private String namespace = "MockPortlet";
    private String title;
    private String characterEncoding = "ISO-8859-1";
    private PrintWriter writer;
    private Locale locale = Locale.getDefault();
    private int bufferSize = 4096;
    private final ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
    private boolean committed;
    private String includedUrl;

    public MockRenderResponse() {
    }

    public MockRenderResponse(PortalContext portalContext) {
        super(portalContext);
    }

    public String getContentType() {
        return this.contentType;
    }

    public PortletURL createRenderURL() {
        MockPortletURL url = new MockPortletURL(this.getPortalContext(), "render");
        return url;
    }

    public PortletURL createActionURL() {
        MockPortletURL url = new MockPortletURL(this.getPortalContext(), "action");
        return url;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public void setCharacterEncoding(String characterEncoding) {
        this.characterEncoding = characterEncoding;
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public PrintWriter getWriter() throws UnsupportedEncodingException {
        if (this.writer == null) {
            OutputStreamWriter targetWriter = this.characterEncoding != null ? new OutputStreamWriter((OutputStream)this.outputStream, this.characterEncoding) : new OutputStreamWriter(this.outputStream);
            this.writer = new PrintWriter(targetWriter);
        }
        return this.writer;
    }

    public byte[] getContentAsByteArray() {
        this.flushBuffer();
        return this.outputStream.toByteArray();
    }

    public String getContentAsString() throws UnsupportedEncodingException {
        this.flushBuffer();
        return this.characterEncoding != null ? this.outputStream.toString(this.characterEncoding) : this.outputStream.toString();
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void flushBuffer() {
        if (this.writer != null) {
            this.writer.flush();
        }
        if (this.outputStream != null) {
            try {
                this.outputStream.flush();
            }
            catch (IOException ex) {
                throw new IllegalStateException("Could not flush OutputStream: " + ex.getMessage());
            }
        }
        this.committed = true;
    }

    public void resetBuffer() {
        if (this.committed) {
            throw new IllegalStateException("Cannot reset buffer - response is already committed");
        }
        this.outputStream.reset();
    }

    public void setCommitted(boolean committed) {
        this.committed = committed;
    }

    public boolean isCommitted() {
        return this.committed;
    }

    public void reset() {
        this.resetBuffer();
        this.characterEncoding = null;
        this.contentType = null;
        this.locale = null;
    }

    public OutputStream getPortletOutputStream() throws IOException {
        return this.outputStream;
    }

    public void setIncludedUrl(String includedUrl) {
        this.includedUrl = includedUrl;
    }

    public String getIncludedUrl() {
        return this.includedUrl;
    }
}

