/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.svg.graphic;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.tool.xml.svg.PathBean;
import com.itextpdf.tool.xml.svg.PathItem;
import com.itextpdf.tool.xml.svg.tags.Graphic;
import com.itextpdf.tool.xml.svg.utils.EllipseArc;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Path
extends Graphic {
    PathBean path;

    public Path(PathBean path, Map<String, String> css) {
        super(css);
        this.path = path;
    }

    @Override
    public void draw(PdfContentByte cb) {
        this.drawElement(cb);
    }

    List<PathItem> translate(List<PathItem> items) {
        ArrayList<PathItem> result = new ArrayList<PathItem>();
        try {
            for (PathItem item : items) {
                if (item.isMoveTo() || item.isLineTo()) {
                    this.translateForMoveAndLineTo(item, result);
                }
                if (item.isHorizontalLineTo() || item.isVerticalLineTo()) {
                    this.translateForHorizontalOrVerticalLine(item, result);
                }
                if (item.isCubicBezier() || item.isQuadraticBezier() || item.isCubicBezierShorthand() || item.isQuadraticBezierShorthand()) {
                    this.translateCurves(item, result);
                }
                if (item.isArcTo()) {
                    this.translateArc(item, result);
                }
                if (!item.isClosePath()) continue;
                result.add(item);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    private float[] getCurrentPoint(List<PathItem> result) {
        float[] currentPoint = new float[2];
        if (result != null && result.size() != 0) {
            List<Float> coordinates = result.get(result.size() - 1).getCoordinates();
            currentPoint[0] = coordinates.get(coordinates.size() - 2).floatValue();
            currentPoint[1] = coordinates.get(coordinates.size() - 1).floatValue();
        }
        return currentPoint;
    }

    private void translateArc(PathItem item, List<PathItem> result) throws Exception {
        int size = 7;
        List<Float> numbers = item.getCoordinates();
        for (int i = 0; i < numbers.size() / size; ++i) {
            ArrayList<Float> coordinates = new ArrayList<Float>();
            float[] currentPoint = this.getCurrentPoint(result);
            for (int j = 0; j < size; ++j) {
                if (j == size - 2 && item.isRelative()) {
                    coordinates.add(Float.valueOf(currentPoint[0] + numbers.get(i * size + j).floatValue()));
                    continue;
                }
                if (j == size - 1 && item.isRelative()) {
                    coordinates.add(Float.valueOf(currentPoint[1] + numbers.get(i * size + j).floatValue()));
                    continue;
                }
                coordinates.add(numbers.get(i * size + j));
            }
            coordinates.add(Float.valueOf(currentPoint[0]));
            coordinates.add(Float.valueOf(currentPoint[1]));
            result.add(new PathItem(coordinates, 'A'));
        }
        if (numbers.size() % size != 0) {
            throw new Exception("Something wrong with the number of coordinates in the path");
        }
    }

    private void translateCurves(PathItem item, List<PathItem> result) throws Exception {
        int size = item.isCubicBezier() ? 6 : (item.isCubicBezierShorthand() || item.isQuadraticBezier() ? 4 : 2);
        List<Float> numbers = item.getCoordinates();
        for (int i = 0; i < numbers.size() / size; ++i) {
            ArrayList<Float> coordinates = new ArrayList<Float>();
            if (item.isCubicBezierShorthand() || item.isQuadraticBezierShorthand()) {
                PathItem previous;
                if (result != null && result.size() != 0 && ((previous = result.get(result.size() - 1)).isCubicBezier() && item.isCubicBezierShorthand() || previous.isQuadraticBezier() && item.isQuadraticBezierShorthand())) {
                    List<Float> previousCoordinates = result.get(result.size() - 1).getCoordinates();
                    float xPreviousControlPoint = previousCoordinates.get(previousCoordinates.size() - 4).floatValue();
                    float yPreviousControlPoint = previousCoordinates.get(previousCoordinates.size() - 3).floatValue();
                    float[] current = this.getCurrentPoint(result);
                    coordinates.add(Float.valueOf(2.0f * current[0] - xPreviousControlPoint));
                    coordinates.add(Float.valueOf(2.0f * current[1] - yPreviousControlPoint));
                }
                if (coordinates.size() == 0) {
                    float[] current = this.getCurrentPoint(result);
                    coordinates.add(Float.valueOf(current[0]));
                    coordinates.add(Float.valueOf(current[1]));
                }
            }
            for (int j = 0; j < size; ++j) {
                if (item.isRelative()) {
                    float[] currentPoint = this.getCurrentPoint(result);
                    if (j % 2 == 0) {
                        coordinates.add(Float.valueOf(currentPoint[0] + numbers.get(i * size + j).floatValue()));
                        continue;
                    }
                    coordinates.add(Float.valueOf(currentPoint[1] + numbers.get(i * size + j).floatValue()));
                    continue;
                }
                coordinates.add(numbers.get(i * size + j));
            }
            if (item.isCubicBezier() || item.isCubicBezierShorthand()) {
                result.add(new PathItem(coordinates, 'C'));
                continue;
            }
            result.add(new PathItem(coordinates, 'Q'));
        }
        if (numbers.size() % size != 0) {
            throw new Exception("Something wrong with the number of coordinates in the path");
        }
    }

    private void translateForHorizontalOrVerticalLine(PathItem item, List<PathItem> result) {
        List<Float> numbers = item.getCoordinates();
        if (numbers.size() == 0) {
            numbers.add(Float.valueOf(0.0f));
        }
        float[] currentPoint = this.getCurrentPoint(result);
        if (!item.isRelative()) {
            ArrayList<Float> coordinates = new ArrayList<Float>();
            if (item.isHorizontalLineTo()) {
                coordinates.add(numbers.get(numbers.size() - 1));
                coordinates.add(Float.valueOf(currentPoint[1]));
            } else {
                coordinates.add(Float.valueOf(currentPoint[0]));
                coordinates.add(numbers.get(numbers.size() - 1));
            }
            result.add(new PathItem(coordinates, 'L'));
        } else {
            float coordinate = 0.0f;
            for (int i = 0; i < numbers.size(); ++i) {
                coordinate += numbers.get(i).floatValue();
            }
            ArrayList<Float> coordinates = new ArrayList<Float>();
            if (item.isHorizontalLineTo()) {
                coordinates.add(Float.valueOf(coordinate + currentPoint[0]));
                coordinates.add(Float.valueOf(currentPoint[1]));
            } else {
                coordinates.add(Float.valueOf(currentPoint[0]));
                coordinates.add(Float.valueOf(coordinate + currentPoint[1]));
            }
            result.add(new PathItem(coordinates, 'L'));
        }
    }

    private void translateForMoveAndLineTo(PathItem item, List<PathItem> result) {
        List<Float> numbers = item.getCoordinates();
        if (numbers.size() % 2 == 1) {
            numbers.add(Float.valueOf(0.0f));
        }
        for (int i = 0; i < numbers.size() / 2; ++i) {
            float x = numbers.get(i * 2).floatValue();
            float y = numbers.get(i * 2 + 1).floatValue();
            if (item.isRelative()) {
                float[] currentPoint = this.getCurrentPoint(result);
                x += currentPoint[0];
                y += currentPoint[1];
            }
            ArrayList<Float> coordinates = new ArrayList<Float>();
            coordinates.add(Float.valueOf(x));
            coordinates.add(Float.valueOf(y));
            if (item.isMoveTo() && i == 0) {
                result.add(new PathItem(coordinates, 'M'));
                continue;
            }
            result.add(new PathItem(coordinates, 'L'));
        }
    }

    private void drawArc(PdfContentByte cb, List<Float> numbers) {
        EllipseArc ellipse = EllipseArc.createEllipseArc(numbers.get(7).floatValue(), numbers.get(8).floatValue(), numbers.get(5).floatValue(), numbers.get(6).floatValue(), numbers.get(0).floatValue(), numbers.get(1).floatValue(), numbers.get(4).floatValue(), numbers.get(3).floatValue());
        cb.setColorFill(BaseColor.ORANGE);
        cb.rectangle(numbers.get(7).floatValue(), numbers.get(8).floatValue(), 2.0f, 2.0f);
        cb.fill();
        cb.setColorFill(BaseColor.GREEN);
        cb.rectangle(numbers.get(5).floatValue(), numbers.get(6).floatValue(), 2.0f, 2.0f);
        cb.fill();
        cb.arc(ellipse.getCx() - numbers.get(0).floatValue(), ellipse.getCy() - numbers.get(1).floatValue(), ellipse.getCx() + numbers.get(0).floatValue(), ellipse.getCy() + numbers.get(1).floatValue(), ellipse.getStartAng(), ellipse.getExtend());
    }

    public List<PathItem> getTranslatedPathItems() {
        return this.translate(this.path.getPathItems());
    }

    void drawElement(PdfContentByte cb) {
        try {
            List<PathItem> translatedItems = this.translate(this.path.getPathItems());
            for (PathItem item : translatedItems) {
                List<Float> numbers = item.getCoordinates();
                if (item.isMoveTo()) {
                    cb.moveTo(numbers.get(0).floatValue(), numbers.get(1).floatValue());
                    continue;
                }
                if (item.isLineTo()) {
                    cb.lineTo(numbers.get(0).floatValue(), numbers.get(1).floatValue());
                    continue;
                }
                if (item.isCubicBezier()) {
                    cb.curveTo(numbers.get(0).floatValue(), numbers.get(1).floatValue(), numbers.get(2).floatValue(), numbers.get(3).floatValue(), numbers.get(4).floatValue(), numbers.get(5).floatValue());
                    continue;
                }
                if (item.isQuadraticBezier()) {
                    cb.curveTo(numbers.get(0).floatValue(), numbers.get(1).floatValue(), numbers.get(2).floatValue(), numbers.get(3).floatValue());
                    continue;
                }
                if (item.isArcTo()) {
                    this.drawArc(cb, numbers);
                    continue;
                }
                if (!item.isClosePath()) continue;
                cb.closePath();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

