/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ezmorph.object;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import net.sf.ezmorph.MorphException;
import net.sf.ezmorph.Morpher;
import net.sf.ezmorph.object.AbstractObjectMorpher;
import org.apache.commons.lang.builder.HashCodeBuilder;

public final class ObjectListMorpher
extends AbstractObjectMorpher {
    private Object defaultValue;
    private Morpher morpher;
    private Method morphMethod;

    public ObjectListMorpher(Morpher morpher) {
        this.setMorpher(morpher);
    }

    public ObjectListMorpher(Morpher morpher, Object defaultValue) {
        super(true);
        this.defaultValue = defaultValue;
        this.setMorpher(morpher);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ObjectListMorpher)) {
            return false;
        }
        ObjectListMorpher other = (ObjectListMorpher)obj;
        return this.morpher.equals(other.morpher);
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.morpher).toHashCode();
    }

    public Object morph(Object value) {
        if (value == null) {
            return null;
        }
        if (!this.supports(value.getClass())) {
            throw new MorphException(value.getClass() + " is not supported");
        }
        ArrayList<Object> list = new ArrayList<Object>();
        for (Object object : (List)value) {
            if (object == null) {
                if (this.isUseDefault()) {
                    list.add(this.defaultValue);
                    continue;
                }
                list.add(object);
                continue;
            }
            if (!this.morpher.supports(object.getClass())) {
                throw new MorphException(object.getClass() + " is not supported");
            }
            try {
                list.add(this.morphMethod.invoke((Object)this.morpher, object));
            }
            catch (MorphException me) {
                throw me;
            }
            catch (Exception e) {
                throw new MorphException(e);
            }
        }
        return list;
    }

    public Class morphsTo() {
        return List.class;
    }

    public boolean supports(Class clazz) {
        return clazz != null && List.class.isAssignableFrom(clazz);
    }

    private void setMorpher(Morpher morpher) {
        if (morpher == null) {
            throw new IllegalArgumentException("morpher can not be null");
        }
        this.morpher = morpher;
        try {
            this.morphMethod = morpher.getClass().getDeclaredMethod("morph", Object.class);
        }
        catch (NoSuchMethodException nsme) {
            throw new IllegalArgumentException(nsme.getMessage());
        }
    }
}

