/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ezmorph.object;

import java.math.BigDecimal;
import java.math.BigInteger;
import net.sf.ezmorph.MorphException;
import net.sf.ezmorph.object.AbstractObjectMorpher;
import net.sf.ezmorph.object.BigDecimalMorpher;
import net.sf.ezmorph.object.BigIntegerMorpher;
import net.sf.ezmorph.primitive.ByteMorpher;
import net.sf.ezmorph.primitive.DoubleMorpher;
import net.sf.ezmorph.primitive.FloatMorpher;
import net.sf.ezmorph.primitive.IntMorpher;
import net.sf.ezmorph.primitive.LongMorpher;
import net.sf.ezmorph.primitive.ShortMorpher;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public final class NumberMorpher
extends AbstractObjectMorpher {
    private Number defaultValue;
    private Class type;

    public NumberMorpher(Class type) {
        super(false);
        if (type == null) {
            throw new MorphException("Must specify a type");
        }
        if (!(type == Byte.TYPE || type == Short.TYPE || type == Integer.TYPE || type == Long.TYPE || type == Float.TYPE || type == Double.TYPE || Byte.class.isAssignableFrom(type) || Short.class.isAssignableFrom(type) || Integer.class.isAssignableFrom(type) || Long.class.isAssignableFrom(type) || Float.class.isAssignableFrom(type) || Double.class.isAssignableFrom(type) || BigInteger.class.isAssignableFrom(type) || BigDecimal.class.isAssignableFrom(type))) {
            throw new MorphException("Must specify a Number subclass");
        }
        this.type = type;
    }

    public NumberMorpher(Class type, Number defaultValue) {
        super(true);
        if (type == null) {
            throw new MorphException("Must specify a type");
        }
        if (!(type == Byte.TYPE || type == Short.TYPE || type == Integer.TYPE || type == Long.TYPE || type == Float.TYPE || type == Double.TYPE || Byte.class.isAssignableFrom(type) || Short.class.isAssignableFrom(type) || Integer.class.isAssignableFrom(type) || Long.class.isAssignableFrom(type) || Float.class.isAssignableFrom(type) || Double.class.isAssignableFrom(type) || BigInteger.class.isAssignableFrom(type) || BigDecimal.class.isAssignableFrom(type))) {
            throw new MorphException("Must specify a Number subclass");
        }
        if (defaultValue != null && !type.isInstance(defaultValue)) {
            throw new MorphException("Default value must be of type " + type);
        }
        this.type = type;
        this.setDefaultValue(defaultValue);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NumberMorpher)) {
            return false;
        }
        NumberMorpher other = (NumberMorpher)obj;
        EqualsBuilder builder = new EqualsBuilder();
        builder.append((Object)this.type, (Object)other.type);
        if (this.isUseDefault() && other.isUseDefault()) {
            builder.append((Object)this.getDefaultValue(), (Object)other.getDefaultValue());
            return builder.isEquals();
        }
        if (!this.isUseDefault() && !other.isUseDefault()) {
            return builder.isEquals();
        }
        return false;
    }

    public Number getDefaultValue() {
        return this.defaultValue;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.type);
        if (this.isUseDefault()) {
            builder.append((Object)this.getDefaultValue());
        }
        return builder.toHashCode();
    }

    public Object morph(Object value) {
        if (value != null && this.type.isAssignableFrom(value.getClass())) {
            return value;
        }
        String str = String.valueOf(value).trim();
        if (!this.type.isPrimitive() && (value == null || str.length() == 0 || "null".equalsIgnoreCase(str))) {
            return null;
        }
        if (this.isDecimalNumber(this.type)) {
            if (Float.class.isAssignableFrom(this.type) || Float.TYPE == this.type) {
                return this.morphToFloat(str);
            }
            if (Double.class.isAssignableFrom(this.type) || Double.TYPE == this.type) {
                return this.morphToDouble(str);
            }
            return this.morphToBigDecimal(str);
        }
        if (Byte.class.isAssignableFrom(this.type) || Byte.TYPE == this.type) {
            return this.morphToByte(str);
        }
        if (Short.class.isAssignableFrom(this.type) || Short.TYPE == this.type) {
            return this.morphToShort(str);
        }
        if (Integer.class.isAssignableFrom(this.type) || Integer.TYPE == this.type) {
            return this.morphToInteger(str);
        }
        if (Long.class.isAssignableFrom(this.type) || Long.TYPE == this.type) {
            return this.morphToLong(str);
        }
        return this.morphToBigInteger(str);
    }

    public Class morphsTo() {
        return this.type;
    }

    public void setDefaultValue(Number defaultValue) {
        if (defaultValue != null && !this.type.isInstance(defaultValue)) {
            throw new MorphException("Default value must be of type " + this.type);
        }
        this.defaultValue = defaultValue;
    }

    private boolean isDecimalNumber(Class type) {
        return Double.class.isAssignableFrom(type) || Float.class.isAssignableFrom(type) || Double.TYPE == type || Float.TYPE == type || BigDecimal.class.isAssignableFrom(type);
    }

    private Object morphToBigDecimal(String str) {
        Object result = null;
        result = this.isUseDefault() ? new BigDecimalMorpher((BigDecimal)this.defaultValue).morph(str) : new BigDecimal(str);
        return result;
    }

    private Object morphToBigInteger(String str) {
        Object result = null;
        result = this.isUseDefault() ? new BigIntegerMorpher((BigInteger)this.defaultValue).morph(str) : new BigInteger(str);
        return result;
    }

    private Object morphToByte(String str) {
        Byte result = null;
        if (this.isUseDefault()) {
            if (this.defaultValue == null) {
                return null;
            }
            result = new Byte(new ByteMorpher(this.defaultValue.byteValue()).morph(str));
        } else {
            result = new Byte(new ByteMorpher().morph(str));
        }
        return result;
    }

    private Object morphToDouble(String str) {
        Double result = null;
        if (this.isUseDefault()) {
            if (this.defaultValue == null) {
                return null;
            }
            result = new Double(new DoubleMorpher(this.defaultValue.doubleValue()).morph(str));
        } else {
            result = new Double(new DoubleMorpher().morph(str));
        }
        return result;
    }

    private Object morphToFloat(String str) {
        Float result = null;
        if (this.isUseDefault()) {
            if (this.defaultValue == null) {
                return null;
            }
            result = new Float(new FloatMorpher(this.defaultValue.floatValue()).morph(str));
        } else {
            result = new Float(new FloatMorpher().morph(str));
        }
        return result;
    }

    private Object morphToInteger(String str) {
        Integer result = null;
        if (this.isUseDefault()) {
            if (this.defaultValue == null) {
                return null;
            }
            result = new Integer(new IntMorpher(this.defaultValue.intValue()).morph(str));
        } else {
            result = new Integer(new IntMorpher().morph(str));
        }
        return result;
    }

    private Object morphToLong(String str) {
        Long result = null;
        if (this.isUseDefault()) {
            if (this.defaultValue == null) {
                return null;
            }
            result = new Long(new LongMorpher(this.defaultValue.longValue()).morph(str));
        } else {
            result = new Long(new LongMorpher().morph(str));
        }
        return result;
    }

    private Object morphToShort(String str) {
        Short result = null;
        if (this.isUseDefault()) {
            if (this.defaultValue == null) {
                return null;
            }
            result = new Short(new ShortMorpher(this.defaultValue.shortValue()).morph(str));
        } else {
            result = new Short(new ShortMorpher().morph(str));
        }
        return result;
    }
}

