/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.services.ec2.model.Route;
import com.amazonaws.services.ec2.model.RouteTableAssociation;
import com.amazonaws.services.ec2.model.Tag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RouteTable {
    private String routeTableId;
    private String vpcId;
    private List<Route> routes;
    private List<RouteTableAssociation> associations;
    private List<Tag> tags;

    public String getRouteTableId() {
        return this.routeTableId;
    }

    public void setRouteTableId(String routeTableId) {
        this.routeTableId = routeTableId;
    }

    public RouteTable withRouteTableId(String routeTableId) {
        this.routeTableId = routeTableId;
        return this;
    }

    public String getVpcId() {
        return this.vpcId;
    }

    public void setVpcId(String vpcId) {
        this.vpcId = vpcId;
    }

    public RouteTable withVpcId(String vpcId) {
        this.vpcId = vpcId;
        return this;
    }

    public List<Route> getRoutes() {
        if (this.routes == null) {
            this.routes = new ArrayList<Route>();
        }
        return this.routes;
    }

    public void setRoutes(Collection<Route> routes) {
        ArrayList<Route> routesCopy = new ArrayList<Route>();
        if (routes != null) {
            routesCopy.addAll(routes);
        }
        this.routes = routesCopy;
    }

    public RouteTable withRoutes(Route ... routes) {
        for (Route value : routes) {
            this.getRoutes().add(value);
        }
        return this;
    }

    public RouteTable withRoutes(Collection<Route> routes) {
        ArrayList<Route> routesCopy = new ArrayList<Route>();
        if (routes != null) {
            routesCopy.addAll(routes);
        }
        this.routes = routesCopy;
        return this;
    }

    public List<RouteTableAssociation> getAssociations() {
        if (this.associations == null) {
            this.associations = new ArrayList<RouteTableAssociation>();
        }
        return this.associations;
    }

    public void setAssociations(Collection<RouteTableAssociation> associations) {
        ArrayList<RouteTableAssociation> associationsCopy = new ArrayList<RouteTableAssociation>();
        if (associations != null) {
            associationsCopy.addAll(associations);
        }
        this.associations = associationsCopy;
    }

    public RouteTable withAssociations(RouteTableAssociation ... associations) {
        for (RouteTableAssociation value : associations) {
            this.getAssociations().add(value);
        }
        return this;
    }

    public RouteTable withAssociations(Collection<RouteTableAssociation> associations) {
        ArrayList<RouteTableAssociation> associationsCopy = new ArrayList<RouteTableAssociation>();
        if (associations != null) {
            associationsCopy.addAll(associations);
        }
        this.associations = associationsCopy;
        return this;
    }

    public List<Tag> getTags() {
        if (this.tags == null) {
            this.tags = new ArrayList<Tag>();
        }
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        ArrayList<Tag> tagsCopy = new ArrayList<Tag>();
        if (tags != null) {
            tagsCopy.addAll(tags);
        }
        this.tags = tagsCopy;
    }

    public RouteTable withTags(Tag ... tags) {
        for (Tag value : tags) {
            this.getTags().add(value);
        }
        return this;
    }

    public RouteTable withTags(Collection<Tag> tags) {
        ArrayList<Tag> tagsCopy = new ArrayList<Tag>();
        if (tags != null) {
            tagsCopy.addAll(tags);
        }
        this.tags = tagsCopy;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append("RouteTableId: " + this.routeTableId + ", ");
        sb.append("VpcId: " + this.vpcId + ", ");
        sb.append("Routes: " + this.routes + ", ");
        sb.append("Associations: " + this.associations + ", ");
        sb.append("Tags: " + this.tags + ", ");
        sb.append("}");
        return sb.toString();
    }
}

