/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnant.conditions;

import java.io.File;
import java.net.MalformedURLException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.tigris.subversion.svnant.SvnFacade;
import org.tigris.subversion.svnant.conditions.SvnCondition;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNInfo;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNNodeKind;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class Available
extends SvnCondition {
    private String target = null;
    private FileDir type = null;

    protected void preconditions() throws BuildException {
        if (this.target == null) {
            throw new BuildException("Missing attribute 'target'.");
        }
    }

    protected boolean internalEval() {
        ISVNInfo iSVNInfo;
        block9: {
            ISVNClientAdapter iSVNClientAdapter = SvnFacade.getClientAdapter((ProjectComponent)this);
            iSVNInfo = null;
            try {
                File file = new File(Project.translatePath((String)this.target));
                if (file.exists()) {
                    iSVNInfo = iSVNClientAdapter.getInfo(file);
                    break block9;
                }
                try {
                    SVNUrl sVNUrl = new SVNUrl(this.target);
                    iSVNInfo = iSVNClientAdapter.getInfo(sVNUrl);
                }
                catch (MalformedURLException malformedURLException) {
                    throw new BuildException("The url '" + this.target + "' is not valid.", (Throwable)malformedURLException);
                }
            }
            catch (SVNClientException sVNClientException) {
                return false;
            }
        }
        if (null == iSVNInfo) {
            return false;
        }
        if (iSVNInfo.getRevision() == null || SVNRevision.INVALID_REVISION.equals((Object)iSVNInfo.getRevision())) {
            return false;
        }
        if (this.type != null) {
            if (this.type.isDir()) {
                return iSVNInfo.getNodeKind() == SVNNodeKind.DIR;
            }
            return iSVNInfo.getNodeKind() == SVNNodeKind.FILE;
        }
        return true;
    }

    public void setTarget(String string) {
        this.target = string;
        if (this.target != null && this.target.length() == 0) {
            this.target = null;
        }
    }

    public void setType(FileDir fileDir) {
        this.type = fileDir;
    }

    public static class FileDir
    extends EnumeratedAttribute {
        private static final String[] VALUES = new String[]{"file", "dir"};

        public String[] getValues() {
            return VALUES;
        }

        public boolean isDir() {
            return "dir".equalsIgnoreCase(this.getValue());
        }

        public boolean isFile() {
            return "file".equalsIgnoreCase(this.getValue());
        }
    }
}

