/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnant.commands;

import java.io.File;
import org.tigris.subversion.svnant.SvnAntUtilities;
import org.tigris.subversion.svnant.commands.ResourceSetSvnCommand;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;

public class Update
extends ResourceSetSvnCommand {
    private static final String MSG_CANNOT_UPDATE = "Cannot update file or dir %s";
    private SVNRevision revision = SVNRevision.HEAD;

    public Update() {
        super(true, true);
    }

    protected void handleDir(File file, boolean bl) {
        this.update(file, this.revision, bl);
    }

    protected void handleFile(File file) {
        this.update(file, this.revision, false);
    }

    private void update(File file, SVNRevision sVNRevision, boolean bl) {
        try {
            this.getClient().update(file, sVNRevision, bl);
        }
        catch (SVNClientException sVNClientException) {
            throw Update.ex((Exception)((Object)sVNClientException), MSG_CANNOT_UPDATE, file.getAbsolutePath());
        }
    }

    protected void validateAttributes() {
        super.validateAttributes();
        SvnAntUtilities.attrNotNull("revision", this.revision);
    }

    public void setRevision(String string) {
        this.revision = this.getRevisionFrom(string);
    }

    public void setRecurse(boolean bl) {
        super.setRecurse(bl);
    }
}

