/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnant.commands;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ProjectComponent;
import org.tigris.subversion.svnant.SvnFacade;
import org.tigris.subversion.svnant.SvnTask;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.SVNRevision;

public abstract class SvnCommand
extends ProjectComponent {
    private SvnTask task;
    private ISVNClientAdapter svnClient;

    protected abstract void validateAttributes();

    protected ISVNClientAdapter getClient() {
        return this.svnClient;
    }

    public String getCommandname() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    public abstract void execute();

    public final void executeCommand(ISVNClientAdapter iSVNClientAdapter) throws BuildException {
        this.svnClient = iSVNClientAdapter;
        this.verbose("<%s> started ...", this.getCommandname());
        try {
            this.validateAttributes();
            this.execute();
            this.verbose("<%s> finished.", this.getCommandname());
        }
        catch (BuildException buildException) {
            this.error("<%s> failed.", this.getCommandname());
            throw buildException;
        }
        catch (Exception exception) {
            this.error("<%s> failed.", this.getCommandname());
            throw new BuildException((Throwable)exception);
        }
    }

    public SvnTask getTask() {
        return this.task;
    }

    public void setTask(SvnTask svnTask) {
        this.task = svnTask;
        if (this.task.getProject() != null) {
            this.setProject(this.task.getProject());
        }
    }

    public SVNRevision getRevisionFrom(String string) {
        try {
            return SVNRevision.getRevision((String)string, (SimpleDateFormat)this.getDateFormatter());
        }
        catch (ParseException parseException) {
            this.warning("Unable to parse revision string", new Object[0]);
            return null;
        }
    }

    public String getDateStringFor(Date date) {
        return this.getDateFormatter().format(date);
    }

    private SimpleDateFormat getDateFormatter() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(SvnFacade.getDateFormatter(this));
        TimeZone timeZone = SvnFacade.getDateTimezone(this);
        if (timeZone != null) {
            simpleDateFormat.setTimeZone(timeZone);
        }
        return simpleDateFormat;
    }

    public void verbose(String string, Object ... objectArray) {
        this.task.verbose(string, objectArray);
    }

    public void debug(String string, Object ... objectArray) {
        this.task.debug(string, objectArray);
    }

    public void warning(String string, Object ... objectArray) {
        this.task.warning(string, objectArray);
    }

    public void info(boolean bl, String string, Object ... objectArray) {
        this.task.info(bl, string, objectArray);
    }

    public void info(String string, Object ... objectArray) {
        this.task.info(string, objectArray);
    }

    public void error(String string, Object ... objectArray) {
        this.task.error(string, objectArray);
    }

    public void log(String string) {
        this.info(string, new Object[0]);
    }

    public void log(String string, int n) {
        switch (n) {
            case 4: {
                this.debug(string, new Object[0]);
                break;
            }
            case 0: {
                this.error(string, new Object[0]);
                break;
            }
            case 2: {
                this.info(string, new Object[0]);
                break;
            }
            case 3: {
                this.verbose(string, new Object[0]);
                break;
            }
            case 1: {
                this.warning(string, new Object[0]);
            }
        }
    }

    protected static final BuildException ex(String string, Object ... objectArray) {
        return new BuildException(String.format(string, objectArray));
    }

    protected static final BuildException ex(Exception exception, String string, Object ... objectArray) {
        return new BuildException(String.format(string, objectArray), (Throwable)exception);
    }
}

