/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnant.commands;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.DirSet;
import org.apache.tools.ant.types.FileSet;
import org.tigris.subversion.svnant.SvnAntUtilities;
import org.tigris.subversion.svnant.commands.SvnCommand;
import org.tigris.subversion.svnclientadapter.ISVNStatus;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNStatusKind;
import org.tigris.subversion.svnclientadapter.utils.SVNStatusUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceSetSvnCommand
extends SvnCommand {
    private static final String MSG_FAILED_TO_CALCULATE_UNMANAGED = "Failed to calculate unmanaged entries.";
    private File dir;
    private File file;
    private boolean recurse;
    private boolean incfiledirs;
    private List<FileSet> filesets;
    private List<DirSet> dirsets;
    private SVNStatusKind unmanageddirs;
    private boolean scanunmanaged;

    ResourceSetSvnCommand(boolean bl, boolean bl2) {
        this(bl, bl2, false, null);
    }

    ResourceSetSvnCommand(boolean bl, boolean bl2, boolean bl3, SVNStatusKind sVNStatusKind) {
        this.recurse = bl;
        this.incfiledirs = bl2;
        this.unmanageddirs = sVNStatusKind;
        this.scanunmanaged = bl3;
        this.dir = null;
        this.file = null;
        this.filesets = new ArrayList<FileSet>();
        this.dirsets = new ArrayList<DirSet>();
    }

    private File[] collectDirectories(List<File> list) {
        ArrayList<File> arrayList = new ArrayList<File>();
        if (this.dir != null) {
            arrayList.add(this.dir);
        }
        for (DirSet dirSet : this.dirsets) {
            this.collect(arrayList, list, dirSet);
        }
        return arrayList.toArray(new File[arrayList.size()]);
    }

    private File[] collectFiles(List<File> list) {
        ArrayList<File> arrayList = new ArrayList<File>();
        if (this.file != null) {
            arrayList.add(this.file);
        }
        for (FileSet fileSet : this.filesets) {
            this.collect(arrayList, list, fileSet);
        }
        return arrayList.toArray(new File[arrayList.size()]);
    }

    private void collect(List<File> list, List<File> list2, FileSet fileSet) {
        File file;
        String[] stringArray;
        DirectoryScanner directoryScanner = fileSet.getDirectoryScanner(this.getProject());
        File file2 = fileSet.getDir(this.getProject());
        if (this.incfiledirs) {
            for (String string : stringArray = directoryScanner.getIncludedDirectories()) {
                file = new File(file2, string);
                this.collectUnmanaged(list2, file2, file, false);
                list.add(file);
            }
        }
        for (String string : stringArray = directoryScanner.getIncludedFiles()) {
            file = new File(file2, string);
            this.collectUnmanaged(list2, file2, file.getParentFile(), false);
            list.add(file);
        }
    }

    private void collect(List<File> list, List<File> list2, DirSet dirSet) {
        String[] stringArray;
        DirectoryScanner directoryScanner = dirSet.getDirectoryScanner(this.getProject());
        File file = dirSet.getDir(this.getProject());
        for (String string : stringArray = directoryScanner.getIncludedDirectories()) {
            File file2 = new File(file, string);
            this.collectUnmanaged(list2, file, file2, true);
            list.add(file2);
        }
    }

    private void collectUnmanaged(List<File> list, File file, File file2, boolean bl) {
        if (!this.scanunmanaged) {
            return;
        }
        try {
            int n;
            Stack<File> stack = new Stack<File>();
            ISVNStatus iSVNStatus = this.getClient().getSingleStatus(file2);
            while (file2 != null && !file2.equals(file) && !(this.unmanageddirs == null ? SVNStatusUtils.isManaged((ISVNStatus)iSVNStatus) : iSVNStatus.getTextStatus() != this.unmanageddirs)) {
                stack.push(file2);
                file2 = file2.getParentFile();
                iSVNStatus = this.getClient().getSingleStatus(file2);
            }
            int n2 = n = bl ? 1 : 0;
            while (stack.size() > n) {
                File file3 = (File)stack.pop();
                if (list.contains(file3)) continue;
                list.add(file3);
            }
        }
        catch (SVNClientException sVNClientException) {
            throw ResourceSetSvnCommand.ex((Exception)((Object)sVNClientException), MSG_FAILED_TO_CALCULATE_UNMANAGED, new Object[0]);
        }
    }

    @Override
    protected void validateAttributes() {
        SvnAntUtilities.attrsNotSet("file, dir, fileset, dirset", this.file, this.dir, this.filesets, this.dirsets);
        if (this.file != null) {
            SvnAntUtilities.attrIsFile("file", this.file);
        }
        if (this.dir != null) {
            SvnAntUtilities.attrIsDirectory("dir", this.dir);
        }
    }

    @Override
    public final void execute() {
        this.handleBegin();
        ArrayList<File> arrayList = new ArrayList<File>();
        File[] fileArray = this.collectDirectories(arrayList);
        File[] fileArray2 = this.collectFiles(arrayList);
        for (File file : arrayList) {
            this.handleUnmanaged(file);
        }
        for (File file : fileArray) {
            this.handleDir(file, this.recurse);
        }
        for (File file : fileArray2) {
            if (!file.isDirectory()) continue;
            this.handleDir(file, false);
        }
        for (File file : fileArray2) {
            if (file.isDirectory()) continue;
            this.handleFile(file);
        }
        this.handleEnd();
    }

    protected void handleBegin() {
    }

    protected void handleUnmanaged(File file) {
    }

    protected void handleDir(File file, boolean bl) {
    }

    protected void handleFile(File file) {
    }

    protected void handleEnd() {
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setDir(File file) {
        this.dir = file;
    }

    protected void setRecurse(boolean bl) {
        this.recurse = bl;
    }

    public void addFileset(FileSet fileSet) {
        this.filesets.add(fileSet);
    }

    public void add(FileSet fileSet) {
        this.filesets.add(fileSet);
    }

    public void addDirset(DirSet dirSet) {
        this.dirsets.add(dirSet);
    }
}

