/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnant.commands;

import java.io.File;
import java.io.IOException;
import org.tigris.subversion.svnant.SvnAntUtilities;
import org.tigris.subversion.svnant.commands.SvnCommand;
import org.tigris.subversion.svnclientadapter.SVNClientException;

public class Propset
extends SvnCommand {
    private static final String MSG_CANT_SET_PROPERTY = "Can't set property %s";
    private File path = null;
    private File file;
    private String propName = null;
    private String propValue = null;
    private boolean recurse = false;

    public void execute() {
        try {
            if (this.propValue != null) {
                this.getClient().propertySet(this.path, this.propName, this.propValue, this.recurse);
            } else {
                this.getClient().propertySet(this.path, this.propName, this.file, this.recurse);
            }
        }
        catch (SVNClientException sVNClientException) {
            throw Propset.ex((Exception)((Object)sVNClientException), MSG_CANT_SET_PROPERTY, this.propName);
        }
        catch (IOException iOException) {
            throw Propset.ex(iOException, MSG_CANT_SET_PROPERTY, this.propName);
        }
    }

    protected void validateAttributes() {
        SvnAntUtilities.attrNotNull("path", this.path);
        SvnAntUtilities.attrNotEmpty("name", this.propName);
        SvnAntUtilities.attrsNotSet("value, file", true, new Object[]{this.propValue, this.file});
    }

    public void setPath(File file) {
        this.path = file;
    }

    public void setName(String string) {
        this.propName = string;
    }

    public void setValue(String string) {
        this.propValue = string;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setRecurse(boolean bl) {
        this.recurse = bl;
    }
}

