/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnant.commands;

import java.io.File;
import java.io.IOException;
import java.util.Stack;
import org.tigris.subversion.svnant.SvnAntUtilities;
import org.tigris.subversion.svnant.commands.SvnCommand;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class Mkdir
extends SvnCommand {
    private static final String MSG_CANONICAL = "Cannot determine canonical path of %s";
    private static final String MSG_CANT_MAKE_DIRECTORY = "Can't make dir %s";
    private SVNUrl url = null;
    private File path = null;
    private String message = null;
    private boolean makeparents = false;

    public void execute() {
        if (this.url != null) {
            try {
                this.getClient().mkdir(this.url, this.makeparents, this.message);
            }
            catch (SVNClientException sVNClientException) {
                throw Mkdir.ex((Exception)((Object)sVNClientException), MSG_CANT_MAKE_DIRECTORY, this.url);
            }
        }
        try {
            if (this.makeparents) {
                try {
                    this.path = this.path.getCanonicalFile();
                }
                catch (IOException iOException) {
                    throw Mkdir.ex(iOException, MSG_CANONICAL, this.path);
                }
                Stack<File> stack = new Stack<File>();
                while (!this.path.isDirectory()) {
                    stack.push(this.path);
                    this.path = this.path.getParentFile();
                }
                while (!stack.isEmpty()) {
                    this.getClient().mkdir((File)stack.pop());
                }
            }
            this.getClient().mkdir(this.path);
        }
        catch (SVNClientException sVNClientException) {
            throw Mkdir.ex((Exception)((Object)sVNClientException), MSG_CANT_MAKE_DIRECTORY, this.path);
        }
    }

    protected void validateAttributes() {
        SvnAntUtilities.attrsNotSet("url, path", true, new Object[]{this.url, this.path});
        if (this.url != null) {
            SvnAntUtilities.attrNotEmpty("message", this.message);
        }
    }

    public void setUrl(SVNUrl sVNUrl) {
        this.url = sVNUrl;
    }

    public void setPath(File file) {
        this.path = file;
    }

    public void setMessage(String string) {
        this.message = string;
    }

    public void setMakeParents(boolean bl) {
        this.makeparents = bl;
    }
}

