/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnant.commands;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.tigris.subversion.svnant.SvnAntUtilities;
import org.tigris.subversion.svnant.commands.ResourceSetSvnCommand;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNStatusKind;

public class Commit
extends ResourceSetSvnCommand {
    private static final String MSG_CANT_COMMIT_RESOURCES = "Can't commit resources !";
    private String message = null;
    private List<File> recursivecommit = new ArrayList<File>();
    private List<File> nonrecursivecommit = new ArrayList<File>();

    public Commit() {
        super(true, true, true, SVNStatusKind.ADDED);
    }

    protected void handleBegin() {
        this.recursivecommit.clear();
        this.nonrecursivecommit.clear();
    }

    protected void handleUnmanaged(File file) {
        this.nonrecursivecommit.add(file);
    }

    protected void handleDir(File file, boolean bl) {
        if (bl) {
            this.recursivecommit.add(file);
        } else {
            this.nonrecursivecommit.add(file);
        }
    }

    protected void handleFile(File file) {
        this.nonrecursivecommit.add(file);
    }

    protected void handleEnd() {
        File[] fileArray;
        if (!this.nonrecursivecommit.isEmpty()) {
            try {
                fileArray = this.nonrecursivecommit.toArray(new File[this.nonrecursivecommit.size()]);
                this.getClient().commit(fileArray, this.message, false);
            }
            catch (SVNClientException sVNClientException) {
                throw Commit.ex((Exception)((Object)sVNClientException), MSG_CANT_COMMIT_RESOURCES, new Object[0]);
            }
        }
        if (!this.recursivecommit.isEmpty()) {
            try {
                fileArray = this.recursivecommit.toArray(new File[this.recursivecommit.size()]);
                this.getClient().commit(fileArray, this.message, true);
            }
            catch (SVNClientException sVNClientException) {
                throw Commit.ex((Exception)((Object)sVNClientException), MSG_CANT_COMMIT_RESOURCES, new Object[0]);
            }
        }
    }

    protected void validateAttributes() {
        super.validateAttributes();
        SvnAntUtilities.attrNotEmpty("message", this.message);
    }

    public void setRecurse(boolean bl) {
        super.setRecurse(bl);
    }

    public void setMessage(String string) {
        this.message = string;
    }
}

