/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnant;

import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Reference;
import org.tigris.subversion.svnant.SvnFacade;
import org.tigris.subversion.svnant.commands.Add;
import org.tigris.subversion.svnant.commands.Cat;
import org.tigris.subversion.svnant.commands.Checkout;
import org.tigris.subversion.svnant.commands.Cleanup;
import org.tigris.subversion.svnant.commands.Commit;
import org.tigris.subversion.svnant.commands.Copy;
import org.tigris.subversion.svnant.commands.CreateRepository;
import org.tigris.subversion.svnant.commands.Delete;
import org.tigris.subversion.svnant.commands.Diff;
import org.tigris.subversion.svnant.commands.DiffSummarize;
import org.tigris.subversion.svnant.commands.Export;
import org.tigris.subversion.svnant.commands.Feedback;
import org.tigris.subversion.svnant.commands.Ignore;
import org.tigris.subversion.svnant.commands.Import;
import org.tigris.subversion.svnant.commands.Info;
import org.tigris.subversion.svnant.commands.Keywordsadd;
import org.tigris.subversion.svnant.commands.Keywordsremove;
import org.tigris.subversion.svnant.commands.Keywordsset;
import org.tigris.subversion.svnant.commands.List;
import org.tigris.subversion.svnant.commands.Log;
import org.tigris.subversion.svnant.commands.Mkdir;
import org.tigris.subversion.svnant.commands.Move;
import org.tigris.subversion.svnant.commands.Propdel;
import org.tigris.subversion.svnant.commands.Propget;
import org.tigris.subversion.svnant.commands.Propset;
import org.tigris.subversion.svnant.commands.Revert;
import org.tigris.subversion.svnant.commands.SingleInfo;
import org.tigris.subversion.svnant.commands.Status;
import org.tigris.subversion.svnant.commands.SvnCommand;
import org.tigris.subversion.svnant.commands.Switch;
import org.tigris.subversion.svnant.commands.Update;
import org.tigris.subversion.svnant.commands.WcVersion;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNNotifyListener;

public class SvnTask
extends Task {
    private static final String MSG_DEPRECATION = "Deprecated attribute '%s'. This attribute will disappear with SVNANT 1.3.2. Use svnSetting instead.";
    private java.util.List<SvnCommand> commands = new ArrayList<SvnCommand>();
    private java.util.List<ISVNNotifyListener> notifyListeners = new ArrayList<ISVNNotifyListener>();
    private CharArrayWriter writer = new CharArrayWriter();
    private PrintWriter printer = new PrintWriter(this.writer);
    private PrintWriter logprinter = null;
    private File logfile = null;

    public void setLogFile(File file) {
        this.logfile = file;
    }

    public ProjectComponent getProjectComponent() {
        return this;
    }

    public void setRefid(Reference reference) {
        SvnFacade.setRefid((ProjectComponent)this, reference);
    }

    public void setUsername(String string) {
        this.warning(MSG_DEPRECATION, "username");
        SvnFacade.setUsername((ProjectComponent)this, string);
    }

    public void setPassword(String string) {
        this.warning(MSG_DEPRECATION, "password");
        SvnFacade.setPassword((ProjectComponent)this, string);
    }

    public void setJavahl(boolean bl) {
        this.warning(MSG_DEPRECATION, "javahl");
        SvnFacade.setJavahl((ProjectComponent)this, bl);
    }

    public void setSvnkit(boolean bl) {
        this.warning(MSG_DEPRECATION, "svnkit");
        SvnFacade.setSvnKit((ProjectComponent)this, bl);
    }

    public void setDateFormatter(String string) {
        this.warning(MSG_DEPRECATION, "dateformatter");
        SvnFacade.setDateFormatter((ProjectComponent)this, string);
    }

    public void setDateTimezone(String string) {
        this.warning(MSG_DEPRECATION, "datetimezone");
        SvnFacade.setDateTimezone((ProjectComponent)this, string);
    }

    public void setFailonerror(boolean bl) {
        this.warning(MSG_DEPRECATION, "failonerror");
        SvnFacade.setFailonerror((ProjectComponent)this, bl);
    }

    public void addCheckout(Checkout checkout) {
        this.addCommand(checkout);
    }

    public void addSingleinfo(SingleInfo singleInfo) {
        this.addCommand(singleInfo);
    }

    public void addList(List list) {
        this.addCommand(list);
    }

    public void addAdd(Add add) {
        this.addCommand(add);
    }

    public void addCleanup(Cleanup cleanup) {
        this.addCommand(cleanup);
    }

    public void addCommit(Commit commit) {
        this.addCommand(commit);
    }

    public void addCopy(Copy copy) {
        this.addCommand(copy);
    }

    public void addDelete(Delete delete) {
        this.addCommand(delete);
    }

    public void addExport(Export export) {
        this.addCommand(export);
    }

    public void addInfo(Info info) {
        this.addCommand(info);
    }

    public void addImport(Import import_) {
        this.addCommand(import_);
    }

    public void addLog(Log log) {
        this.addCommand(log);
    }

    public void addMkdir(Mkdir mkdir) {
        this.addCommand(mkdir);
    }

    public void addMove(Move move) {
        this.addCommand(move);
    }

    public void addUpdate(Update update) {
        this.addCommand(update);
    }

    public void addPropset(Propset propset) {
        this.addCommand(propset);
    }

    public void addDiff(Diff diff) {
        this.addCommand(diff);
    }

    public void addDiffSummarize(DiffSummarize diffSummarize) {
        this.addCommand(diffSummarize);
    }

    public void addKeywordsSet(Keywordsset keywordsset) {
        this.addCommand(keywordsset);
    }

    public void addKeywordsAdd(Keywordsadd keywordsadd) {
        this.addCommand(keywordsadd);
    }

    public void addKeywordsRemove(Keywordsremove keywordsremove) {
        this.addCommand(keywordsremove);
    }

    public void addRevert(Revert revert) {
        this.addCommand(revert);
    }

    public void addCat(Cat cat) {
        this.addCommand(cat);
    }

    public void addPropdel(Propdel propdel) {
        this.addCommand(propdel);
    }

    public void addIgnore(Ignore ignore) {
        this.addCommand(ignore);
    }

    public void addCreateRepository(CreateRepository createRepository) {
        this.addCommand(createRepository);
    }

    public void addWcVersion(WcVersion wcVersion) {
        this.addCommand(wcVersion);
    }

    public void addStatus(Status status) {
        this.addCommand(status);
    }

    public void addSwitch(Switch switch_) {
        this.addCommand(switch_);
    }

    public void addPropget(Propget propget) {
        this.addCommand(propget);
    }

    private void addCommand(SvnCommand svnCommand) {
        svnCommand.setTask(this);
        this.commands.add(svnCommand);
    }

    public void addNotifyListener(ISVNNotifyListener iSVNNotifyListener) {
        this.notifyListeners.add(iSVNNotifyListener);
    }

    private Object[] alter(Object[] objectArray) {
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                if (!(objectArray[i] instanceof Throwable)) continue;
                this.writer.reset();
                Throwable throwable = (Throwable)objectArray[i];
                throwable.printStackTrace(this.printer);
                objectArray[i] = String.valueOf(this.writer.toCharArray());
            }
        }
        return objectArray;
    }

    public void verbose(String string, Object ... objectArray) {
        if (objectArray == null || objectArray.length == 0) {
            this.write(string, 3);
        } else {
            this.write(String.format(string, this.alter(objectArray)), 3);
        }
    }

    public void debug(String string, Object ... objectArray) {
        if (objectArray == null || objectArray.length == 0) {
            this.write(string, 4);
        } else {
            this.write(String.format(string, this.alter(objectArray)), 4);
        }
    }

    public void warning(String string, Object ... objectArray) {
        if (objectArray == null || objectArray.length == 0) {
            this.write(string, 1);
        } else {
            this.write(String.format(string, this.alter(objectArray)), 1);
        }
    }

    public void info(boolean bl, String string, Object ... objectArray) {
        if (objectArray == null || objectArray.length == 0) {
            this.write(string, bl ? 3 : 2);
        } else {
            this.write(String.format(string, this.alter(objectArray)), bl ? 3 : 2);
        }
    }

    public void info(String string, Object ... objectArray) {
        if (objectArray == null || objectArray.length == 0) {
            this.write(string, 2);
        } else {
            this.write(String.format(string, this.alter(objectArray)), 2);
        }
    }

    public void error(String string, Object ... objectArray) {
        if (objectArray == null || objectArray.length == 0) {
            this.write(string, 0);
        } else {
            this.write(String.format(string, this.alter(objectArray)), 0);
        }
    }

    private void write(String string, int n) {
        if (this.logprinter != null) {
            this.logprinter.println(string);
        } else {
            this.log(string, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        try {
            if (this.logfile != null) {
                this.logprinter = new PrintWriter(new FileWriter(this.logfile));
            }
            this.executeImpl();
        }
        catch (Exception exception) {
            if (SvnFacade.getFailonerror((ProjectComponent)this)) {
                if (exception instanceof BuildException) {
                    throw (BuildException)exception;
                }
                throw new BuildException((Throwable)exception);
            }
            this.error("the execution failed for some reason. cause: %s", exception);
        }
        finally {
            if (this.logprinter != null) {
                this.logprinter.close();
            }
        }
    }

    private void executeImpl() {
        int n;
        ISVNClientAdapter iSVNClientAdapter = SvnFacade.getClientAdapter((ProjectComponent)this);
        for (n = 0; n < this.notifyListeners.size(); ++n) {
            iSVNClientAdapter.addNotifyListener(this.notifyListeners.get(n));
        }
        for (n = 0; n < this.commands.size(); ++n) {
            SvnCommand svnCommand = this.commands.get(n);
            Feedback feedback = new Feedback(svnCommand);
            iSVNClientAdapter.addNotifyListener((ISVNNotifyListener)feedback);
            svnCommand.executeCommand(iSVNClientAdapter);
            iSVNClientAdapter.removeNotifyListener((ISVNNotifyListener)feedback);
        }
    }
}

