/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnant;

import java.io.File;
import java.util.TimeZone;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.types.Reference;
import org.tigris.subversion.svnant.commands.SvnCommand;
import org.tigris.subversion.svnant.types.SvnSetting;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNPromptUserPassword;
import org.tigris.subversion.svnclientadapter.SVNClientAdapterFactory;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.commandline.CmdLineClientAdapterFactory;
import org.tigris.subversion.svnclientadapter.javahl.JhlClientAdapterFactory;
import org.tigris.subversion.svnclientadapter.svnkit.SvnKitClientAdapterFactory;

public class SvnFacade {
    private static final String MSG_MISSING_DEPENDENCY = "Missing '%s' dependencies on the classpath !";
    private static final String DEFAULT_DATEFORMATTER = "MM/dd/yyyy hh:mm a";
    private static final Boolean DEFAULT_SVNKIT = Boolean.FALSE;
    private static final Boolean DEFAULT_JAVAHL = Boolean.TRUE;
    private static final Boolean DEFAULT_FAILONERROR = Boolean.TRUE;
    private static final String KEY_FACADE = "org.tigris.subversion.svnant.SvnFacade";
    private static Boolean javahlAvailable = null;
    private static Boolean svnKitAvailable = null;
    private static Boolean commandLineAvailable = null;
    private SvnSetting setting = new SvnSetting(null);
    private SvnSetting refidsetting = null;
    private Reference refid = null;

    private static final SvnFacade getFacade(ProjectComponent object) {
        if (object instanceof SvnCommand) {
            object = ((SvnCommand)((Object)object)).getTask();
        }
        String string = KEY_FACADE + object.hashCode();
        SvnFacade svnFacade = (SvnFacade)object.getProject().getReference(string);
        if (svnFacade == null) {
            svnFacade = new SvnFacade();
            object.getProject().addReference(string, (Object)svnFacade);
        }
        return svnFacade;
    }

    private static final SvnSetting getSetting(ProjectComponent projectComponent) {
        return SvnFacade.getFacade((ProjectComponent)projectComponent).setting;
    }

    private static final SvnSetting getRefidSetting(ProjectComponent projectComponent) {
        SvnFacade svnFacade = SvnFacade.getFacade(projectComponent);
        if (svnFacade.refidsetting == null) {
            if (svnFacade.refid != null) {
                Object object = svnFacade.refid.getReferencedObject(projectComponent.getProject());
                if (object == null) {
                    throw new BuildException("The refid attribute value '" + svnFacade.refid + "' doesn't refer to any object.");
                }
                if (!(object instanceof SvnSetting)) {
                    throw new BuildException("The refid attribute value '" + svnFacade.refid + "' has an unknown type [" + object.getClass().getName() + "].");
                }
                svnFacade.refidsetting = (SvnSetting)((Object)object);
            } else {
                svnFacade.refidsetting = svnFacade.setting;
            }
        }
        return svnFacade.refidsetting;
    }

    public static final void setRefid(ProjectComponent projectComponent, Reference reference) {
        SvnFacade.getFacade((ProjectComponent)projectComponent).refid = reference;
    }

    public static final void setJavahl(ProjectComponent projectComponent, boolean bl) {
        SvnFacade.getSetting(projectComponent).setJavahl(bl);
    }

    public static final boolean getJavahl(ProjectComponent projectComponent) {
        Boolean bl = SvnFacade.getSetting(projectComponent).getJavahl();
        if (bl == null) {
            bl = SvnFacade.getRefidSetting(projectComponent).getJavahl();
        }
        if (bl == null) {
            bl = DEFAULT_JAVAHL;
        }
        return bl;
    }

    public static final void setSvnKit(ProjectComponent projectComponent, boolean bl) {
        SvnFacade.getSetting(projectComponent).setSvnKit(bl);
    }

    public static final boolean getSvnKit(ProjectComponent projectComponent) {
        Boolean bl = SvnFacade.getSetting(projectComponent).getSvnKit();
        if (bl == null) {
            bl = SvnFacade.getRefidSetting(projectComponent).getSvnKit();
        }
        if (bl == null) {
            bl = DEFAULT_SVNKIT;
        }
        return bl;
    }

    public static final void setUsername(ProjectComponent projectComponent, String string) {
        SvnFacade.getSetting(projectComponent).setUsername(string);
    }

    public static final String getUsername(ProjectComponent projectComponent) {
        String string = SvnFacade.getSetting(projectComponent).getUsername();
        if (string == null) {
            string = SvnFacade.getRefidSetting(projectComponent).getUsername();
        }
        return string;
    }

    public static final void setPassword(ProjectComponent projectComponent, String string) {
        SvnFacade.getSetting(projectComponent).setPassword(string);
    }

    public static final String getPassword(ProjectComponent projectComponent) {
        String string = SvnFacade.getSetting(projectComponent).getPassword();
        if (string == null) {
            string = SvnFacade.getRefidSetting(projectComponent).getPassword();
        }
        return string;
    }

    public static final void setSSLPassword(ProjectComponent projectComponent, String string) {
        SvnFacade.getSetting(projectComponent).setSSLPassword(string);
    }

    public static final String getSSLPassword(ProjectComponent projectComponent) {
        String string = SvnFacade.getSetting(projectComponent).getSSLPassword();
        if (string == null) {
            string = SvnFacade.getRefidSetting(projectComponent).getSSLPassword();
        }
        return string;
    }

    public static final void setSSLClientCertPath(ProjectComponent projectComponent, File file) {
        SvnFacade.getSetting(projectComponent).setSSLClientCertPath(file);
    }

    public static final File getSSLClientCertPath(ProjectComponent projectComponent) {
        File file = SvnFacade.getSetting(projectComponent).getSSLClientCertPath();
        if (file == null) {
            file = SvnFacade.getRefidSetting(projectComponent).getSSLClientCertPath();
        }
        return file;
    }

    public static final void setSSHPort(ProjectComponent projectComponent, Integer n) {
        SvnFacade.getSetting(projectComponent).setSSHPort(n);
    }

    public static final Integer getSSHPort(ProjectComponent projectComponent) {
        Integer n = SvnFacade.getSetting(projectComponent).getSSHPort();
        if (n == null) {
            n = SvnFacade.getRefidSetting(projectComponent).getSSHPort();
        }
        return n;
    }

    public static final void setSSHPassphrase(ProjectComponent projectComponent, String string) {
        SvnFacade.getSetting(projectComponent).setSSHPassphrase(string);
    }

    public static final String getSSHPassphrase(ProjectComponent projectComponent) {
        String string = SvnFacade.getSetting(projectComponent).getSSHPassphrase();
        if (string == null) {
            string = SvnFacade.getRefidSetting(projectComponent).getSSHPassphrase();
        }
        return string;
    }

    public static final void setSSHKeyPath(ProjectComponent projectComponent, File file) {
        SvnFacade.getSetting(projectComponent).setSSHKeyPath(file);
    }

    public static final File getSSHKeyPath(ProjectComponent projectComponent) {
        File file = SvnFacade.getSetting(projectComponent).getSSHKeyPath();
        if (file == null) {
            file = SvnFacade.getRefidSetting(projectComponent).getSSHKeyPath();
        }
        return file;
    }

    public static final void setCertReject(ProjectComponent projectComponent, Boolean bl) {
        SvnFacade.getSetting(projectComponent).setCertReject(bl);
    }

    public static final Boolean getCertReject(ProjectComponent projectComponent) {
        Boolean bl = SvnFacade.getSetting(projectComponent).getCertReject();
        if (bl == null) {
            bl = SvnFacade.getRefidSetting(projectComponent).getCertReject();
        }
        return bl;
    }

    public static final void setDateFormatter(ProjectComponent projectComponent, String string) {
        SvnFacade.getSetting(projectComponent).setDateFormatter(string);
    }

    public static final String getDateFormatter(ProjectComponent projectComponent) {
        String string = SvnFacade.getSetting(projectComponent).getDateFormatter();
        if (string == null || string.length() == 0) {
            string = SvnFacade.getRefidSetting(projectComponent).getDateFormatter();
        }
        if (string == null || string.length() == 0) {
            string = DEFAULT_DATEFORMATTER;
        }
        return string;
    }

    public static final void setDateTimezone(ProjectComponent projectComponent, String string) {
        SvnFacade.getSetting(projectComponent).setDateTimezone(string);
    }

    public static final TimeZone getDateTimezone(ProjectComponent projectComponent) {
        String string = SvnFacade.getSetting(projectComponent).getDateTimezone();
        if (string == null || string.length() == 0) {
            string = SvnFacade.getRefidSetting(projectComponent).getDateTimezone();
        }
        if (string == null || string.length() == 0) {
            return null;
        }
        return TimeZone.getTimeZone(string);
    }

    public static final void setFailonerror(ProjectComponent projectComponent, boolean bl) {
        SvnFacade.getSetting(projectComponent).setFailonerror(bl);
    }

    public static final boolean getFailonerror(ProjectComponent projectComponent) {
        Boolean bl = SvnFacade.getSetting(projectComponent).getFailonerror();
        if (bl == null) {
            bl = SvnFacade.getRefidSetting(projectComponent).getFailonerror();
        }
        if (bl == null) {
            bl = DEFAULT_FAILONERROR;
        }
        return bl;
    }

    private static final boolean isJavahlAvailable() {
        if (javahlAvailable == null) {
            javahlAvailable = Boolean.FALSE;
            try {
                JhlClientAdapterFactory.setup();
            }
            catch (SVNClientException sVNClientException) {
                // empty catch block
            }
            try {
                if (SVNClientAdapterFactory.isSVNClientAvailable((String)"javahl")) {
                    javahlAvailable = Boolean.TRUE;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return javahlAvailable;
    }

    private static final boolean isSVNKitAvailable() {
        if (svnKitAvailable == null) {
            svnKitAvailable = Boolean.FALSE;
            try {
                SvnKitClientAdapterFactory.setup();
            }
            catch (SVNClientException sVNClientException) {
                // empty catch block
            }
            try {
                if (SVNClientAdapterFactory.isSVNClientAvailable((String)"svnkit")) {
                    svnKitAvailable = Boolean.TRUE;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return svnKitAvailable;
    }

    private static final boolean isCommandLineAvailable() {
        if (commandLineAvailable == null) {
            commandLineAvailable = Boolean.FALSE;
            try {
                CmdLineClientAdapterFactory.setup();
            }
            catch (SVNClientException sVNClientException) {
                // empty catch block
            }
            try {
                if (SVNClientAdapterFactory.isSVNClientAvailable((String)"commandline")) {
                    commandLineAvailable = Boolean.TRUE;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return commandLineAvailable;
    }

    public static final synchronized ISVNClientAdapter getClientAdapter(ProjectComponent projectComponent) throws BuildException {
        ISVNClientAdapter iSVNClientAdapter = null;
        boolean bl = SvnFacade.getJavahl(projectComponent);
        boolean bl2 = SvnFacade.getSvnKit(projectComponent);
        boolean bl3 = false;
        if (bl) {
            if (SvnFacade.isJavahlAvailable()) {
                iSVNClientAdapter = SVNClientAdapterFactory.createSVNClient((String)"javahl");
                projectComponent.log("Using javahl", 3);
            } else {
                projectComponent.log(String.format(MSG_MISSING_DEPENDENCY, "javahl"), 0);
            }
        }
        if (bl2 && iSVNClientAdapter == null) {
            if (SvnFacade.isSVNKitAvailable()) {
                iSVNClientAdapter = SVNClientAdapterFactory.createSVNClient((String)"svnkit");
                projectComponent.log("Using svnkit", 3);
            } else {
                projectComponent.log(String.format(MSG_MISSING_DEPENDENCY, "svnkit"), 0);
            }
        }
        if (!bl && !bl2) {
            if (SvnFacade.isCommandLineAvailable()) {
                iSVNClientAdapter = SVNClientAdapterFactory.createSVNClient((String)"commandline");
                bl3 = true;
                projectComponent.log("Using command line", 3);
            } else {
                projectComponent.log(String.format(MSG_MISSING_DEPENDENCY, "commandline"), 0);
            }
        }
        if (iSVNClientAdapter == null) {
            throw new BuildException("Cannot find javahl, svnkit nor command line svn client");
        }
        if (SvnFacade.getUsername(projectComponent) != null) {
            iSVNClientAdapter.setUsername(SvnFacade.getUsername(projectComponent));
        }
        if (bl3) {
            if (SvnFacade.getPassword(projectComponent) != null) {
                iSVNClientAdapter.setPassword(SvnFacade.getPassword(projectComponent));
            }
        } else {
            iSVNClientAdapter.addPasswordCallback((ISVNPromptUserPassword)new DefaultPasswordCallback(SvnFacade.getUsername(projectComponent), SvnFacade.getPassword(projectComponent), SvnFacade.getSSHKeyPath(projectComponent), SvnFacade.getSSHPassphrase(projectComponent), SvnFacade.getSSHPort(projectComponent), SvnFacade.getSSLClientCertPath(projectComponent), SvnFacade.getSSLPassword(projectComponent), SvnFacade.getCertReject(projectComponent)));
        }
        return iSVNClientAdapter;
    }

    private static class DefaultPasswordCallback
    implements ISVNPromptUserPassword {
        private String username;
        private String password;
        private String sshprivatekeypath;
        private String sshpassphrase;
        private String sslclientcertpath;
        private String sslcertpassword;
        private Integer sshport;
        private Boolean reject;

        public DefaultPasswordCallback(String string, String string2, File file, String string3, Integer n, File file2, String string4, Boolean bl) {
            this.username = string;
            this.password = string2;
            this.sshprivatekeypath = file != null ? file.getAbsolutePath() : null;
            this.sshpassphrase = string3;
            this.sshport = n;
            this.sslclientcertpath = file2 != null ? file2.getAbsolutePath() : null;
            this.sslcertpassword = string4;
            this.reject = bl;
        }

        public boolean promptSSL(String string, boolean bl) {
            return this.sslclientcertpath != null || this.sslcertpassword != null;
        }

        public String getSSLClientCertPassword() {
            return this.sslclientcertpath;
        }

        public String getSSLClientCertPath() {
            return this.sslcertpassword;
        }

        public int askTrustSSLServer(String string, boolean bl) {
            if (Boolean.TRUE.equals(this.reject)) {
                return 0;
            }
            return 1;
        }

        public String getSSHPrivateKeyPath() {
            return this.sshprivatekeypath;
        }

        public String getSSHPrivateKeyPassphrase() {
            return this.sshpassphrase;
        }

        public boolean promptSSH(String string, String string2, int n, boolean bl) {
            if (n > 0) {
                this.sshport = n;
            }
            return this.sshpassphrase != null || this.sshprivatekeypath != null;
        }

        public int getSSHPort() {
            if (this.sshport == null) {
                return 22;
            }
            return this.sshport;
        }

        public boolean userAllowedSave() {
            return false;
        }

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }

        public String askQuestion(String string, String string2, boolean bl, boolean bl2) {
            return "";
        }

        public boolean prompt(String string, String string2, boolean bl) {
            return true;
        }

        public boolean promptUser(String string, String string2, boolean bl) {
            return true;
        }

        public boolean askYesNo(String string, String string2, boolean bl) {
            return bl;
        }
    }
}

