/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.sql.jdbc.internal;

import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.cloud.sql.jdbc.internal.Charsets;
import com.google.cloud.sql.jdbc.internal.Exceptions;
import com.google.cloud.sql.jdbc.internal.Util;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.FilterWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.CharBuffer;
import java.sql.Clob;
import java.sql.SQLException;
import java.util.Arrays;

public class ClientSideClob
implements Clob {
    private char[] data;

    public ClientSideClob(char[] data) {
        this.data = (char[])data.clone();
    }

    ClientSideClob(ByteString data) {
        CharBuffer buf = Charsets.UTF_8.decode(data.asReadOnlyByteBuffer());
        if (buf.hasArray()) {
            this.data = ClientSideClob.extractChars(buf);
        } else {
            this.data = new char[buf.length()];
            buf.get(this.data);
        }
    }

    @Override
    public long length() throws SQLException {
        this.throwIfFreed();
        return this.data.length;
    }

    @Override
    public String getSubString(long pos, int length) throws SQLException {
        this.throwIfFreed();
        Util.checkArgument(pos >= 1L && pos <= (long)this.data.length, "pos", pos);
        Util.checkArgument(length > 0 && (long)length < pos + (long)this.data.length, "length", length);
        int index = (int)(pos - 1L);
        return new String(this.data, index, length);
    }

    @Override
    public Reader getCharacterStream() throws SQLException {
        this.throwIfFreed();
        return new CharArrayReader(this.data);
    }

    @Override
    public InputStream getAsciiStream() throws SQLException {
        this.throwIfFreed();
        return new ByteArrayInputStream(new String(this.data).getBytes(Charsets.US_ASCII));
    }

    @Override
    public long position(String searchstr, long start) throws SQLException {
        this.throwIfFreed();
        Util.checkArgument(start >= 1L, "start", start);
        long result = ClientSideClob.indexOf(this.data, searchstr, start - 1L);
        return result == -1L ? -1L : result + 1L;
    }

    @Override
    public long position(Clob searchclob, long start) throws SQLException {
        this.throwIfFreed();
        Util.checkArgument(start >= 1L, "start", start);
        String searchstr = searchclob.getSubString(1L, (int)searchclob.length());
        return this.position(searchstr, start);
    }

    @Override
    public int setString(long pos, String str) throws SQLException {
        this.throwIfFreed();
        Util.checkArgument(pos >= 1L, "pos", pos);
        if (pos == 1L && str.length() == this.data.length) {
            this.data = str.toCharArray();
            return this.data.length;
        }
        return this.setString(pos, str, 0, str.length());
    }

    @Override
    public int setString(long pos, String str, int offset, int len) throws SQLException {
        this.throwIfFreed();
        Util.checkArgument(pos >= 1L, "pos", pos);
        if (--pos + (long)len > (long)this.data.length) {
            this.resize(pos + (long)len);
        }
        char[] chars = str.substring(offset, offset + len).toCharArray();
        System.arraycopy(chars, 0, this.data, (int)pos, len);
        return len;
    }

    @Override
    public OutputStream setAsciiStream(long pos) throws SQLException {
        this.throwIfFreed();
        Util.checkArgument(pos >= 1L, "pos", pos);
        return new ClobAsciiOutputStream(this, pos);
    }

    @Override
    public Writer setCharacterStream(long pos) throws SQLException {
        this.throwIfFreed();
        Util.checkArgument(pos >= 1L, "pos", pos);
        return new ClobCharacterWriter(this, pos);
    }

    @Override
    public void truncate(long len) throws SQLException {
        this.throwIfFreed();
        Util.checkArgument(len > 0L, "len", len);
        if (len > (long)this.data.length) {
            return;
        }
        this.resize(len);
    }

    @Override
    public Reader getCharacterStream(long pos, long length) throws SQLException {
        this.throwIfFreed();
        Util.checkArgument(pos >= 1L && pos <= (long)this.data.length, "pos", pos);
        Util.checkArgument(length > 0L && length < pos + (long)this.data.length, "length", length);
        int start = (int)(pos - 1L);
        return new CharArrayReader(this.data, start, (int)length);
    }

    @Override
    public void free() throws SQLException {
        this.throwIfFreed();
        this.data = null;
    }

    ByteString toByteString() {
        return ByteString.copyFrom(Charsets.UTF_8.encode(CharBuffer.wrap(this.data)));
    }

    private int setChars(long pos, char[] chars, int offset, int len) throws SQLException {
        this.throwIfFreed();
        Util.checkArgument(pos >= 1L, "pos", pos);
        if (--pos + (long)len > (long)this.data.length) {
            this.resize(pos + (long)len);
        }
        System.arraycopy(chars, offset, this.data, (int)pos, len);
        return len;
    }

    private void throwIfFreed() throws SQLException {
        if (this.data == null) {
            throw Exceptions.newStatementClosedException();
        }
    }

    private void resize(long length) {
        this.data = Arrays.copyOf(this.data, (int)length);
    }

    public int hashCode() {
        return Arrays.hashCode(this.data);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ClientSideClob)) {
            return false;
        }
        return Arrays.equals(this.data, ((ClientSideClob)obj).data);
    }

    public String toString() {
        if (this.data == null) {
            return "(null)";
        }
        int maxLength = Math.min(this.data.length, 100);
        StringBuilder s = new StringBuilder(maxLength + 3);
        for (int i = 0; i < maxLength; ++i) {
            s.append(this.data[i]);
        }
        if (maxLength < this.data.length) {
            s.append("...");
        }
        return s.toString();
    }

    private static long indexOf(char[] data, CharSequence searchstr, long start) throws SQLException {
        Util.checkNotNull(data, "data");
        Util.checkNotNull(searchstr, "searchstr");
        Util.checkArgument(searchstr.length() > 0, "searchstr", searchstr.length());
        Util.checkArgument(start >= 0L, "start", start);
        block0: for (int i = (int)start; i < data.length - searchstr.length() + 1; ++i) {
            for (int j = 0; j < searchstr.length(); ++j) {
                if (data[i + j] != searchstr.charAt(j)) continue block0;
            }
            return i;
        }
        return -1L;
    }

    private static char[] extractChars(CharBuffer buf) {
        if (buf.hasArray() && buf.arrayOffset() == 0 && buf.position() == 0 && buf.limit() == buf.capacity()) {
            return buf.array();
        }
        char[] result = new char[buf.remaining()];
        buf.get(result);
        buf.position(buf.position() - result.length);
        return result;
    }

    private static class ClobCharacterWriter
    extends FilterWriter {
        private final ClientSideClob clob;
        private final long startPosition;

        private ClobCharacterWriter(ClientSideClob clob, long startPosition) {
            super(new CharArrayWriter());
            this.clob = clob;
            this.startPosition = startPosition;
        }

        @Override
        public void close() throws IOException {
            this.out.close();
            char[] chars = ((CharArrayWriter)this.out).toCharArray();
            try {
                this.clob.setChars(this.startPosition, chars, 0, chars.length);
            }
            catch (SQLException e) {
                throw new IOException(e.getMessage(), e);
            }
        }
    }

    private static class ClobAsciiOutputStream
    extends OutputStream {
        private final ByteArrayOutputStream out = new ByteArrayOutputStream();
        private final ClientSideClob clob;
        private final long startPosition;

        private ClobAsciiOutputStream(ClientSideClob clob, long startPosition) {
            this.clob = clob;
            this.startPosition = startPosition;
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.out.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) {
            this.out.write(b, off, len);
        }

        @Override
        public void flush() throws IOException {
            this.out.flush();
        }

        @Override
        public void close() throws IOException {
            this.out.close();
            try {
                byte[] bytes = this.out.toByteArray();
                String data = new String(bytes, Charsets.US_ASCII);
                this.clob.setString(this.startPosition, data);
            }
            catch (SQLException e) {
                throw new IOException(e.getMessage(), e);
            }
        }

        @Override
        public void write(int b) {
            this.out.write(b);
        }
    }
}

