/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.client.datastoreservice.intern;

import com.google.appengine.repackaged.com.google.common.collect.Lists;
import com.google.appengine.repackaged.com.google.net.util.error.Codes;
import com.google.appengine.repackaged.com.google.protobuf.InvalidProtocolBufferException;
import com.google.appengine.repackaged.com.google.protobuf.Parser;
import com.google.apphosting.client.datastoreservice.api.DatastoreServiceRpcProto;
import com.google.apphosting.client.datastoreservice.intern.EntityV4Normalizer;
import com.google.apphosting.client.datastoreservice.intern.EntityWrapperTranslator;
import com.google.apphosting.client.datastoreservice.intern.GetHandler;
import com.google.apphosting.client.datastoreservice.intern.InternDatastoreRpcService;
import com.google.apphosting.client.datastoreservice.intern.RemoteDatastoreRpcException;
import com.google.apphosting.client.datastoreservice.intern.RemoteDatastoreRpcHandler;
import com.google.apphosting.datastore.DatastoreV4;
import com.google.apphosting.datastore.EntityV4;
import java.util.ArrayList;

class RunQueryHandler
extends RemoteDatastoreRpcHandler<DatastoreServiceRpcProto.RunQueryRequest, DatastoreServiceRpcProto.RunQueryResponse> {
    static final InternDatastoreRpcService.RpcSpec<DatastoreV4.RunQueryResponse> INTERN_RPC_SPEC = InternDatastoreRpcService.createRpcSpec("datastore_v4", "RunQuery", DatastoreV4.RunQueryResponse.PARSER);
    static final InternDatastoreRpcService.RpcSpec<DatastoreV4.ContinueQueryResponse> INTERN_CONTINUE_RPC_SPEC = InternDatastoreRpcService.createRpcSpec("datastore_v4", "ContinueQuery", DatastoreV4.ContinueQueryResponse.PARSER);
    private final EntityV4Normalizer entityNormalizer;
    private final EntityWrapperTranslator entityWrapperTranslator;

    private void normalizeQueryFilter(DatastoreV4.Filter.Builder filter) {
        if (filter.hasCompositeFilter()) {
            for (DatastoreV4.Filter.Builder subFilter : filter.getCompositeFilterBuilder().getFilterBuilderList()) {
                this.normalizeQueryFilter(subFilter);
            }
        }
        if (filter.hasPropertyFilter()) {
            EntityV4.Value.Builder value;
            EntityV4.ValueOrBuilder valueOrBuilder = filter.getPropertyFilterOrBuilder().getValueOrBuilder();
            if (valueOrBuilder.hasKeyValue()) {
                value = filter.getPropertyFilterBuilder().getValueBuilder();
                value.setKeyValue(this.entityNormalizer.normalizeKey(value.getKeyValue()));
            }
            if (valueOrBuilder.hasEntityValue()) {
                value = filter.getPropertyFilterBuilder().getValueBuilder();
                value.setEntityValue(this.entityNormalizer.normalizeEntity(value.getEntityValue()));
            }
        }
    }

    private DatastoreV4.Query toV4Query(DatastoreServiceRpcProto.Query apiQuery) {
        DatastoreV4.Query.Builder intQuery = DatastoreV4.Query.newBuilder();
        try {
            intQuery.mergeFrom(apiQuery.toByteString());
        }
        catch (InvalidProtocolBufferException e) {
            throw new IllegalStateException(String.format("The %s message could not be parsed with the %s parser.", apiQuery.getClass(), DatastoreV4.Query.PARSER.getClass()), e);
        }
        if (intQuery.hasFilter()) {
            this.normalizeQueryFilter(intQuery.getFilterBuilder());
        }
        return intQuery.build();
    }

    DatastoreV4.RunQueryRequest toV4RunQueryRequest(DatastoreServiceRpcProto.RunQueryRequest request) {
        DatastoreV4.RunQueryRequest.Builder internRequest = DatastoreV4.RunQueryRequest.newBuilder();
        internRequest.setQuery(this.toV4Query(request.getQuery()));
        internRequest.setSuggestedBatchSize(Integer.MAX_VALUE);
        internRequest.setPartitionId(this.entityNormalizer.normalizePartitionId(request.getPartitionId()));
        if (request.hasReadOptions()) {
            internRequest.setReadOptions(GetHandler.READ_OPTIONS_CONVERTER.apply(request.getReadOptions()));
        }
        return internRequest.build();
    }

    public RunQueryHandler(EntityV4Normalizer entityNormalizer, EntityWrapperTranslator entityWrapperTranslator, InternDatastoreRpcService internDatastoreRpcService) {
        super(internDatastoreRpcService);
        this.entityNormalizer = entityNormalizer;
        this.entityWrapperTranslator = entityWrapperTranslator;
    }

    @Override
    public Parser<DatastoreServiceRpcProto.RunQueryRequest> getParser() {
        return DatastoreServiceRpcProto.RunQueryRequest.PARSER;
    }

    @Override
    public String getName() {
        return "runQuery";
    }

    @Override
    public DatastoreServiceRpcProto.RunQueryResponse call(RemoteDatastoreRpcHandler.CallOptions options, DatastoreServiceRpcProto.RunQueryRequest req) throws RemoteDatastoreRpcException {
        DatastoreServiceRpcProto.RunQueryResponse.Builder resp = DatastoreServiceRpcProto.RunQueryResponse.newBuilder();
        DatastoreServiceRpcProto.QueryResultBatch.Builder apiBatch = resp.getBatchBuilder();
        DatastoreV4.RunQueryResponse initialInternResp = this.internDatastoreRpcService.call(INTERN_RPC_SPEC, this.toV4RunQueryRequest(req)).getResponse();
        DatastoreV4.QueryResultBatch currentInternBatch = initialInternResp.getBatch();
        apiBatch.setEntityResultType(DatastoreServiceRpcProto.EntityResult.ResultType.valueOf(currentInternBatch.getEntityResultType().getNumber()));
        DatastoreV4.ContinueQueryRequest continueReq = DatastoreV4.ContinueQueryRequest.newBuilder().setQueryHandle(initialInternResp.getQueryHandle()).build();
        int currentSerializeResultBytes = 0;
        while (true) {
            InternDatastoreRpcService.ResponseFutureWrapper<DatastoreV4.ContinueQueryResponse> nextFutureWrapper = currentInternBatch.getMoreResults() == DatastoreV4.QueryResultBatch.MoreResultsType.NOT_FINISHED ? this.internDatastoreRpcService.call(INTERN_CONTINUE_RPC_SPEC, continueReq) : null;
            ArrayList<DatastoreServiceRpcProto.EntityResult> convertedResults = Lists.newArrayListWithCapacity(currentInternBatch.getEntityResultCount());
            for (DatastoreV4.EntityResult internResult : currentInternBatch.getEntityResultList()) {
                DatastoreServiceRpcProto.EntityResult apiResult = this.entityWrapperTranslator.translate(internResult);
                int serializedSize = apiResult.getSerializedSize() + 10;
                if (currentSerializeResultBytes + serializedSize > options.getMaxResponseBytes()) {
                    apiBatch.setMoreResults(DatastoreServiceRpcProto.QueryResultBatch.MoreResultsType.NOT_FINISHED);
                    return resp.build();
                }
                currentSerializeResultBytes += serializedSize;
                convertedResults.add(apiResult);
            }
            apiBatch.addAllEntityResult(convertedResults);
            apiBatch.setEndCursor(currentInternBatch.getEndCursor());
            if (currentInternBatch.hasSkippedResults()) {
                apiBatch.setSkippedResults(apiBatch.getSkippedResults() + currentInternBatch.getSkippedResults());
            }
            if (nextFutureWrapper == null) {
                apiBatch.setMoreResults(DatastoreServiceRpcProto.QueryResultBatch.MoreResultsType.valueOf(currentInternBatch.getMoreResults().getNumber()));
                return resp.build();
            }
            currentInternBatch = nextFutureWrapper.getResponse().getBatch();
        }
    }

    @Override
    public DatastoreServiceRpcProto.RunQueryResponse makeError(Codes.Code errorCode, String message) {
        return DatastoreServiceRpcProto.RunQueryResponse.newBuilder().setHeader(this.makeErrorHeader(errorCode, message)).build();
    }
}

