/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.client.datastoreservice.intern;

import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.repackaged.com.google.protobuf.MessageLite;
import com.google.apphosting.client.datastoreservice.intern.AllocateIdsHandler;
import com.google.apphosting.client.datastoreservice.intern.BeginTransactionHandler;
import com.google.apphosting.client.datastoreservice.intern.CommitHandler;
import com.google.apphosting.client.datastoreservice.intern.EntityV4Normalizer;
import com.google.apphosting.client.datastoreservice.intern.EntityWrapperTranslator;
import com.google.apphosting.client.datastoreservice.intern.GetHandler;
import com.google.apphosting.client.datastoreservice.intern.InternDatastoreRpcService;
import com.google.apphosting.client.datastoreservice.intern.RemoteDatastoreRpcHandler;
import com.google.apphosting.client.datastoreservice.intern.RollbackHandler;
import com.google.apphosting.client.datastoreservice.intern.RunQueryHandler;
import com.google.apphosting.client.datastoreservice.intern.WriteHandler;

public class RemoteDatastoreRpcService {
    private final ImmutableList<RemoteDatastoreRpcHandler<? extends MessageLite, ? extends MessageLite>> rpcHandlers;

    public RemoteDatastoreRpcService(String defaultDatasetId) {
        this(new InternDatastoreRpcService(), defaultDatasetId);
    }

    @VisibleForTesting
    RemoteDatastoreRpcService(InternDatastoreRpcService internDatastoreRpcService, String defaultDatasetId) {
        EntityV4Normalizer entityNormalizer = new EntityV4Normalizer(defaultDatasetId);
        EntityWrapperTranslator entityWrapperTranslator = new EntityWrapperTranslator();
        this.rpcHandlers = ImmutableList.of(new AllocateIdsHandler(entityNormalizer, internDatastoreRpcService), new BeginTransactionHandler(internDatastoreRpcService), new CommitHandler(entityNormalizer, internDatastoreRpcService), new GetHandler(entityNormalizer, entityWrapperTranslator, internDatastoreRpcService), new RollbackHandler(internDatastoreRpcService), new RunQueryHandler(entityNormalizer, entityWrapperTranslator, internDatastoreRpcService), new WriteHandler(entityNormalizer, internDatastoreRpcService), new WriteHandler(entityNormalizer, internDatastoreRpcService){

            @Override
            public String getName() {
                return "write";
            }
        }, new GetHandler(entityNormalizer, entityWrapperTranslator, internDatastoreRpcService){

            @Override
            public String getName() {
                return "get";
            }
        });
    }

    public String getName() {
        return "remotedatastore";
    }

    public String getVersion() {
        return "v1";
    }

    public ImmutableList<RemoteDatastoreRpcHandler<? extends MessageLite, ? extends MessageLite>> getRpcHandlers() {
        return this.rpcHandlers;
    }
}

