/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.client.datastoreservice.intern;

import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.repackaged.com.google.net.util.error.Codes;
import com.google.appengine.repackaged.com.google.protobuf.MessageLite;
import com.google.appengine.repackaged.com.google.protobuf.Parser;
import com.google.appengine.repackaged.com.google.protos.gdata.proto2api.Core;
import com.google.apphosting.client.datastoreservice.api.DatastoreServiceRpcProto;
import com.google.apphosting.client.datastoreservice.intern.InternDatastoreRpcService;
import com.google.apphosting.client.datastoreservice.intern.RemoteDatastoreRpcException;

public abstract class RemoteDatastoreRpcHandler<R extends MessageLite, S extends MessageLite> {
    @VisibleForTesting
    static final String GOOGLE_API_ERROR_DOMAIN = "util.error.Code";
    protected final InternDatastoreRpcService internDatastoreRpcService;

    protected RemoteDatastoreRpcHandler(InternDatastoreRpcService internDatastoreRpcService) {
        this.internDatastoreRpcService = internDatastoreRpcService;
    }

    public abstract String getName();

    public abstract Parser<R> getParser();

    public abstract S call(CallOptions var1, R var2) throws RemoteDatastoreRpcException;

    public abstract S makeError(Codes.Code var1, String var2);

    protected DatastoreServiceRpcProto.ResponseHeader makeErrorHeader(Codes.Code errorCode, String message) {
        DatastoreServiceRpcProto.ResponseHeader.Builder response = DatastoreServiceRpcProto.ResponseHeader.newBuilder();
        Core.Errors.Builder errors = Core.Errors.newBuilder();
        Core.ErrorProto.Builder errorProto = Core.ErrorProto.newBuilder();
        errorProto.setDomain(GOOGLE_API_ERROR_DOMAIN).setCode(errorCode.toString()).setExternalErrorMessage(message);
        errors.addError(errorProto.build());
        response.setErrors(errors.build());
        return response.build();
    }

    public static class CallOptions {
        public static final CallOptions DEFAULT = new CallOptions(0x1E00000);
        private final int maxResponseBytes;

        public CallOptions(int maxResponseBytes) {
            this.maxResponseBytes = maxResponseBytes;
        }

        public int getMaxResponseBytes() {
            return this.maxResponseBytes;
        }
    }
}

