/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.client.datastoreservice.intern;

import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.repackaged.com.google.common.base.Converter;
import com.google.appengine.repackaged.com.google.net.util.error.Codes;
import com.google.appengine.repackaged.com.google.protobuf.Parser;
import com.google.apphosting.client.datastoreservice.api.DatastoreServiceRpcProto;
import com.google.apphosting.client.datastoreservice.intern.EntityV4Normalizer;
import com.google.apphosting.client.datastoreservice.intern.EntityWrapperTranslator;
import com.google.apphosting.client.datastoreservice.intern.EquivalentMessageConverter;
import com.google.apphosting.client.datastoreservice.intern.InternDatastoreRpcService;
import com.google.apphosting.client.datastoreservice.intern.RemoteDatastoreRpcException;
import com.google.apphosting.client.datastoreservice.intern.RemoteDatastoreRpcHandler;
import com.google.apphosting.datastore.DatastoreV4;
import com.google.apphosting.datastore.EntityV4;
import java.util.List;
import javax.annotation.Nullable;

class GetHandler
extends RemoteDatastoreRpcHandler<DatastoreServiceRpcProto.GetRequest, DatastoreServiceRpcProto.GetResponse> {
    @VisibleForTesting
    static final int INTERN_MAX_KEYS_PER_REQUEST = 1000;
    @VisibleForTesting
    static final InternDatastoreRpcService.RpcSpec<DatastoreV4.GetResponse> INTERN_RPC_SPEC = InternDatastoreRpcService.createRpcSpec("datastore_v4", "Get", DatastoreV4.GetResponse.PARSER);
    public static final Converter<DatastoreServiceRpcProto.ReadOptions, DatastoreV4.ReadOptions> READ_OPTIONS_CONVERTER = EquivalentMessageConverter.create(DatastoreServiceRpcProto.ReadOptions.PARSER, DatastoreV4.ReadOptions.PARSER);
    private final EntityV4Normalizer entityNormalizer;
    private final EntityWrapperTranslator entityWrapperTranslator;

    public static void validateReadOptions(DatastoreServiceRpcProto.ReadOptions readOptions) {
    }

    public GetHandler(EntityV4Normalizer entityNormalizer, EntityWrapperTranslator entityWrapperTranslator, InternDatastoreRpcService internDatastoreRpcService) {
        super(internDatastoreRpcService);
        this.entityNormalizer = entityNormalizer;
        this.entityWrapperTranslator = entityWrapperTranslator;
    }

    @Override
    public Parser<DatastoreServiceRpcProto.GetRequest> getParser() {
        return DatastoreServiceRpcProto.GetRequest.PARSER;
    }

    @Override
    public String getName() {
        return "lookup";
    }

    @Override
    public DatastoreServiceRpcProto.GetResponse call(RemoteDatastoreRpcHandler.CallOptions callOptions, DatastoreServiceRpcProto.GetRequest apiRequest) throws RemoteDatastoreRpcException {
        DatastoreV4.ReadOptions internReadOptions = apiRequest.hasReadOptions() ? READ_OPTIONS_CONVERTER.apply(apiRequest.getReadOptions()) : null;
        List<EntityV4.Key> internRequestKeyList = this.entityNormalizer.normalizeKeyList(apiRequest.getKeyList());
        int numRemainingApiResponseBytes = callOptions.getMaxResponseBytes() - this.determineNumKeyAndOverheadApiResponseBytes(internRequestKeyList);
        if (numRemainingApiResponseBytes < 0) {
            throw new RemoteDatastoreRpcException(Codes.Code.INVALID_ARGUMENT, "Too many keys for the response size limit.");
        }
        DatastoreV4.GetRequest internRequest = this.createInternRequest(internReadOptions, internRequestKeyList);
        InternDatastoreRpcService.ResponseFutureWrapper<DatastoreV4.GetResponse> internResponseFutureWrapper = this.internDatastoreRpcService.call(INTERN_RPC_SPEC, internRequest);
        DatastoreServiceRpcProto.GetResponse.Builder apiResponseBuilder = DatastoreServiceRpcProto.GetResponse.newBuilder();
        do {
            DatastoreV4.GetResponse internResponse = internResponseFutureWrapper.getResponse();
            internRequestKeyList.addAll(internResponse.getDeferredList());
            if (internRequestKeyList.isEmpty()) {
                internResponseFutureWrapper = null;
            } else {
                internRequest = this.createInternRequest(internReadOptions, internRequestKeyList);
                internResponseFutureWrapper = this.internDatastoreRpcService.call(INTERN_RPC_SPEC, internRequest);
            }
            for (DatastoreV4.EntityResult internMissingEntityResult : internResponse.getMissingList()) {
                DatastoreServiceRpcProto.EntityResult apiMissingEntityResult = this.entityWrapperTranslator.translate(internMissingEntityResult);
                apiResponseBuilder.addMissing(apiMissingEntityResult);
            }
            for (DatastoreV4.EntityResult internFoundEntityResult : internResponse.getFoundList()) {
                DatastoreServiceRpcProto.EntityResult apiFoundEntityResult = this.entityWrapperTranslator.translate(internFoundEntityResult);
                int numNonKeyBytes = apiFoundEntityResult.getSerializedSize() - apiFoundEntityResult.getEntity().getKey().getSerializedSize();
                if (numNonKeyBytes > numRemainingApiResponseBytes) {
                    internResponseFutureWrapper = null;
                    apiResponseBuilder.addDeferred(apiFoundEntityResult.getEntity().getKey());
                    continue;
                }
                apiResponseBuilder.addFound(apiFoundEntityResult);
                numRemainingApiResponseBytes -= numNonKeyBytes;
            }
        } while (internResponseFutureWrapper != null);
        apiResponseBuilder.addAllDeferred(internRequestKeyList);
        return apiResponseBuilder.build();
    }

    private int determineNumKeyAndOverheadApiResponseBytes(List<EntityV4.Key> adjustedRequestApiKeyList) {
        int numKeyAndOverheadApiResponseBytes = 0;
        for (EntityV4.Key adjustedRequestApiKey : adjustedRequestApiKeyList) {
            numKeyAndOverheadApiResponseBytes = numKeyAndOverheadApiResponseBytes + adjustedRequestApiKey.getSerializedSize() + 10;
        }
        return numKeyAndOverheadApiResponseBytes;
    }

    private DatastoreV4.GetRequest createInternRequest(@Nullable DatastoreV4.ReadOptions internReadOptions, List<EntityV4.Key> internRequestKeyList) {
        DatastoreV4.GetRequest.Builder internRequestBuilder = DatastoreV4.GetRequest.newBuilder();
        if (internReadOptions != null) {
            internRequestBuilder.setReadOptions(internReadOptions);
        }
        List<EntityV4.Key> internLimitedRequestKeyList = internRequestKeyList.size() <= 1000 ? internRequestKeyList : internRequestKeyList.subList(0, 1000);
        internRequestBuilder.addAllKey(internLimitedRequestKeyList);
        internLimitedRequestKeyList.clear();
        return internRequestBuilder.build();
    }

    @Override
    public DatastoreServiceRpcProto.GetResponse makeError(Codes.Code errorCode, String message) {
        return DatastoreServiceRpcProto.GetResponse.newBuilder().setHeader(this.makeErrorHeader(errorCode, message)).build();
    }
}

