/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.client.datastoreservice.intern;

import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.repackaged.com.google.common.collect.ArrayListMultimap;
import com.google.appengine.repackaged.com.google.common.collect.Iterables;
import com.google.appengine.repackaged.com.google.common.collect.Maps;
import com.google.appengine.repackaged.com.google.common.collect.Multimap;
import com.google.appengine.repackaged.com.google.common.collect.Multiset;
import com.google.appengine.repackaged.com.google.net.util.error.Codes;
import com.google.appengine.repackaged.com.google.protobuf.Parser;
import com.google.apphosting.api.DatastorePb;
import com.google.apphosting.client.datastoreservice.api.DatastoreServiceRpcProto;
import com.google.apphosting.client.datastoreservice.intern.EntityV4Normalizer;
import com.google.apphosting.client.datastoreservice.intern.InternDatastoreRpcService;
import com.google.apphosting.client.datastoreservice.intern.RemoteDatastoreRpcException;
import com.google.apphosting.client.datastoreservice.intern.RemoteDatastoreRpcHandler;
import com.google.apphosting.datastore.EntityV4;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class AllocateIdsHandler
extends RemoteDatastoreRpcHandler<DatastoreServiceRpcProto.AllocateIdsRequest, DatastoreServiceRpcProto.AllocateIdsResponse> {
    @VisibleForTesting
    static final InternDatastoreRpcService.RpcSpec<DatastorePb.AllocateIdsResponse> INTERN_RPC_SPEC = InternDatastoreRpcService.createRpcSpec("datastore_v3", "AllocateIds", DatastorePb.AllocateIdsResponse.PARSER);
    private final EntityV4Normalizer entityNormalizer;

    public AllocateIdsHandler(EntityV4Normalizer entityNormalizer, InternDatastoreRpcService internDatastoreRpcService) {
        super(internDatastoreRpcService);
        this.entityNormalizer = entityNormalizer;
    }

    @Override
    public String getName() {
        return "allocateIds";
    }

    @Override
    public Parser<DatastoreServiceRpcProto.AllocateIdsRequest> getParser() {
        return DatastoreServiceRpcProto.AllocateIdsRequest.PARSER;
    }

    private Multimap<OnestoreEntity.Reference, EntityV4.Key.Builder> groupKeys(List<EntityV4.Key> keys, DatastoreServiceRpcProto.AllocateIdsResponse.Builder resp) {
        ArrayListMultimap<OnestoreEntity.Reference, EntityV4.Key.Builder> groupedKeys = ArrayListMultimap.create();
        for (EntityV4.Key key : keys) {
            key = this.entityNormalizer.normalizeKey(key);
            OnestoreEntity.Reference idKey = new OnestoreEntity.Reference();
            EntityV4.Key.Builder keyBuilder = resp.addKeyBuilder().mergeFrom(key);
            if (keyBuilder.getPartitionIdOrBuilder().hasDatasetId()) {
                idKey.setApp(keyBuilder.getPartitionIdOrBuilder().getDatasetId());
            }
            if (keyBuilder.getPartitionIdOrBuilder().hasNamespace()) {
                idKey.setNameSpace(keyBuilder.getPartitionIdOrBuilder().getNamespace());
            }
            if (key.getPathElementCount() > 1) {
                EntityV4.Key.PathElement entityGroup = key.getPathElement(0);
                OnestoreEntity.Path.Element elem = idKey.getMutablePath().addElement();
                elem.setType(entityGroup.getKind());
                if (entityGroup.hasName()) {
                    elem.setName(entityGroup.getName());
                } else {
                    elem.setId(entityGroup.getId());
                }
            }
            idKey.getMutablePath().addElement().setType("ignored");
            groupedKeys.put(idKey, keyBuilder);
        }
        return groupedKeys;
    }

    private Map<OnestoreEntity.Reference, InternDatastoreRpcService.ResponseFutureWrapper<DatastorePb.AllocateIdsResponse>> callAllocateIds(Multiset<OnestoreEntity.Reference> idKeys) {
        HashMap<OnestoreEntity.Reference, InternDatastoreRpcService.ResponseFutureWrapper<DatastorePb.AllocateIdsResponse>> ids = Maps.newHashMapWithExpectedSize(idKeys.elementSet().size());
        for (Multiset.Entry<OnestoreEntity.Reference> entry : idKeys.entrySet()) {
            DatastorePb.AllocateIdsRequest req = new DatastorePb.AllocateIdsRequest();
            req.setModelKey(entry.getElement());
            req.setSize(entry.getCount());
            ids.put(entry.getElement(), this.internDatastoreRpcService.call(INTERN_RPC_SPEC, req));
        }
        return ids;
    }

    @Override
    public DatastoreServiceRpcProto.AllocateIdsResponse call(RemoteDatastoreRpcHandler.CallOptions options, DatastoreServiceRpcProto.AllocateIdsRequest apiReq) throws RemoteDatastoreRpcException {
        DatastoreServiceRpcProto.AllocateIdsResponse.Builder resp = DatastoreServiceRpcProto.AllocateIdsResponse.newBuilder();
        for (EntityV4.Key key : apiReq.getKeyList()) {
            if (key.getPathElementCount() == 0) {
                throw new RemoteDatastoreRpcException("keys must not be empty");
            }
            EntityV4.Key.PathElement last = Iterables.getLast(key.getPathElementList());
            if (last.getId() == 0L && !last.hasName()) continue;
            throw new RemoteDatastoreRpcException("keys must be incomplete");
        }
        Multimap<OnestoreEntity.Reference, EntityV4.Key.Builder> groupedKeys = this.groupKeys(apiReq.getKeyList(), resp);
        Map<OnestoreEntity.Reference, InternDatastoreRpcService.ResponseFutureWrapper<DatastorePb.AllocateIdsResponse>> futures = this.callAllocateIds(groupedKeys.keys());
        for (Map.Entry<OnestoreEntity.Reference, Collection<EntityV4.Key.Builder>> entry : groupedKeys.asMap().entrySet()) {
            DatastorePb.AllocateIdsResponse idRange = futures.get(entry.getKey()).getResponse();
            if (idRange.getEnd() - idRange.getStart() + 1L < (long)entry.getValue().size()) {
                throw new RemoteDatastoreRpcException("could not allocate sufficent ids");
            }
            long i = idRange.getStart();
            for (EntityV4.Key.Builder key : entry.getValue()) {
                key.getPathElementBuilder(key.getPathElementCount() - 1).setId(i++);
            }
        }
        return resp.build();
    }

    @Override
    public DatastoreServiceRpcProto.AllocateIdsResponse makeError(Codes.Code errorCode, String message) {
        return DatastoreServiceRpcProto.AllocateIdsResponse.newBuilder().setHeader(this.makeErrorHeader(errorCode, message)).build();
    }
}

