/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.client.datastoreservice.app;

import com.google.appengine.api.appidentity.AppIdentityService;
import com.google.appengine.api.appidentity.AppIdentityServiceFactory;
import com.google.appengine.api.appidentity.AppIdentityServiceFailureException;
import com.google.appengine.api.oauth.OAuthRequestException;
import com.google.appengine.api.oauth.OAuthService;
import com.google.appengine.api.oauth.OAuthServiceFactory;
import com.google.appengine.api.users.User;
import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableMap;
import com.google.appengine.repackaged.com.google.net.util.error.Codes;
import com.google.appengine.repackaged.com.google.protobuf.MessageLite;
import com.google.appengine.repackaged.com.google.protobuf.Parser;
import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.client.datastoreservice.intern.RemoteDatastoreRpcException;
import com.google.apphosting.client.datastoreservice.intern.RemoteDatastoreRpcHandler;
import com.google.apphosting.client.datastoreservice.intern.RemoteDatastoreRpcService;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ApiServlet
extends HttpServlet {
    @VisibleForTesting
    static final String API_HEADER = "X-AppEngine-Datastore-API";
    private static final Logger logger = Logger.getLogger(ApiServlet.class.getName());
    @VisibleForTesting
    static final String OAUTH2_SCOPE = "https://www.googleapis.com/auth/datastore";
    @VisibleForTesting
    static final String OAUTH2_SCOPE_CODE = "43600";
    private static final Pattern URI_PATTERN = Pattern.compile("/([^/]*/[^/]*/[^/]*)");
    private final OAuthService oauthService;
    private final AppIdentityService appIdentityService;
    private final ImmutableMap<String, RemoteDatastoreRpcHandler<?, ?>> rpcHandlerMap;

    public ApiServlet() {
        this(OAuthServiceFactory.getOAuthService(), AppIdentityServiceFactory.getAppIdentityService());
    }

    @VisibleForTesting
    ApiServlet(OAuthService oauthService, AppIdentityService appIdentityService) {
        this(new RemoteDatastoreRpcService(ApiProxy.getCurrentEnvironment().getAppId()), oauthService, appIdentityService);
    }

    @VisibleForTesting
    ApiServlet(RemoteDatastoreRpcService service, OAuthService oauthService, AppIdentityService appIdentityService) {
        ImmutableMap.Builder<String, RemoteDatastoreRpcHandler> rpcHandlerMapBuilder = ImmutableMap.builder();
        for (RemoteDatastoreRpcHandler remoteDatastoreRpcHandler : service.getRpcHandlers()) {
            String uri = String.format("%s/%s/%s", service.getName(), service.getVersion(), remoteDatastoreRpcHandler.getName().toLowerCase());
            rpcHandlerMapBuilder.put(uri, remoteDatastoreRpcHandler);
        }
        this.rpcHandlerMap = rpcHandlerMapBuilder.build();
        this.oauthService = oauthService;
        this.appIdentityService = appIdentityService;
    }

    protected void doGet(HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        logger.info("ApiServlet GET");
        try {
            RemoteDatastoreRpcHandler<?, ?> rpcHandler = this.getHandler(httpRequest.getRequestURI());
            if (!this.authenticate(httpRequest)) {
                ApiServlet.writeErrorResponse(rpcHandler, httpRequest, httpResponse, Codes.Code.PERMISSION_DENIED, "Unauthorized.");
            } else {
                ApiServlet.writeTextResponse(httpResponse, 200, "Valid RPC");
            }
        }
        catch (IOException e) {
            logger.log(Level.INFO, e.getMessage());
            ApiServlet.writeTextResponse(httpResponse, 400, e.getMessage());
        }
    }

    public void doPost(HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        Object response;
        RemoteDatastoreRpcHandler<?, ?> rpcHandler;
        logger.info("ApiServlet POST");
        try {
            rpcHandler = this.getHandler(httpRequest.getRequestURI());
        }
        catch (IOException e) {
            logger.log(Level.INFO, e.getMessage());
            ApiServlet.writeTextResponse(httpResponse, 400, e.getMessage());
            return;
        }
        if (!this.authenticate(httpRequest)) {
            ApiServlet.writeErrorResponse(rpcHandler, httpRequest, httpResponse, Codes.Code.PERMISSION_DENIED, "Unauthorized.");
            return;
        }
        try {
            response = ApiServlet.call(rpcHandler, httpRequest);
        }
        catch (IOException exception) {
            logger.log(Level.INFO, "Exception reading rpc request proto message.", exception);
            ApiServlet.writeErrorResponse(rpcHandler, httpRequest, httpResponse, Codes.Code.INVALID_ARGUMENT, exception.getMessage());
            return;
        }
        catch (RemoteDatastoreRpcException exception) {
            logger.log(Level.INFO, "Exception executing rpc.", exception);
            ApiServlet.writeErrorResponse(rpcHandler, httpRequest, httpResponse, exception.getErrorCode(), exception.getMessage());
            return;
        }
        try {
            ApiServlet.writeResponseProto(response, httpResponse);
        }
        catch (IOException exception) {
            logger.log(Level.INFO, "Exception sending rpc response proto message.", exception);
        }
    }

    private RemoteDatastoreRpcHandler<?, ?> getHandler(String uri) throws IOException {
        Matcher uriMatcher = URI_PATTERN.matcher(uri);
        if (!uriMatcher.matches()) {
            throw new IOException("Malformed uri: " + uri);
        }
        String methodSpec = uriMatcher.group(1).toLowerCase();
        RemoteDatastoreRpcHandler<?, ?> rpcHandler = this.rpcHandlerMap.get(methodSpec);
        if (rpcHandler == null) {
            throw new IOException("unknown rpc: " + methodSpec);
        }
        return rpcHandler;
    }

    private static <R extends MessageLite, S extends MessageLite> S call(RemoteDatastoreRpcHandler<R, S> rpcHandler, HttpServletRequest httpRequest) throws RemoteDatastoreRpcException, IOException {
        return rpcHandler.call(RemoteDatastoreRpcHandler.CallOptions.DEFAULT, ApiServlet.readRequestProto(rpcHandler.getParser(), httpRequest));
    }

    private boolean authenticate(HttpServletRequest httpRequest) {
        try {
            User user = this.oauthService.getCurrentUser(OAUTH2_SCOPE_CODE);
            if (user.getEmail().equals(this.appIdentityService.getServiceAccountName())) {
                return true;
            }
        }
        catch (OAuthRequestException e) {
        }
        catch (AppIdentityServiceFailureException e) {
            // empty catch block
        }
        try {
            return this.oauthService.isUserAdmin(OAUTH2_SCOPE_CODE);
        }
        catch (OAuthRequestException e) {
            try {
                return this.oauthService.isUserAdmin(OAUTH2_SCOPE);
            }
            catch (OAuthRequestException e2) {
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeResponseProto(MessageLite protoResponse, HttpServletResponse httpResponse) throws IOException {
        httpResponse.setStatus(200);
        httpResponse.setContentType("application/x-protobuf");
        ServletOutputStream outputStream = null;
        try {
            outputStream = httpResponse.getOutputStream();
            protoResponse.writeTo((OutputStream)outputStream);
        }
        finally {
            if (outputStream != null) {
                outputStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <R extends MessageLite> R readRequestProto(Parser<R> parser, HttpServletRequest httpRequest) throws IOException {
        ServletInputStream inputStream = null;
        try {
            MessageLite requestProto;
            inputStream = httpRequest.getInputStream();
            MessageLite messageLite = requestProto = (MessageLite)parser.parseFrom((InputStream)inputStream);
            return (R)messageLite;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException exception) {
                    logger.log(Level.INFO, "Exception at end of reading rpc request proto message.", exception);
                }
            }
        }
    }

    private static void writeErrorResponse(RemoteDatastoreRpcHandler<?, ?> rpcHandler, HttpServletRequest httpRequest, HttpServletResponse httpResponse, Codes.Code code, String message) {
        logger.log(Level.SEVERE, code.toString() + ": " + message);
        if (httpRequest.getHeader(API_HEADER) != null) {
            try {
                ApiServlet.writeResponseProto(rpcHandler.makeError(code, message), httpResponse);
            }
            catch (IOException exception) {
                logger.log(Level.INFO, "IO Exception sending rpc error proto message", exception);
            }
        } else {
            int httpErrorCode;
            switch (code) {
                case INVALID_ARGUMENT: {
                    httpErrorCode = 400;
                    break;
                }
                case PERMISSION_DENIED: {
                    httpErrorCode = 403;
                    break;
                }
                case RESOURCE_EXHAUSTED: {
                    httpErrorCode = 402;
                    break;
                }
                case FAILED_PRECONDITION: {
                    httpErrorCode = 412;
                    break;
                }
                case ABORTED: {
                    httpErrorCode = 409;
                    break;
                }
                case DEADLINE_EXCEEDED: {
                    httpErrorCode = 403;
                    break;
                }
                case UNAVAILABLE: {
                    httpErrorCode = 503;
                    break;
                }
                default: {
                    httpErrorCode = 500;
                }
            }
            String errorMessage = String.format("{\n  \"error\": {\n    \"errors\": [\n     {\n       \"domain\": \"global\",\n       \"reason\": \"%s\",\n       \"message\": \"%s\"\n     }\n    ],\n    \"code\": %d,\n    \"message\": \"%s\"\n }\n}\n", code.toString(), message, httpErrorCode, message);
            ApiServlet.writeTextResponse(httpResponse, httpErrorCode, errorMessage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeTextResponse(HttpServletResponse httpResponse, int httpStatusCode, String message) {
        httpResponse.setStatus(httpStatusCode);
        httpResponse.setContentType("text/plain");
        try {
            ServletOutputStream outputStream = null;
            try {
                outputStream = httpResponse.getOutputStream();
                outputStream.print(message);
            }
            finally {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
        }
        catch (IOException exception) {
            logger.log(Level.INFO, "IO Exception sending error text", exception);
        }
    }
}

