/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.org.antlr.runtime;

import com.google.appengine.repackaged.org.antlr.runtime.CommonTokenStream;
import com.google.appengine.repackaged.org.antlr.runtime.Token;
import com.google.appengine.repackaged.org.antlr.runtime.TokenSource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class TokenRewriteStream
extends CommonTokenStream {
    public static final String DEFAULT_PROGRAM_NAME = "default";
    public static final int PROGRAM_INIT_SIZE = 100;
    public static final int MIN_TOKEN_INDEX = 0;
    protected Map programs = null;
    protected Map lastRewriteTokenIndexes = null;
    static /* synthetic */ Class class$org$antlr$runtime$TokenRewriteStream$InsertBeforeOp;
    static /* synthetic */ Class class$org$antlr$runtime$TokenRewriteStream$ReplaceOp;

    public TokenRewriteStream() {
        this.init();
    }

    protected void init() {
        this.programs = new HashMap();
        this.programs.put(DEFAULT_PROGRAM_NAME, new ArrayList(100));
        this.lastRewriteTokenIndexes = new HashMap();
    }

    public TokenRewriteStream(TokenSource tokenSource) {
        super(tokenSource);
        this.init();
    }

    public TokenRewriteStream(TokenSource tokenSource, int channel) {
        super(tokenSource, channel);
        this.init();
    }

    public void rollback(int instructionIndex) {
        this.rollback(DEFAULT_PROGRAM_NAME, instructionIndex);
    }

    public void rollback(String programName, int instructionIndex) {
        List is = (List)this.programs.get(programName);
        if (is != null) {
            this.programs.put(programName, is.subList(0, instructionIndex));
        }
    }

    public void deleteProgram() {
        this.deleteProgram(DEFAULT_PROGRAM_NAME);
    }

    public void deleteProgram(String programName) {
        this.rollback(programName, 0);
    }

    public void insertAfter(Token t, Object text) {
        this.insertAfter(DEFAULT_PROGRAM_NAME, t, text);
    }

    public void insertAfter(int index, Object text) {
        this.insertAfter(DEFAULT_PROGRAM_NAME, index, text);
    }

    public void insertAfter(String programName, Token t, Object text) {
        this.insertAfter(programName, t.getTokenIndex(), text);
    }

    public void insertAfter(String programName, int index, Object text) {
        this.insertBefore(programName, index + 1, text);
    }

    public void insertBefore(Token t, Object text) {
        this.insertBefore(DEFAULT_PROGRAM_NAME, t, text);
    }

    public void insertBefore(int index, Object text) {
        this.insertBefore(DEFAULT_PROGRAM_NAME, index, text);
    }

    public void insertBefore(String programName, Token t, Object text) {
        this.insertBefore(programName, t.getTokenIndex(), text);
    }

    public void insertBefore(String programName, int index, Object text) {
        InsertBeforeOp op = new InsertBeforeOp(index, text);
        List rewrites = this.getProgram(programName);
        op.instructionIndex = rewrites.size();
        rewrites.add(op);
    }

    public void replace(int index, Object text) {
        this.replace(DEFAULT_PROGRAM_NAME, index, index, text);
    }

    public void replace(int from, int to, Object text) {
        this.replace(DEFAULT_PROGRAM_NAME, from, to, text);
    }

    public void replace(Token indexT, Object text) {
        this.replace(DEFAULT_PROGRAM_NAME, indexT, indexT, text);
    }

    public void replace(Token from, Token to, Object text) {
        this.replace(DEFAULT_PROGRAM_NAME, from, to, text);
    }

    public void replace(String programName, int from, int to, Object text) {
        if (from > to || from < 0 || to < 0 || to >= this.tokens.size()) {
            throw new IllegalArgumentException("replace: range invalid: " + from + ".." + to + "(size=" + this.tokens.size() + ")");
        }
        ReplaceOp op = new ReplaceOp(from, to, text);
        List rewrites = this.getProgram(programName);
        op.instructionIndex = rewrites.size();
        rewrites.add(op);
    }

    public void replace(String programName, Token from, Token to, Object text) {
        this.replace(programName, from.getTokenIndex(), to.getTokenIndex(), text);
    }

    public void delete(int index) {
        this.delete(DEFAULT_PROGRAM_NAME, index, index);
    }

    public void delete(int from, int to) {
        this.delete(DEFAULT_PROGRAM_NAME, from, to);
    }

    public void delete(Token indexT) {
        this.delete(DEFAULT_PROGRAM_NAME, indexT, indexT);
    }

    public void delete(Token from, Token to) {
        this.delete(DEFAULT_PROGRAM_NAME, from, to);
    }

    public void delete(String programName, int from, int to) {
        this.replace(programName, from, to, null);
    }

    public void delete(String programName, Token from, Token to) {
        this.replace(programName, from, to, null);
    }

    public int getLastRewriteTokenIndex() {
        return this.getLastRewriteTokenIndex(DEFAULT_PROGRAM_NAME);
    }

    protected int getLastRewriteTokenIndex(String programName) {
        Integer I = (Integer)this.lastRewriteTokenIndexes.get(programName);
        if (I == null) {
            return -1;
        }
        return I;
    }

    protected void setLastRewriteTokenIndex(String programName, int i) {
        this.lastRewriteTokenIndexes.put(programName, new Integer(i));
    }

    protected List getProgram(String name) {
        List is = (List)this.programs.get(name);
        if (is == null) {
            is = this.initializeProgram(name);
        }
        return is;
    }

    private List initializeProgram(String name) {
        ArrayList is = new ArrayList(100);
        this.programs.put(name, is);
        return is;
    }

    public String toOriginalString() {
        return this.toOriginalString(0, this.size() - 1);
    }

    public String toOriginalString(int start, int end) {
        StringBuffer buf = new StringBuffer();
        for (int i = start; i >= 0 && i <= end && i < this.tokens.size(); ++i) {
            buf.append(this.get(i).getText());
        }
        return buf.toString();
    }

    public String toString() {
        return this.toString(0, this.size() - 1);
    }

    public String toString(String programName) {
        return this.toString(programName, 0, this.size() - 1);
    }

    public String toString(int start, int end) {
        return this.toString(DEFAULT_PROGRAM_NAME, start, end);
    }

    public String toString(String programName, int start, int end) {
        List rewrites = (List)this.programs.get(programName);
        if (end > this.tokens.size() - 1) {
            end = this.tokens.size() - 1;
        }
        if (start < 0) {
            start = 0;
        }
        if (rewrites == null || rewrites.size() == 0) {
            return this.toOriginalString(start, end);
        }
        StringBuffer buf = new StringBuffer();
        Map indexToOp = this.reduceToSingleOperationPerIndex(rewrites);
        int i = start;
        while (i <= end && i < this.tokens.size()) {
            RewriteOperation op = (RewriteOperation)indexToOp.get(new Integer(i));
            indexToOp.remove(new Integer(i));
            Token t = (Token)this.tokens.get(i);
            if (op == null) {
                buf.append(t.getText());
                ++i;
                continue;
            }
            i = op.execute(buf);
        }
        if (end == this.tokens.size() - 1) {
            Iterator it = indexToOp.values().iterator();
            while (it.hasNext()) {
                RewriteOperation op = (RewriteOperation)it.next();
                if (op.index < this.tokens.size() - 1) continue;
                buf.append(op.text);
            }
        }
        return buf.toString();
    }

    protected Map reduceToSingleOperationPerIndex(List rewrites) {
        int j;
        List prevReplaces;
        RewriteOperation op;
        int i;
        for (i = 0; i < rewrites.size(); ++i) {
            op = (RewriteOperation)rewrites.get(i);
            if (op == null || !(op instanceof ReplaceOp)) continue;
            ReplaceOp rop = (ReplaceOp)rewrites.get(i);
            List inserts = this.getKindOfOps(rewrites, class$org$antlr$runtime$TokenRewriteStream$InsertBeforeOp == null ? TokenRewriteStream.class$("com.google.appengine.repackaged.org.antlr.runtime.TokenRewriteStream$InsertBeforeOp") : class$org$antlr$runtime$TokenRewriteStream$InsertBeforeOp, i);
            for (int j2 = 0; j2 < inserts.size(); ++j2) {
                InsertBeforeOp iop = (InsertBeforeOp)inserts.get(j2);
                if (iop.index < rop.index || iop.index > rop.lastIndex) continue;
                rewrites.set(iop.instructionIndex, null);
            }
            prevReplaces = this.getKindOfOps(rewrites, class$org$antlr$runtime$TokenRewriteStream$ReplaceOp == null ? TokenRewriteStream.class$("com.google.appengine.repackaged.org.antlr.runtime.TokenRewriteStream$ReplaceOp") : class$org$antlr$runtime$TokenRewriteStream$ReplaceOp, i);
            for (j = 0; j < prevReplaces.size(); ++j) {
                boolean same;
                ReplaceOp prevRop = (ReplaceOp)prevReplaces.get(j);
                if (prevRop.index >= rop.index && prevRop.lastIndex <= rop.lastIndex) {
                    rewrites.set(prevRop.instructionIndex, null);
                    continue;
                }
                boolean disjoint = prevRop.lastIndex < rop.index || prevRop.index > rop.lastIndex;
                boolean bl = same = prevRop.index == rop.index && prevRop.lastIndex == rop.lastIndex;
                if (disjoint || same) continue;
                throw new IllegalArgumentException("replace op boundaries of " + rop + " overlap with previous " + prevRop);
            }
        }
        for (i = 0; i < rewrites.size(); ++i) {
            op = (RewriteOperation)rewrites.get(i);
            if (op == null || !(op instanceof InsertBeforeOp)) continue;
            InsertBeforeOp iop = (InsertBeforeOp)rewrites.get(i);
            List prevInserts = this.getKindOfOps(rewrites, class$org$antlr$runtime$TokenRewriteStream$InsertBeforeOp == null ? TokenRewriteStream.class$("com.google.appengine.repackaged.org.antlr.runtime.TokenRewriteStream$InsertBeforeOp") : class$org$antlr$runtime$TokenRewriteStream$InsertBeforeOp, i);
            for (int j3 = 0; j3 < prevInserts.size(); ++j3) {
                InsertBeforeOp prevIop = (InsertBeforeOp)prevInserts.get(j3);
                if (prevIop.index != iop.index) continue;
                iop.text = this.catOpText(iop.text, prevIop.text);
                rewrites.set(prevIop.instructionIndex, null);
            }
            prevReplaces = this.getKindOfOps(rewrites, class$org$antlr$runtime$TokenRewriteStream$ReplaceOp == null ? TokenRewriteStream.class$("com.google.appengine.repackaged.org.antlr.runtime.TokenRewriteStream$ReplaceOp") : class$org$antlr$runtime$TokenRewriteStream$ReplaceOp, i);
            for (j = 0; j < prevReplaces.size(); ++j) {
                ReplaceOp rop = (ReplaceOp)prevReplaces.get(j);
                if (iop.index == rop.index) {
                    rop.text = this.catOpText(iop.text, rop.text);
                    rewrites.set(i, null);
                    continue;
                }
                if (iop.index < rop.index || iop.index > rop.lastIndex) continue;
                throw new IllegalArgumentException("insert op " + iop + " within boundaries of previous " + rop);
            }
        }
        HashMap<Integer, RewriteOperation> m = new HashMap<Integer, RewriteOperation>();
        for (int i2 = 0; i2 < rewrites.size(); ++i2) {
            RewriteOperation op2 = (RewriteOperation)rewrites.get(i2);
            if (op2 == null) continue;
            if (m.get(new Integer(op2.index)) != null) {
                throw new Error("should only be one op per index");
            }
            m.put(new Integer(op2.index), op2);
        }
        return m;
    }

    protected String catOpText(Object a, Object b) {
        String x = "";
        String y = "";
        if (a != null) {
            x = a.toString();
        }
        if (b != null) {
            y = b.toString();
        }
        return x + y;
    }

    protected List getKindOfOps(List rewrites, Class kind) {
        return this.getKindOfOps(rewrites, kind, rewrites.size());
    }

    protected List getKindOfOps(List rewrites, Class kind, int before) {
        ArrayList<RewriteOperation> ops = new ArrayList<RewriteOperation>();
        for (int i = 0; i < before && i < rewrites.size(); ++i) {
            RewriteOperation op = (RewriteOperation)rewrites.get(i);
            if (op == null || op.getClass() != kind) continue;
            ops.add(op);
        }
        return ops;
    }

    public String toDebugString() {
        return this.toDebugString(0, this.size() - 1);
    }

    public String toDebugString(int start, int end) {
        StringBuffer buf = new StringBuffer();
        for (int i = start; i >= 0 && i <= end && i < this.tokens.size(); ++i) {
            buf.append(this.get(i));
        }
        return buf.toString();
    }

    class DeleteOp
    extends ReplaceOp {
        public DeleteOp(int from, int to) {
            super(from, to, null);
        }

        public String toString() {
            return "<DeleteOp@" + this.index + ".." + this.lastIndex + ">";
        }
    }

    class ReplaceOp
    extends RewriteOperation {
        protected int lastIndex;

        public ReplaceOp(int from, int to, Object text) {
            super(from, text);
            this.lastIndex = to;
        }

        public int execute(StringBuffer buf) {
            if (this.text != null) {
                buf.append(this.text);
            }
            return this.lastIndex + 1;
        }

        public String toString() {
            return "<ReplaceOp@" + this.index + ".." + this.lastIndex + ":\"" + this.text + "\">";
        }
    }

    class InsertBeforeOp
    extends RewriteOperation {
        public InsertBeforeOp(int index, Object text) {
            super(index, text);
        }

        public int execute(StringBuffer buf) {
            buf.append(this.text);
            buf.append(((Token)TokenRewriteStream.this.tokens.get(this.index)).getText());
            return this.index + 1;
        }
    }

    class RewriteOperation {
        protected int instructionIndex;
        protected int index;
        protected Object text;

        protected RewriteOperation(int index, Object text) {
            this.index = index;
            this.text = text;
        }

        public int execute(StringBuffer buf) {
            return this.index;
        }

        public String toString() {
            String opName = this.getClass().getName();
            int $index = opName.indexOf(36);
            opName = opName.substring($index + 1, opName.length());
            return "<" + opName + "@" + this.index + ":\"" + this.text + "\">";
        }
    }
}

