/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.io.protocol;

import com.google.appengine.repackaged.com.google.common.base.Charsets;
import com.google.appengine.repackaged.com.google.common.base.Function;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.repackaged.com.google.common.collect.Interner;
import com.google.appengine.repackaged.com.google.common.collect.Interners;
import com.google.appengine.repackaged.com.google.common.collect.Iterators;
import com.google.appengine.repackaged.com.google.common.collect.Lists;
import com.google.appengine.repackaged.com.google.io.protocol.Protocol;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolMessage;
import com.google.appengine.repackaged.com.google.io.protocol.UninterpretedTags;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class ProtocolSupport {
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    public static final int[] EMPTY_INT_ARRAY = new int[0];
    public static final long[] EMPTY_LONG_ARRAY = new long[0];
    public static final float[] EMPTY_FLOAT_ARRAY = new float[0];
    public static final double[] EMPTY_DOUBLE_ARRAY = new double[0];
    public static final boolean[] EMPTY_BOOLEAN_ARRAY = new boolean[0];
    public static final String UNINTERPRETED_TAGS_FIELD = "uninterpreted";
    private static final Interner<String> STRING_INTERNER = Interners.newWeakInterner();
    private static final int ENSURE_CAPACITY_EXTRA = 10;

    public static String internString(String s) {
        Preconditions.checkNotNull(s);
        return STRING_INTERNER.intern(s);
    }

    public static <T> T unsupportedOperation() {
        throw new UnsupportedOperationException("Modifying immutable object");
    }

    public static int hashCode(boolean b) {
        return b ? 1 : 0;
    }

    public static int hashCode(int i) {
        return i;
    }

    public static int hashCode(long l) {
        return (int)(l + (l >>> 32));
    }

    public static int hashCode(float f) {
        return Float.floatToIntBits(f);
    }

    public static int hashCode(double d) {
        long l = Double.doubleToLongBits(d);
        return (int)(l + (l >>> 32));
    }

    public static <T> T[] growArray(T[] array) {
        int newLength = Math.max(4, array.length * 2);
        Class<?> newType = array.getClass();
        Object[] copy = newType == Object[].class ? new Object[newLength] : (Object[])Array.newInstance(newType.getComponentType(), newLength);
        System.arraycopy(array, 0, copy, 0, Math.min(array.length, newLength));
        Object[] arr = copy;
        return arr;
    }

    public static boolean[] growArray(boolean[] array) {
        int newLength = Math.max(4, array.length * 2);
        boolean[] copy = new boolean[newLength];
        System.arraycopy(array, 0, copy, 0, Math.min(array.length, newLength));
        return copy;
    }

    public static int[] growArray(int[] array) {
        int newLength = Math.max(4, array.length * 2);
        int[] copy = new int[newLength];
        System.arraycopy(array, 0, copy, 0, Math.min(array.length, newLength));
        return copy;
    }

    public static long[] growArray(long[] array) {
        int newLength = Math.max(4, array.length * 2);
        long[] copy = new long[newLength];
        System.arraycopy(array, 0, copy, 0, Math.min(array.length, newLength));
        return copy;
    }

    public static float[] growArray(float[] array) {
        int newLength = Math.max(4, array.length * 2);
        float[] copy = new float[newLength];
        System.arraycopy(array, 0, copy, 0, Math.min(array.length, newLength));
        return copy;
    }

    public static double[] growArray(double[] array) {
        int newLength = Math.max(4, array.length * 2);
        double[] copy = new double[newLength];
        System.arraycopy(array, 0, copy, 0, Math.min(array.length, newLength));
        return copy;
    }

    public static boolean[] ensureCapacity(boolean[] array, int size) {
        if (size > array.length) {
            return Arrays.copyOf(array, size + 10);
        }
        return array;
    }

    public static int[] ensureCapacity(int[] array, int size) {
        if (size > array.length) {
            return Arrays.copyOf(array, size + 10);
        }
        return array;
    }

    public static long[] ensureCapacity(long[] array, int size) {
        if (size > array.length) {
            return Arrays.copyOf(array, size + 10);
        }
        return array;
    }

    public static float[] ensureCapacity(float[] array, int size) {
        if (size > array.length) {
            return Arrays.copyOf(array, size + 10);
        }
        return array;
    }

    public static double[] ensureCapacity(double[] array, int size) {
        if (size > array.length) {
            return Arrays.copyOf(array, size + 10);
        }
        return array;
    }

    public static List<Integer> asList(final int[] array, final int start, final int end) {
        return new AbstractList<Integer>(){
            private int listSize;
            {
                this.listSize = end - start;
            }

            @Override
            public int size() {
                return this.listSize;
            }

            @Override
            public Integer get(int i) {
                if (i < 0 || i >= this.listSize) {
                    throw new ArrayIndexOutOfBoundsException();
                }
                return array[i + start];
            }
        };
    }

    public static List<Long> asList(final long[] array, final int start, final int end) {
        return new AbstractList<Long>(){
            private int listSize;
            {
                this.listSize = end - start;
            }

            @Override
            public int size() {
                return this.listSize;
            }

            @Override
            public Long get(int i) {
                if (i < 0 || i >= this.listSize) {
                    throw new ArrayIndexOutOfBoundsException();
                }
                return array[i + start];
            }
        };
    }

    public static List<Float> asList(final float[] array, final int start, final int end) {
        return new AbstractList<Float>(){
            private int listSize;
            {
                this.listSize = end - start;
            }

            @Override
            public int size() {
                return this.listSize;
            }

            @Override
            public Float get(int i) {
                if (i < 0 || i >= this.listSize) {
                    throw new ArrayIndexOutOfBoundsException();
                }
                return Float.valueOf(array[i + start]);
            }
        };
    }

    public static List<Double> asList(final double[] array, final int start, final int end) {
        return new AbstractList<Double>(){
            private int listSize;
            {
                this.listSize = end - start;
            }

            @Override
            public int size() {
                return this.listSize;
            }

            @Override
            public Double get(int i) {
                if (i < 0 || i >= this.listSize) {
                    throw new ArrayIndexOutOfBoundsException();
                }
                return array[i + start];
            }
        };
    }

    public static List<Boolean> asList(final boolean[] array, final int start, final int end) {
        return new AbstractList<Boolean>(){
            private int listSize;
            {
                this.listSize = end - start;
            }

            @Override
            public int size() {
                return this.listSize;
            }

            @Override
            public Boolean get(int i) {
                if (i < 0 || i >= this.listSize) {
                    throw new ArrayIndexOutOfBoundsException();
                }
                return array[i + start];
            }
        };
    }

    public static Iterator<String> byteArrayToUnicodeIterator(List<byte[]> data) {
        return ByteArrayToUnicodeFunction.getInstance().asList(data).iterator();
    }

    public static Iterator<String> byteArrayToUnicodeIterator(List<byte[]> data, Charset cs) {
        return ByteArrayToUnicodeFunction.getInstance(cs).asList(data).iterator();
    }

    public static <T> Iterator<T> emptyIterator() {
        return Iterators.emptyIterator();
    }

    public static List<String> byteArrayToUnicodeList(List<byte[]> data) {
        return ByteArrayToUnicodeFunction.getInstance().asList(data);
    }

    public static List<String> byteArrayToUnicodeList(List<byte[]> data, Charset cs) {
        return ByteArrayToUnicodeFunction.getInstance(cs).asList(data);
    }

    public static byte[] toBytes(String str, Charset charset) {
        return str != null ? str.getBytes(charset) : null;
    }

    public static byte[] toBytesUtf8(String str) {
        return ProtocolSupport.toBytes(str, Charsets.UTF_8);
    }

    public static String toString(byte[] data, Charset charset) {
        return data != null ? new String(data, charset) : null;
    }

    public static String toStringUtf8(byte[] data) {
        return data != null ? ProtocolSupport.toStringUtf8(data, 0, data.length) : null;
    }

    public static String toStringUtf8(byte[] data, int offset, int length) {
        return data != null ? new String(data, offset, length, Charsets.UTF_8) : null;
    }

    public static <T extends ProtocolMessage> T newInstance(Class<T> clazz) {
        try {
            return (T)((ProtocolMessage)clazz.newInstance());
        }
        catch (InstantiationException e) {
            if (clazz == ProtocolMessage.class) {
                throw new IllegalArgumentException("ProtocolMessage.class cannot be instantiated");
            }
            throw new AssertionError((Object)"Protocol messages should always be instantiable");
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)"Protocol messages constructors should always be public");
        }
    }

    public static UninterpretedTags getUninterpreted(ProtocolMessage pb) {
        if (pb == null) {
            return null;
        }
        Class<?> clazz = pb.getClass();
        try {
            Field utagsField = clazz.getDeclaredField(UNINTERPRETED_TAGS_FIELD);
            utagsField.setAccessible(true);
            UninterpretedTags utags = (UninterpretedTags)utagsField.get(pb);
            if (utags == null) {
                return null;
            }
            UninterpretedTags utagsClone = new UninterpretedTags();
            for (Map.Entry message : utags.entries()) {
                utagsClone.put(Integer.valueOf((Integer)message.getKey()), ((byte[])message.getValue()).clone());
            }
            return utagsClone;
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchFieldException e) {
            return new UninterpretedTags();
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static int[] freezeArray(int[] arg, int size) {
        if (size == 0) {
            return EMPTY_INT_ARRAY;
        }
        if (ProtocolSupport.isArrayTooBig(arg.length, size)) {
            return Arrays.copyOf(arg, size);
        }
        return arg;
    }

    public static long[] freezeArray(long[] arg, int size) {
        if (size == 0) {
            return EMPTY_LONG_ARRAY;
        }
        if (ProtocolSupport.isArrayTooBig(arg.length, size)) {
            return Arrays.copyOf(arg, size);
        }
        return arg;
    }

    public static float[] freezeArray(float[] arg, int size) {
        if (size == 0) {
            return EMPTY_FLOAT_ARRAY;
        }
        if (ProtocolSupport.isArrayTooBig(arg.length, size)) {
            return Arrays.copyOf(arg, size);
        }
        return arg;
    }

    public static double[] freezeArray(double[] arg, int size) {
        if (size == 0) {
            return EMPTY_DOUBLE_ARRAY;
        }
        if (ProtocolSupport.isArrayTooBig(arg.length, size)) {
            return Arrays.copyOf(arg, size);
        }
        return arg;
    }

    public static boolean[] freezeArray(boolean[] arg, int size) {
        if (size == 0) {
            return EMPTY_BOOLEAN_ARRAY;
        }
        if (ProtocolSupport.isArrayTooBig(arg.length, size)) {
            return Arrays.copyOf(arg, size);
        }
        return arg;
    }

    public static <T extends ProtocolMessage<T>> List<T> freezeMessages(List<T> list) {
        if (list == null) {
            return null;
        }
        if (list.size() == 0) {
            return ImmutableList.of();
        }
        for (ProtocolMessage item : list) {
            item.freeze();
        }
        return list;
    }

    public static <T> List<T> freezeStrings(List<T> list) {
        if (list == null) {
            return null;
        }
        if (list.size() == 0) {
            return ImmutableList.of();
        }
        return list;
    }

    public static byte[] freezeString(byte[] arg) {
        if (arg.length == 0) {
            return EMPTY_BYTE_ARRAY;
        }
        return arg;
    }

    public static String freezeString(String arg) {
        return ProtocolSupport.internString(arg);
    }

    private static boolean isArrayTooBig(int capacity, int size) {
        return capacity - size >= 10 && size * 4 <= capacity * 3;
    }

    public static <T extends ProtocolMessage<T>> List<T> unfreezeMessages(List<T> list) {
        if (list == null) {
            return null;
        }
        if (list instanceof ImmutableList) {
            list = new ArrayList<T>(list);
        }
        for (ProtocolMessage item : list) {
            item.unfreeze();
        }
        return list;
    }

    public static <T> List<T> unfreezeStrings(List<T> list) {
        if (list == null) {
            return null;
        }
        if (list instanceof ImmutableList) {
            list = new ArrayList<T>(4);
        }
        return list;
    }

    public static <T extends ProtocolMessage<T>> boolean isFrozenMessages(List<T> list) {
        if (list == null) {
            return false;
        }
        if (list instanceof ImmutableList) {
            return true;
        }
        for (ProtocolMessage message : list) {
            if (!message.isFrozen()) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean isFrozenStrings(List<T> list) {
        return list instanceof ImmutableList;
    }

    public static <T> List<T> unmodifiableList(List<T> list) {
        if (list == null) {
            return ImmutableList.of();
        }
        return Collections.unmodifiableList(list);
    }

    private ProtocolSupport() {
    }

    private static class ByteArrayToUnicodeFunction
    implements Function<byte[], String> {
        static final ByteArrayToUnicodeFunction defaultFunction = new ByteArrayToUnicodeFunction(Charsets.UTF_8);
        private final Charset cs;

        static ByteArrayToUnicodeFunction getInstance() {
            return defaultFunction;
        }

        static ByteArrayToUnicodeFunction getInstance(Charset cs) {
            return new ByteArrayToUnicodeFunction(cs);
        }

        private ByteArrayToUnicodeFunction(Charset cs) {
            this.cs = cs;
        }

        @Override
        public String apply(byte[] object) {
            return Protocol.toString(object, this.cs);
        }

        List<String> asList(List<byte[]> data) {
            if (data == null) {
                return ImmutableList.of();
            }
            return Collections.unmodifiableList(Lists.transform(data, this));
        }
    }
}

