/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.search.query;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;

public abstract class QueryTreeContext<T extends QueryTreeContext<T>> {
    private final List<T> children = new ArrayList<T>();
    private RewriteMode rewriteMode = null;
    private Set<Type> returnTypes = EnumSet.noneOf(Type.class);
    private Kind kind = Kind.VOID;
    private String text;

    protected QueryTreeContext() {
    }

    public T addChild() {
        T childContext = this.newChildContext();
        this.children.add(childContext);
        return childContext;
    }

    protected abstract T newChildContext();

    public Iterable<T> children() {
        return this.children;
    }

    public int getChildCount() {
        return this.children.size();
    }

    public T getChild(int index) {
        return (T)((QueryTreeContext)this.children.get(index));
    }

    public void addReturnType(Type type) {
        this.returnTypes.add(type);
    }

    public void setReturnType(Type type) {
        this.returnTypes = EnumSet.of(type);
    }

    public void setReturnTypes(Set<Type> type) {
        this.returnTypes = EnumSet.copyOf(type);
    }

    protected Set<Type> getReturnTypes() {
        return EnumSet.copyOf(this.returnTypes);
    }

    public Set<Type> getCommonReturnTypes(T other) {
        Set<Type> common = this.getReturnTypes();
        common.retainAll(((QueryTreeContext)other).getReturnTypes());
        return common;
    }

    public boolean isCompatibleWith(Type returnType) {
        if (returnType == null) {
            return false;
        }
        EnumSet<Type> set = EnumSet.of(returnType);
        set.retainAll(this.returnTypes);
        return !set.isEmpty();
    }

    public void setRewriteMode(RewriteMode mode) {
        this.rewriteMode = mode;
    }

    public boolean isFuzzy() {
        return RewriteMode.FUZZY.equals((Object)this.rewriteMode);
    }

    public boolean isStrict() {
        return RewriteMode.STRICT.equals((Object)this.rewriteMode);
    }

    public void setKind(Kind kind) {
        this.kind = kind;
    }

    public boolean isPhrase() {
        return Kind.PHRASE.equals((Object)this.kind);
    }

    public boolean isFunction() {
        return Kind.FUNCTION.equals((Object)this.kind);
    }

    public boolean isField() {
        return Kind.FIELD.equals((Object)this.kind);
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String toString() {
        return this.text;
    }

    public static enum Kind {
        VOID,
        LITERAL,
        PHRASE,
        FIELD,
        FUNCTION,
        EXPRESSION;

    }

    public static enum RewriteMode {
        STRICT,
        FUZZY;

    }

    public static enum Type {
        BOOL,
        TEXT,
        NUMBER,
        DATE,
        LOCATION;

    }
}

