/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.search;

import com.google.appengine.api.search.Cursor;
import com.google.appengine.api.search.FieldExpression;
import com.google.appengine.api.search.SortOptions;
import com.google.appengine.api.search.Util;
import com.google.appengine.api.search.checkers.Preconditions;
import com.google.appengine.api.search.checkers.QueryOptionsChecker;
import com.google.appengine.repackaged.com.google.appengine.api.search.SearchServicePb;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class QueryOptions {
    private final int limit;
    private final int numberFoundAccuracy;
    private final List<String> fieldsToReturn;
    private final List<String> fieldsToSnippet;
    private final List<FieldExpression> expressionsToReturn;
    private final SortOptions sortOptions;
    private final Cursor cursor;
    private final Integer offset;
    private final Boolean idsOnly;

    private QueryOptions(Builder builder) {
        this.limit = QueryOptionsChecker.checkLimit(Util.defaultIfNull(builder.limit, 20));
        this.numberFoundAccuracy = Util.defaultIfNull(builder.numberFoundAccuracy, 100);
        this.sortOptions = builder.sortOptions;
        this.cursor = builder.cursor;
        this.offset = QueryOptionsChecker.checkOffset(builder.offset);
        this.fieldsToReturn = new ArrayList<String>(builder.fieldsToReturn);
        this.fieldsToSnippet = new ArrayList<String>(builder.fieldsToSnippet);
        this.expressionsToReturn = new ArrayList<FieldExpression>(builder.expressionsToReturn);
        this.idsOnly = builder.idsOnly;
        this.checkValid();
    }

    public int getLimit() {
        return this.limit;
    }

    public Cursor getCursor() {
        return this.cursor;
    }

    public int getOffset() {
        return this.offset == null ? 0 : this.offset;
    }

    public int getNumberFoundAccuracy() {
        return this.numberFoundAccuracy;
    }

    public SortOptions getSortOptions() {
        return this.sortOptions;
    }

    public boolean isReturningIdsOnly() {
        return this.idsOnly == null ? false : this.idsOnly;
    }

    public List<String> getFieldsToReturn() {
        return Collections.unmodifiableList(this.fieldsToReturn);
    }

    public List<String> getFieldsToSnippet() {
        return Collections.unmodifiableList(this.fieldsToSnippet);
    }

    public List<FieldExpression> getExpressionsToReturn() {
        return Collections.unmodifiableList(this.expressionsToReturn);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(QueryOptions request) {
        return new Builder(request);
    }

    private QueryOptions checkValid() {
        Preconditions.checkNotNull(this.limit, "number of documents to return cannot be null");
        QueryOptionsChecker.checkFieldNames(this.fieldsToReturn);
        return this;
    }

    private static String quoteString(String argument) {
        return "\"" + argument.replace("\"", "\\\"") + "\"";
    }

    SearchServicePb.SearchParams.Builder copyToProtocolBuffer(SearchServicePb.SearchParams.Builder builder, String query) {
        builder.setLimit(this.getLimit());
        if (this.cursor != null) {
            this.cursor.copyToProtocolBuffer(builder);
        } else {
            builder.setCursorType(SearchServicePb.SearchParams.CursorType.NONE);
        }
        if (this.offset != null) {
            builder.setOffset(this.offset);
        }
        if (this.idsOnly != null) {
            builder.setKeysOnly(this.idsOnly);
        }
        builder.setMatchedCountAccuracy(this.numberFoundAccuracy);
        if (this.sortOptions != null) {
            this.sortOptions.copyToProtocolBuffer(builder);
        }
        if (!(this.fieldsToReturn.isEmpty() && this.fieldsToSnippet.isEmpty() && this.expressionsToReturn.isEmpty())) {
            SearchServicePb.FieldSpec.Builder fieldSpec = SearchServicePb.FieldSpec.newBuilder();
            fieldSpec.addAllName(this.fieldsToReturn);
            for (String field : this.fieldsToSnippet) {
                FieldExpression.Builder expressionBuilder = FieldExpression.newBuilder().setName(field);
                expressionBuilder.setExpression("snippet(" + QueryOptions.quoteString(query) + ", " + field + ")");
                fieldSpec.addExpression(expressionBuilder.build().copyToProtocolBuffer());
            }
            for (FieldExpression expression : this.expressionsToReturn) {
                fieldSpec.addExpression(expression.copyToProtocolBuffer());
            }
            builder.setFieldSpec(fieldSpec);
        }
        return builder;
    }

    public String toString() {
        return String.format("QueryOptions(limit=%d%s%s%s%s%s, numberFoundAccuracy=%d%s%s)", this.limit, Util.fieldToString("IDsOnly", this.idsOnly), Util.fieldToString("sortOptions", this.sortOptions), Util.iterableFieldToString("fieldsToReturn", this.fieldsToReturn), Util.iterableFieldToString("fieldsToSnippet", this.fieldsToSnippet), Util.iterableFieldToString("expressionsToReturn", this.expressionsToReturn), this.numberFoundAccuracy, Util.fieldToString("cursor", this.cursor), Util.fieldToString("offset", this.offset));
    }

    public static final class Builder {
        private Integer limit;
        private List<String> fieldsToReturn = new ArrayList<String>();
        private List<String> fieldsToSnippet = new ArrayList<String>();
        private List<FieldExpression> expressionsToReturn = new ArrayList<FieldExpression>();
        private SortOptions sortOptions;
        private Cursor cursor;
        private Integer numberFoundAccuracy;
        private Integer offset;
        private Boolean idsOnly;

        private Builder() {
        }

        private Builder(QueryOptions request) {
            this.limit = request.getLimit();
            this.cursor = request.getCursor();
            this.numberFoundAccuracy = request.getNumberFoundAccuracy();
            this.sortOptions = request.getSortOptions();
            this.fieldsToReturn = new ArrayList<String>(request.getFieldsToReturn());
            this.expressionsToReturn = new ArrayList<FieldExpression>(request.getExpressionsToReturn());
        }

        public Builder setLimit(int limit) {
            this.limit = QueryOptionsChecker.checkLimit(limit);
            return this;
        }

        public Builder setCursor(Cursor cursor) {
            Preconditions.checkArgument(this.offset == null || cursor == null, "offset and cursor cannot be set in the same request");
            this.cursor = cursor;
            return this;
        }

        public Builder setCursor(Cursor.Builder cursorBuilder) {
            return this.setCursor(cursorBuilder.build());
        }

        public Builder setOffset(int offset) {
            Preconditions.checkArgument(this.cursor == null, "offset and cursor cannot be set in the same request");
            this.offset = QueryOptionsChecker.checkOffset(offset);
            return this;
        }

        public Builder setNumberFoundAccuracy(int numberFoundAccuracy) {
            this.numberFoundAccuracy = QueryOptionsChecker.checkNumberFoundAccuracy(numberFoundAccuracy);
            return this;
        }

        public Builder setFieldsToReturn(String ... fields) {
            Preconditions.checkNotNull(fields, "field names cannot be null");
            Preconditions.checkArgument(this.idsOnly == null, "You may not set fields to return if search returns keys only");
            ArrayList<String> returningFields = new ArrayList<String>(fields.length);
            for (String field : fields) {
                returningFields.add(field);
            }
            this.fieldsToReturn = QueryOptionsChecker.checkFieldNames(returningFields);
            return this;
        }

        public Builder setFieldsToSnippet(String ... fieldsToSnippet) {
            Preconditions.checkNotNull(this.fieldsToReturn, "field names cannot be null");
            ArrayList<String> snippetingFields = new ArrayList<String>(fieldsToSnippet.length);
            for (String field : fieldsToSnippet) {
                snippetingFields.add(field);
            }
            this.fieldsToSnippet = QueryOptionsChecker.checkFieldNames(snippetingFields);
            return this;
        }

        public Builder addExpressionToReturn(FieldExpression.Builder expressionBuilder) {
            Preconditions.checkArgument(this.idsOnly == null, "You may not add expressions to return if search returns keys only");
            return this.addExpressionToReturn(expressionBuilder.build());
        }

        public Builder setReturningIdsOnly(boolean idsOnly) {
            Preconditions.checkArgument(this.expressionsToReturn.isEmpty(), "You cannot request IDs only if expressions to return are set");
            Preconditions.checkArgument(this.fieldsToReturn.isEmpty(), "You cannot request IDs only if fields to return are already set");
            this.idsOnly = idsOnly;
            return this;
        }

        public Builder addExpressionToReturn(FieldExpression expression) {
            this.expressionsToReturn.add(expression);
            return this;
        }

        public Builder setSortOptions(SortOptions sortOptions) {
            this.sortOptions = sortOptions;
            return this;
        }

        public Builder setSortOptions(SortOptions.Builder builder) {
            this.sortOptions = builder.build();
            return this;
        }

        public QueryOptions build() {
            return new QueryOptions(this);
        }
    }
}

