/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.search;

import com.google.appengine.api.search.checkers.GeoPointChecker;
import com.google.apphosting.api.search.DocumentPb;

public class GeoPoint {
    private final double latitude;
    private final double longitude;

    public GeoPoint(double latitude, double longitude) {
        this.latitude = GeoPointChecker.checkLatitude(latitude);
        this.longitude = GeoPointChecker.checkLongitude(longitude);
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    DocumentPb.FieldValue.Geo copyToProtocolBuffer() {
        DocumentPb.FieldValue.Geo geoPb = DocumentPb.FieldValue.Geo.newBuilder().setLat(this.getLatitude()).setLng(this.getLongitude()).build();
        return geoPb;
    }

    static GeoPoint newGeoPoint(DocumentPb.FieldValue.Geo geoPb) {
        return new GeoPoint(geoPb.getLat(), geoPb.getLng());
    }

    public String toString() {
        return String.format("GeoPoint(latitude=%f, longitude=%f)", this.getLatitude(), this.getLongitude());
    }
}

