/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.log;

import com.google.appengine.api.log.LogService;
import com.google.appengine.repackaged.com.google.common.base.Pair;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class LogQuery
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 3660093076203855168L;
    private String offset;
    private Long startTimeUsec;
    private Long endTimeUsec;
    private int batchSize = 20;
    private LogService.LogLevel minLogLevel;
    private boolean includeIncomplete = false;
    private boolean includeAppLogs = false;
    private List<String> majorVersionIds = new ArrayList<String>();
    private List<Pair<String, String>> serverVersions = new ArrayList<Pair<String, String>>();
    private List<String> requestIds = new ArrayList<String>();
    private static final String MAJOR_VERSION_ID_REGEX = "[a-z\\d][a-z\\d\\-]{0,99}";
    private static final Pattern VERSION_PATTERN = Pattern.compile("[a-z\\d][a-z\\d\\-]{0,99}");
    private static final String REQUEST_ID_REGEX = "\\A\\p{XDigit}+\\z";
    private static final Pattern REQUEST_ID_PATTERN = Pattern.compile("\\A\\p{XDigit}+\\z");

    public LogQuery clone() {
        LogQuery clone;
        try {
            clone = (LogQuery)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        clone.majorVersionIds = new ArrayList<String>(this.majorVersionIds);
        clone.serverVersions = new ArrayList<Pair<String, String>>(this.serverVersions);
        clone.requestIds = new ArrayList<String>(this.requestIds);
        return clone;
    }

    public LogQuery offset(String offset) {
        this.offset = offset;
        return this;
    }

    public LogQuery startTimeMillis(long startTimeMillis) {
        this.startTimeUsec = startTimeMillis * 1000L;
        return this;
    }

    public LogQuery startTimeUsec(long startTimeUsec) {
        this.startTimeUsec = startTimeUsec;
        return this;
    }

    public LogQuery endTimeMillis(long endTimeMillis) {
        this.endTimeUsec = endTimeMillis * 1000L;
        return this;
    }

    public LogQuery endTimeUsec(long endTimeUsec) {
        this.endTimeUsec = endTimeUsec;
        return this;
    }

    public LogQuery batchSize(int batchSize) {
        if (batchSize < 1) {
            throw new IllegalArgumentException("batchSize must be greater than zero");
        }
        this.batchSize = batchSize;
        return this;
    }

    public LogQuery minLogLevel(LogService.LogLevel minLogLevel) {
        this.minLogLevel = minLogLevel;
        return this;
    }

    public LogQuery includeIncomplete(boolean includeIncomplete) {
        this.includeIncomplete = includeIncomplete;
        return this;
    }

    public LogQuery includeAppLogs(boolean includeAppLogs) {
        this.includeAppLogs = includeAppLogs;
        return this;
    }

    public LogQuery majorVersionIds(List<String> versionIds) {
        if (!this.serverVersions.isEmpty()) {
            throw new IllegalArgumentException("The serverVersions() method has already been called, only one of majorVersionIds() or serverVersions() may be called on a LogQuery instance.");
        }
        for (String versionId : versionIds) {
            Matcher matcher = VERSION_PATTERN.matcher(versionId);
            if (matcher.matches()) continue;
            throw new IllegalArgumentException("versionIds must only contain valid major version identifiers. Version " + versionId + " is not a valid " + "major version identifier.");
        }
        this.majorVersionIds = versionIds;
        return this;
    }

    public LogQuery serverVersions(List<Pair<String, String>> serverVersions) {
        if (!this.majorVersionIds.isEmpty()) {
            throw new IllegalArgumentException("The majorVersionIds() method has already been called, only one of majorVersionIds() or serverVersions() may be called on a LogQuery instance.");
        }
        for (Pair<String, String> serverVersion : serverVersions) {
            Matcher matcher = VERSION_PATTERN.matcher((CharSequence)serverVersion.first);
            if (!matcher.matches()) {
                throw new IllegalArgumentException("serverVersions must only contain valid server identifiers. Server " + (String)serverVersion.first + " is not a valid " + "server identifier.");
            }
            matcher = VERSION_PATTERN.matcher((CharSequence)serverVersion.second);
            if (matcher.matches()) continue;
            throw new IllegalArgumentException("serverVersions must only contain valid version identifiers. Version " + (String)serverVersion.second + " is not a valid " + "version identifier.");
        }
        this.serverVersions = serverVersions;
        return this;
    }

    public LogQuery requestIds(List<String> requestIds) {
        HashSet<String> seen = new HashSet<String>();
        for (String requestId : requestIds) {
            if (!seen.add(requestId)) {
                throw new IllegalArgumentException("requestIds must be unique.");
            }
            Matcher matcher = REQUEST_ID_PATTERN.matcher(requestId);
            if (matcher.matches()) continue;
            throw new IllegalArgumentException("requestIds must only contain valid request ids. " + requestId + " is not a valid " + "request id.");
        }
        this.requestIds = requestIds;
        return this;
    }

    public String getOffset() {
        return this.offset;
    }

    public Integer getBatchSize() {
        return this.batchSize;
    }

    public Long getEndTimeMillis() {
        return this.endTimeUsec != null ? Long.valueOf(this.endTimeUsec / 1000L) : null;
    }

    public Long getEndTimeUsec() {
        return this.endTimeUsec;
    }

    public Boolean getIncludeAppLogs() {
        return this.includeAppLogs;
    }

    public Boolean getIncludeIncomplete() {
        return this.includeIncomplete;
    }

    public LogService.LogLevel getMinLogLevel() {
        return this.minLogLevel;
    }

    public Long getStartTimeMillis() {
        return this.startTimeUsec != null ? Long.valueOf(this.startTimeUsec / 1000L) : null;
    }

    public Long getStartTimeUsec() {
        return this.startTimeUsec;
    }

    public List<String> getMajorVersionIds() {
        return this.majorVersionIds;
    }

    public List<Pair<String, String>> getServerVersions() {
        return this.serverVersions;
    }

    public List<String> getRequestIds() {
        return this.requestIds;
    }

    public static final class Builder {
        public static LogQuery withOffset(String offset) {
            return Builder.withDefaults().offset(offset);
        }

        public static LogQuery withStartTimeMillis(long startTimeMillis) {
            return Builder.withDefaults().startTimeMillis(startTimeMillis);
        }

        public static LogQuery withStartTimeUsec(long startTimeUsec) {
            return Builder.withDefaults().startTimeUsec(startTimeUsec);
        }

        public static LogQuery withEndTimeMillis(long endTimeMillis) {
            return Builder.withDefaults().endTimeMillis(endTimeMillis);
        }

        public static LogQuery withEndTimeUsec(long endTimeUsec) {
            return Builder.withDefaults().endTimeUsec(endTimeUsec);
        }

        public static LogQuery withBatchSize(int batchSize) {
            return Builder.withDefaults().batchSize(batchSize);
        }

        public static LogQuery withMinLogLevel(LogService.LogLevel minLogLevel) {
            return Builder.withDefaults().minLogLevel(minLogLevel);
        }

        public static LogQuery withIncludeIncomplete(boolean includeIncomplete) {
            return Builder.withDefaults().includeIncomplete(includeIncomplete);
        }

        public static LogQuery withIncludeAppLogs(boolean includeAppLogs) {
            return Builder.withDefaults().includeAppLogs(includeAppLogs);
        }

        public static LogQuery withMajorVersionIds(List<String> versionIds) {
            return Builder.withDefaults().majorVersionIds(versionIds);
        }

        public static LogQuery withServerVersions(List<Pair<String, String>> serverVersionIds) {
            return Builder.withDefaults().serverVersions(serverVersionIds);
        }

        public static LogQuery withRequestIds(List<String> requestIds) {
            return Builder.withDefaults().requestIds(requestIds);
        }

        public static LogQuery withDefaults() {
            return new LogQuery();
        }
    }
}

