/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.files;

import com.google.appengine.api.files.Crc32c;
import com.google.appengine.api.files.FileReadChannel;
import com.google.appengine.api.files.RecordConstants;
import com.google.appengine.api.files.RecordReadChannel;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.logging.Logger;

final class RecordReadChannelImpl
implements RecordReadChannel {
    private static final Logger log = Logger.getLogger(RecordReadChannelImpl.class.getName());
    private final Object lock = new Object();
    private final FileReadChannel input;
    private ByteBuffer blockBuffer;
    private ByteBuffer finalRecord;

    RecordReadChannelImpl(FileReadChannel input) {
        this.input = input;
        this.blockBuffer = ByteBuffer.allocate(32768);
        this.blockBuffer.order(ByteOrder.LITTLE_ENDIAN);
        this.finalRecord = ByteBuffer.allocate(32768);
        this.finalRecord.order(ByteOrder.LITTLE_ENDIAN);
    }

    @Override
    public ByteBuffer readRecord() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.finalRecord.clear();
            RecordConstants.RecordType lastRead = RecordConstants.RecordType.NONE;
            while (true) {
                try {
                    while (true) {
                        Record record;
                        if ((record = this.readPhysicalRecord()) == null) {
                            return null;
                        }
                        switch (record.type()) {
                            case NONE: {
                                this.validateRemainderIsEmpty();
                                break;
                            }
                            case FULL: {
                                if (lastRead != RecordConstants.RecordType.NONE) {
                                    throw new RecordReadException("Invalid RecordType: " + (Object)((Object)record.type));
                                }
                                return record.data().slice();
                            }
                            case FIRST: {
                                if (lastRead != RecordConstants.RecordType.NONE) {
                                    throw new RecordReadException("Invalid RecordType: " + (Object)((Object)record.type));
                                }
                                this.finalRecord = RecordReadChannelImpl.appendToBuffer(this.finalRecord, record.data());
                                break;
                            }
                            case MIDDLE: {
                                if (lastRead == RecordConstants.RecordType.NONE) {
                                    throw new RecordReadException("Invalid RecordType: " + (Object)((Object)record.type));
                                }
                                this.finalRecord = RecordReadChannelImpl.appendToBuffer(this.finalRecord, record.data());
                                break;
                            }
                            case LAST: {
                                if (lastRead == RecordConstants.RecordType.NONE) {
                                    throw new RecordReadException("Invalid RecordType: " + (Object)((Object)record.type));
                                }
                                this.finalRecord = RecordReadChannelImpl.appendToBuffer(this.finalRecord, record.data());
                                this.finalRecord.flip();
                                return this.finalRecord.slice();
                            }
                            default: {
                                throw new RecordReadException("Invalid RecordType: " + record.type.value());
                            }
                        }
                        lastRead = record.type();
                    }
                }
                catch (RecordReadException e) {
                    log.warning(e.getMessage());
                    this.finalRecord.clear();
                    this.sync();
                    continue;
                }
                break;
            }
        }
    }

    private void validateRemainderIsEmpty() throws IOException, RecordReadException {
        int bytesToBlockEnd = (int)(32768L - this.input.position() % 32768L);
        this.blockBuffer.clear();
        this.blockBuffer.limit(bytesToBlockEnd);
        int read = this.input.read(this.blockBuffer);
        if (read != bytesToBlockEnd) {
            throw new RecordReadException("There are " + bytesToBlockEnd + " but " + read + " were read.");
        }
        this.blockBuffer.flip();
        for (int i = 0; i < bytesToBlockEnd; ++i) {
            byte b = this.blockBuffer.get(i);
            if (b == 0) continue;
            throw new RecordReadException("Found a non-zero byte: " + b + " before the end of the block " + i + " bytes after encountering a RecordType of NONE");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long position() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            return this.input.position();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void position(long newPosition) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.input.position(newPosition);
        }
    }

    private Record readPhysicalRecord() throws IOException, RecordReadException {
        int bytesToBlockEnd = (int)(32768L - this.input.position() % 32768L);
        if (bytesToBlockEnd < 7) {
            return new Record(RecordConstants.RecordType.NONE, null);
        }
        this.blockBuffer.clear();
        this.blockBuffer.limit(7);
        int bytesRead = this.input.read(this.blockBuffer);
        if (bytesRead != 7) {
            return null;
        }
        this.blockBuffer.flip();
        int checksum = this.blockBuffer.getInt();
        short length = this.blockBuffer.getShort();
        RecordConstants.RecordType type = RecordConstants.RecordType.get(this.blockBuffer.get());
        if (length > bytesToBlockEnd || length < 0) {
            throw new RecordReadException("Length is too large:" + length);
        }
        this.blockBuffer.clear();
        this.blockBuffer.limit(length);
        bytesRead = this.input.read(this.blockBuffer);
        if (bytesRead != length) {
            return null;
        }
        if (!RecordReadChannelImpl.isValidCrc(checksum, this.blockBuffer, type.value())) {
            throw new RecordReadException("Checksum doesn't validate.");
        }
        this.blockBuffer.flip();
        return new Record(type, this.blockBuffer);
    }

    private void sync() throws IOException {
        long padLength = 32768L - this.input.position() % 32768L;
        this.input.position(this.input.position() + padLength);
    }

    private static boolean isValidCrc(int checksum, ByteBuffer data, byte type) {
        if (checksum == 0 && type == 0 && data.limit() == 0) {
            return true;
        }
        Crc32c crc = new Crc32c();
        crc.update(type);
        crc.update(data.array(), 0, data.limit());
        return RecordConstants.unmaskCrc(checksum) == crc.getValue();
    }

    private static ByteBuffer appendToBuffer(ByteBuffer to, ByteBuffer from) {
        if (to.remaining() < from.remaining()) {
            int capacity = to.capacity();
            while (capacity - to.position() < from.remaining()) {
                capacity *= 2;
            }
            ByteBuffer newBuffer = ByteBuffer.allocate(capacity);
            to.flip();
            newBuffer.put(to);
            to = newBuffer;
            to.order(ByteOrder.LITTLE_ENDIAN);
        }
        to.put(from);
        return to;
    }

    private static final class Record {
        private final ByteBuffer data;
        private final RecordConstants.RecordType type;

        public Record(RecordConstants.RecordType type, ByteBuffer data) {
            this.type = type;
            this.data = data;
        }

        public ByteBuffer data() {
            return this.data;
        }

        public RecordConstants.RecordType type() {
            return this.type;
        }
    }

    static final class RecordReadException
    extends Exception {
        public RecordReadException(String errorMessage) {
            super(errorMessage);
        }
    }
}

