/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api;

import com.google.apphosting.api.ApiProxy;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public final class LifecycleManager {
    private static final LifecycleManager instance = new LifecycleManager();
    private static final Logger log = Logger.getLogger(LifecycleManager.class.getName());
    private boolean shuttingDown = false;
    private long deadline = -1L;
    private Map<String, ShutdownHook> hooks = new HashMap<String, ShutdownHook>();

    private LifecycleManager() {
    }

    public static LifecycleManager getInstance() {
        return instance;
    }

    public boolean isShuttingDown() {
        return this.shuttingDown;
    }

    public synchronized void setShutdownHook(ShutdownHook hook) {
        this.hooks.put(this.currentAppVersionId(), hook);
    }

    public void interruptAllRequests() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                List<Thread> threads = ApiProxy.getRequestThreads();
                if (threads != null) {
                    for (Thread thread : threads) {
                        thread.interrupt();
                    }
                }
                return null;
            }
        });
    }

    public long getRemainingShutdownTime() {
        if (this.deadline == -1L) {
            return -1L;
        }
        return this.deadline - System.currentTimeMillis();
    }

    public synchronized void beginShutdown(long deadline) {
        this.shuttingDown = true;
        this.deadline = deadline;
        ShutdownHook hook = this.hooks.get(this.currentAppVersionId());
        if (hook != null) {
            hook.shutdown();
        }
    }

    private String currentAppVersionId() {
        ApiProxy.Environment env = ApiProxy.getCurrentEnvironment();
        return env.getAppId() + "/" + env.getVersionId();
    }

    public static interface ShutdownHook {
        public void shutdown();
    }
}

