/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.conversion.metadata;

import com.opensymphony.xwork2.conversion.annotations.ConversionRule;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import java.io.PrintWriter;
import java.io.StringWriter;

public class ConversionDescription {
    protected static Logger log = null;
    public static final String KEY_PREFIX = "Key_";
    public static final String ELEMENT_PREFIX = "Element_";
    public static final String KEY_PROPERTY_PREFIX = "KeyProperty_";
    public static final String DEPRECATED_ELEMENT_PREFIX = "Collection_";
    String MAP_PREFIX = "Map_";
    public String property;
    public String typeConverter = "";
    public String rule = "";
    public String value = "";
    public String fullQualifiedClassName;
    public String type = null;

    public ConversionDescription() {
        log = LoggerFactory.getLogger(this.getClass());
    }

    public ConversionDescription(String property) {
        this.property = property;
        log = LoggerFactory.getLogger(this.getClass());
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public void setTypeConverter(String typeConverter) {
        this.typeConverter = typeConverter;
    }

    public void setRule(String rule) {
        if (rule != null && rule.length() > 0) {
            if (rule.equals(ConversionRule.COLLECTION.toString())) {
                this.rule = DEPRECATED_ELEMENT_PREFIX;
            } else if (rule.equals(ConversionRule.ELEMENT.toString())) {
                this.rule = ELEMENT_PREFIX;
            } else if (rule.equals(ConversionRule.KEY.toString())) {
                this.rule = KEY_PREFIX;
            } else if (rule.equals(ConversionRule.KEY_PROPERTY.toString())) {
                this.rule = KEY_PROPERTY_PREFIX;
            } else if (rule.equals(ConversionRule.MAP.toString())) {
                this.rule = this.MAP_PREFIX;
            }
        }
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String asProperty() {
        StringWriter sw = new StringWriter();
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(sw);
            writer.print(this.rule);
            writer.print(this.property);
            writer.print("=");
            if (this.rule.startsWith(KEY_PROPERTY_PREFIX) && this.value != null && this.value.length() > 0) {
                writer.print(this.value);
            } else {
                writer.print(this.typeConverter);
            }
        }
        finally {
            if (writer != null) {
                writer.flush();
                writer.close();
            }
        }
        return sw.toString();
    }

    public String getFullQualifiedClassName() {
        return this.fullQualifiedClassName;
    }

    public void setFullQualifiedClassName(String fullQualifiedClassName) {
        this.fullQualifiedClassName = fullQualifiedClassName;
    }
}

