/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.awt;

import com.lowagie.text.awt.ColorPaintContext;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;

public class Color
implements Paint {
    int value;
    private float[] frgbvalue = null;
    private float[] fvalue = null;
    private float falpha = 0.0f;
    private transient PaintContext theContext;
    public static final Color gray = new Color(128, 128, 128);
    public static final Color white = new Color(255, 255, 255);
    public static final Color black = new Color(0, 0, 0);
    private static final double FACTOR = 0.7;

    public Color(int n, int n2, int n3) {
        this(n, n2, n3, 255);
    }

    public Color(int n, int n2, int n3, int n4) {
        this.value = (n4 & 0xFF) << 24 | (n & 0xFF) << 16 | (n2 & 0xFF) << 8 | (n3 & 0xFF) << 0;
        Color.testColorValueRange(n, n2, n3, n4);
    }

    private static void testColorValueRange(int n, int n2, int n3, int n4) {
        boolean bl = false;
        String string = "";
        if (n4 < 0 || n4 > 255) {
            bl = true;
            string = string + " Alpha";
        }
        if (n < 0 || n > 255) {
            bl = true;
            string = string + " Red";
        }
        if (n2 < 0 || n2 > 255) {
            bl = true;
            string = string + " Green";
        }
        if (n3 < 0 || n3 > 255) {
            bl = true;
            string = string + " Blue";
        }
        if (bl) {
            throw new IllegalArgumentException("Color parameter outside of expected range:" + string);
        }
    }

    public int getRed() {
        return this.getRGB() >> 16 & 0xFF;
    }

    public int getGreen() {
        return this.getRGB() >> 8 & 0xFF;
    }

    public int getBlue() {
        return this.getRGB() >> 0 & 0xFF;
    }

    public int getRGB() {
        return this.value;
    }

    public Color(float f, float f2, float f3) {
        this((int)((double)(f * 255.0f) + 0.5), (int)((double)(f2 * 255.0f) + 0.5), (int)((double)(f3 * 255.0f) + 0.5));
        Color.testColorValueRange(f, f2, f3, 1.0f);
        this.frgbvalue = new float[3];
        this.frgbvalue[0] = f;
        this.frgbvalue[1] = f2;
        this.frgbvalue[2] = f3;
        this.falpha = 1.0f;
        this.fvalue = this.frgbvalue;
    }

    private static void testColorValueRange(float f, float f2, float f3, float f4) {
        boolean bl = false;
        String string = "";
        if ((double)f4 < 0.0 || (double)f4 > 1.0) {
            bl = true;
            string = string + " Alpha";
        }
        if ((double)f < 0.0 || (double)f > 1.0) {
            bl = true;
            string = string + " Red";
        }
        if ((double)f2 < 0.0 || (double)f2 > 1.0) {
            bl = true;
            string = string + " Green";
        }
        if ((double)f3 < 0.0 || (double)f3 > 1.0) {
            bl = true;
            string = string + " Blue";
        }
        if (bl) {
            throw new IllegalArgumentException("Color parameter outside of expected range:" + string);
        }
    }

    public Color darker() {
        return new Color(Math.max((int)((double)this.getRed() * 0.7), 0), Math.max((int)((double)this.getGreen() * 0.7), 0), Math.max((int)((double)this.getBlue() * 0.7), 0));
    }

    public int getAlpha() {
        return this.getRGB() >> 24 & 0xFF;
    }

    public int getTransparency() {
        int n = this.getAlpha();
        if (n == 255) {
            return 1;
        }
        if (n == 0) {
            return 2;
        }
        return 3;
    }

    public synchronized PaintContext createContext(ColorModel colorModel, Rectangle rectangle, Rectangle2D rectangle2D, AffineTransform affineTransform, RenderingHints renderingHints) {
        PaintContext paintContext = this.theContext;
        if (paintContext == null || ((ColorPaintContext)paintContext).color != this.getRGB()) {
            this.theContext = paintContext = new ColorPaintContext(this.getRGB(), colorModel);
        }
        return paintContext;
    }
}

