/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.io.EOFException;
import java.io.InputStream;
import org.hsqldb.ColumnSchema;
import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Session;
import org.hsqldb.Statement;
import org.hsqldb.StatementDML;
import org.hsqldb.StatementSchema;
import org.hsqldb.Table;
import org.hsqldb.TableBase;
import org.hsqldb.error.Error;
import org.hsqldb.lib.IntKeyHashMap;
import org.hsqldb.lib.StopWatch;
import org.hsqldb.persist.Crypto;
import org.hsqldb.result.Result;
import org.hsqldb.scriptio.ScriptReaderBase;
import org.hsqldb.scriptio.ScriptReaderDecode;
import org.hsqldb.scriptio.ScriptReaderText;
import org.hsqldb.store.ValuePool;
import org.hsqldb.types.Type;

public class ScriptRunner {
    public static void runScript(Database database, InputStream inputStream) {
        ScriptReaderText scriptReaderText;
        Crypto crypto = database.logger.getCrypto();
        if (crypto == null) {
            scriptReaderText = new ScriptReaderText(database, inputStream);
        } else {
            try {
                scriptReaderText = new ScriptReaderDecode(database, inputStream, crypto, true);
            }
            catch (Throwable throwable) {
                database.logger.logSevereEvent("opening log file", throwable);
                return;
            }
        }
        ScriptRunner.runScript(database, scriptReaderText);
    }

    public static void runScript(Database database, String string) {
        ScriptReaderText scriptReaderText;
        Crypto crypto = database.logger.getCrypto();
        try {
            scriptReaderText = crypto == null ? new ScriptReaderText(database, string, false) : new ScriptReaderDecode(database, string, crypto, true);
        }
        catch (Throwable throwable) {
            if (!(throwable instanceof EOFException)) {
                database.logger.logSevereEvent("opening log file", throwable);
            }
            return;
        }
        ScriptRunner.runScript(database, scriptReaderText);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runScript(Database database, ScriptReaderBase scriptReaderBase) {
        IntKeyHashMap intKeyHashMap = new IntKeyHashMap();
        Session session = null;
        int n = 0;
        StatementDML statementDML = new StatementDML(81, 2004, null);
        String string = database.getPath();
        boolean bl = database.getURLProperties().isPropertyTrue("hsqldb.full_log_replay");
        statementDML.setCompileTimestamp(Long.MAX_VALUE);
        database.setReferentialIntegrity(false);
        try {
            StopWatch stopWatch = new StopWatch();
            while (scriptReaderBase.readLoggedStatement(session)) {
                int n2 = scriptReaderBase.getSessionNumber();
                if ((session == null || n != n2) && (session = (Session)intKeyHashMap.get(n = n2)) == null) {
                    session = database.getSessionManager().newSessionForLog(database);
                    intKeyHashMap.put(n, session);
                }
                if (session.isClosed()) {
                    intKeyHashMap.remove(n);
                    continue;
                }
                Result result = null;
                int n3 = scriptReaderBase.getStatementType();
                switch (n3) {
                    case 1: {
                        Object object;
                        String string2 = scriptReaderBase.getLoggedStatement();
                        try {
                            Statement statement = session.compileStatement(string2);
                            if (database.getProperties().isVersion18() && statement.getType() == 77) {
                                object = (Table)((StatementSchema)statement).getArguments()[0];
                                for (int i = 0; i < ((TableBase)object).getColumnCount(); ++i) {
                                    ColumnSchema columnSchema = ((Table)object).getColumn(i);
                                    if (!columnSchema.getDataType().isBitType()) continue;
                                    columnSchema.setType(Type.SQL_BOOLEAN);
                                }
                            }
                            result = session.executeCompiledStatement(statement, ValuePool.emptyObjectArray);
                        }
                        catch (Throwable throwable) {
                            result = Result.newErrorResult(throwable);
                        }
                        if (result == null || !result.isError()) break;
                        if (result.getException() != null) {
                            throw result.getException();
                        }
                        throw Error.error(result);
                    }
                    case 4: {
                        session.commit(false);
                        break;
                    }
                    case 3: {
                        session.sessionContext.currentStatement = statementDML;
                        session.beginAction(statementDML);
                        Object object = scriptReaderBase.getData();
                        scriptReaderBase.getCurrentTable().insertNoCheckFromLog(session, (Object[])object);
                        session.endAction(Result.updateOneResult);
                        break;
                    }
                    case 2: {
                        session.sessionContext.currentStatement = statementDML;
                        session.beginAction(statementDML);
                        Object object = scriptReaderBase.getData();
                        scriptReaderBase.getCurrentTable().deleteNoCheckFromLog(session, (Object[])object);
                        session.endAction(Result.updateOneResult);
                        break;
                    }
                    case 6: {
                        Object object = database.schemaManager.findSchemaHsqlName(scriptReaderBase.getCurrentSchema());
                        session.setCurrentSchemaHsqlName((HsqlNameManager.HsqlName)object);
                        break;
                    }
                }
                if (!session.isClosed()) continue;
                intKeyHashMap.remove(n);
            }
        }
        catch (HsqlException hsqlException) {
            String string3 = "statement error processing log " + string + "line: " + scriptReaderBase.getLineNumber();
            database.logger.logSevereEvent(string3, hsqlException);
            if (bl) {
                throw Error.error(hsqlException, 461, string3);
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            String string4 = "out of memory processing log" + string + " line: " + scriptReaderBase.getLineNumber();
            database.logger.logSevereEvent(string4, outOfMemoryError);
            throw Error.error(460);
        }
        catch (Throwable throwable) {
            String string5 = "statement error processing log " + string + "line: " + scriptReaderBase.getLineNumber();
            database.logger.logSevereEvent(string5, throwable);
            if (bl) {
                throw Error.error(throwable, 461, string5);
            }
        }
        finally {
            if (scriptReaderBase != null) {
                scriptReaderBase.close();
            }
            database.getSessionManager().closeAllSessions();
            database.setReferentialIntegrity(true);
        }
    }
}

