<?php
/**
 * Nucleus CMS Translation File
 * Greek in Greece (Latin script)
 * 
 * Nucleus version: v1.0-v2.5
 * Authors: Antonis Scandalis (scandalis@datapages.gr) and Vangelis Pantelias (gelitheworm@limoutsis.gr)
 * Full Revision and update for version 3.1 by Spiros Doikas (www.translatum.gr) on the 30th July 2005.
 *
 * @license http://nucleuscms.org/license.txt GNU General Public License
 * @copyright Copyright (C) 2002-2012 The Nucleus Group
 * @version $Id: el_Latn_GR.UTF-8.php 1837 2012-05-13 04:12:13Z sakamocchi $
 */

/********************************************
 *        Start New for 4.0                 *
 ********************************************/
define('_SKINIE_INVALID_NAMES_DETECTED', 'Invalid skin or templates names detected. Valid names consist of only a-z, A-Z, 0-9, -, and _'); 
define('_LISTS_AUTHOR', 'Author');
define('_OVERVIEW_OTHER_DRAFTS', 'Other Drafts');
 
/********************************************
 *        Start New for 3.6x                *
 ********************************************/
define('_ERROR_USER_TOO_LONG', 'Please enter a name shorter than 40 characters.');
define('_ERROR_EMAIL_TOO_LONG', 'Please enter an email shorter than 100 characters.');
define('_ERROR_URL_TOO_LONG', 'Please enter a website shorter than 100 characters.');

/********************************************
 *        Start New for 3.62                *
 ********************************************/
define('_SETTINGS_ADMINCSS',		'Admin Area Style');

 
/********************************************
 *        Start New for 3.50                *
 ********************************************/
define('_PLUGS_TITLE_GETPLUGINS',		'get more plugins...');
define('_ARCHIVETYPE_YEAR', 'year');
define('_ADMIN_SYSTEMOVERVIEW_LATESTVERSION_TITLE',		'Newer Version Available');
define('_ADMIN_SYSTEMOVERVIEW_LATESTVERSION_TEXT',		'Upgrade available: v');
define('_MANAGER_PLUGINSQLAPI_NOTSUPPORT', "Plugin %s was not loaded (does not support SqlApi and you are trying to use a non-mysql db)");


/********************************************
 *        Start New for 3.40                *
 ********************************************/

// START changed/added after 3.33 START
define('_MEMBERS_USEAUTOSAVE',						'Use the Autosave function?');

define('_TEMPLATE_PLUGIN_FIELDS',					'Custom Plugin Fields');
define('_TEMPLATE_BLOGLIST',						'Template Blog List');
define('_TEMPLATE_BLOGHEADER',						'Blog List Header');
define('_TEMPLATE_BLOGITEM',						'Blog List Item');
define('_TEMPLATE_BLOGFOOTER',						'Blog List Footer');

define('_SETTINGS_DEFAULTLISTSIZE',					'Default Size of Lists in Admin Area');
define('_SETTINGS_DEBUGVARS',		'Debug Vars');

define('_CREATE_ACCOUNT_TITLE',						'Create Member Account');
define('_CREATE_ACCOUNT0',							'Create Account');
define('_CREATE_ACCOUNT1',							'Visitors are not allowed to create a Member Account.<br /><br />');
define('_CREATE_ACCOUNT2',							'Please contact the website administrator for more information.');
define('_CREATE_ACCOUNT_USER_DATA',					'Account Info.');
define('_CREATE_ACCOUNT_LOGIN_NAME',				'Login Name (required):');
define('_CREATE_ACCOUNT_LOGIN_NAME_VALID',			'only a-z and 0-9 allowed, no spaces at start/end');
define('_CREATE_ACCOUNT_REAL_NAME',					'Real Name (required):');
define('_CREATE_ACCOUNT_EMAIL',						'Email (required):');
define('_CREATE_ACCOUNT_EMAIL2',					'(must be valid, because an activation link will be sent over there)');
define('_CREATE_ACCOUNT_URL',						'URL:');
define('_CREATE_ACCOUNT_SUBMIT',					'Create Account');

define('_BMLET_BACKTODRAFTS',		'Move back to drafts');
define('_BMLET_CANCEL',				'Cancel');

define('_LIST_ITEM_NOCONTENT',						'No Comment');
define('_LIST_ITEM_COMMENTS',						'%d Comments');

define('_EDITC_URL',				'Web site');
define('_EDITC_EMAIL',				'E-mail');

define('_MANAGER_PLUGINFILE_NOTFOUND',				"Plugin %s was not loaded (File not found)");
/* changed */
// plugin dependency 
define('_ERROR_INSREQPLUGIN',		'Plugin installation failed, requires %s');
define('_ERROR_DELREQPLUGIN',		'Plugin deletion failed, required by %s');

//define('_ADD_ADDLATER',								'Add Later');
define('_ADD_ADDLATER',								'Add the dates specified');

define('_LOGIN_NAME',				'Name:');
define('_LOGIN_PASSWORD',			'Password:');

// changed from _BOOKMARLET_BMARKLFOLLOW
define('_BOOKMARKLET_BMARKFOLLOW',					' (Works with nearly all browsers)');
// END changed/added after 3.33 END

// START merge UTF-8 and EUC-JP

// Create New blog
define('_ADMIN_NOTABILIA',							'Some information');
define('_ADMIN_PLEASE_READ',						"Before you start, here's some <strong>important information</strong>");
define('_ADMIN_HOW_TO_ACCESS',						"After you've created a new weblog, you'll need to perform some actions to make your blog accessible. There are two possibilities:");
define('_ADMIN_SIMPLE_WAY',							"<strong>Simple:</strong> Create a copy of <code>index.php</code> and modify it to display your new weblog. Further instructions on how to do this will be provided after you've submitted this first form.");
define('_ADMIN_ADVANCED_WAY',						"<strong>Advanced:</strong> Insert the blog content into your current skins using skinvars like <code>&lt;%otherblog()&gt;</code>. This way, you can place multiple blogs on the same page.");
define('_ADMIN_HOW_TO_CREATE',						'Create Weblog');


define('_BOOKMARKLET_NEW_CATEGORY',					'Item was added, and a new category was created. ');
define('_BOOKMARKLET_NEW_CATEGORY_EDIT',			'Click here to edit the name and description of the category.');
define('_BOOKMARKLET_NEW_WINDOW',					'Opens in new window');
define('_BOOKMARKLET_SEND_PING',					'Item was added successfully. Now pinging weblogs.com. Please hold on... (can take a while)'); // NOTE: This string is no longer in used

// END merge UTF-8 and EUC-JP

// <add by shizuki>
// OVERVIEW screen
define('_OVERVIEW_SHOWALL',							'Show all blogs');	// <add by shizuki />

// Edit skins
define('_SKINEDIT_ALLOWEDBLOGS',						'Short blog names:');			// <add by shizuki>
define('_SKINEDIT_ALLOWEDTEMPLATESS',					'Template names:');		// <add by shizuki>

// delete member
define('_WARNINGTXT_NOTDELMEDIAFILES',				'Please note that media files will <b>NOT</b> be deleted. (At least not in this Nucleus version)');	// <add by shizuki />

// send Weblogupdate.ping
define('_UPDATEDPING_MESSAGE',						'<h2>Site Updated, Now pinging various weblog listing services...</h2><p>This can take a while...</p><p>If you aren\'t automatically passed through, '); // NOTE: This string is no longer in used
define('_UPDATEDPING_GOPINGPAGE',					'try again'); // NOTE: This string is no longer in used
define('_UPDATEDPING_PINGING',						'Pinging services, please wait...'); // NOTE: This string is no longer in used
define('_UPDATEDPING_VIEWITEM',						'View list of recent items for '); // NOTE: This string is no longer in used
define('_UPDATEDPING_VISITOWNSITE',					'Visit your own site'); // NOTE: This string is no longer in used

// General category
define('_EBLOGDEFAULTCATEGORY_NAME',				'General');
define('_EBLOGDEFAULTCATEGORY_DESC',				'Items that do not fit in other categories');

// First ITEM
define('_EBLOG_FIRSTITEM_TITLE',					'First Item');
define('_EBLOG_FIRSTITEM_BODY',						'This is the first item in your weblog. Feel free to delete it.');

// New weblog was created
define('_BLOGCREATED_TITLE',						'New weblog created');
define('_BLOGCREATED_ADDEDTXT',						"Your new weblog (%s) has been created. To continue, choose the way you'll want to make it viewable:");
define('_BLOGCREATED_SIMPLEWAY',					"Easiest: A copy of <code>%s.php</code>");
define('_BLOGCREATED_ADVANCEDWAY',					"Advanced: Call the weblog from existing skins");
define('_BLOGCREATED_SIMPLEDESC1',					"Method 1: Create an extra <code>%s.php</code> file");
define('_BLOGCREATED_SIMPLEDESC2',					"Create a file called <code>%s.php</code>, and copy-paste the following code into it:");
define('_BLOGCREATED_SIMPLEDESC3',					"Upload the file next to your existing <code>index.php</code> file, and you should be all set.");
define('_BLOGCREATED_SIMPLEDESC4',					"To finish the weblog creation process, please fill out the final URL for your weblog (the proposed value is a <em>guess</em>, don't take it for granted):");
define('_BLOGCREATED_ADVANCEDWAY2',					"Method 2: Call the weblog from existing skins");
define('_BLOGCREATED_ADVANCEDWAY3',					"To finish the weblog creation process, simply please fill out the final URL for your weblog: (might be the same as another already existing weblog)");

// Donate!
define('_ADMINPAGEFOOT_OFFICIALURL',				'http://nucleuscms.org/');
define('_ADMINPAGEFOOT_DONATEURL',					'http://nucleuscms.org/donate.php');
define('_ADMINPAGEFOOT_DONATE',						'Donate!');
define('_ADMINPAGEFOOT_COPYRIGHT',					'The Nucleus Group');

// Quick menu
define('_QMENU_MANAGE_SYSTEM',						'System info');

// Bookmarklet
define('_BOOKMARKLET_TITLE',						'Bookmarklet<!-- and Right Click Menu -->');
define('_BOOKMARKLET_DESC1',						'Bookmarklets allow adding items to your weblog with just one single click. ');
define('_BOOKMARKLET_DESC2',						'After installing these bookmarklets, you\'ll be able to click the \'add to weblog\' button on your browser toolbar, ');
define('_BOOKMARKLET_DESC3',						'and a Nucleus add-item window will popup, ');
define('_BOOKMARKLET_DESC4',						'containing the link and title of the page you were visiting, ');
define('_BOOKMARKLET_DESC5',						'plus any text you might have selected.');
define('_BOOKMARKLET_BOOKARKLET',					'bookmarklet');
define('_BOOKMARKLET_ANCHOR',						'Add to %s');
define('_BOOKMARKLET_BMARKTEXT',					'You can drag the following link to your favorites, or your browsers toolbar: ');
define('_BOOKMARKLET_BMARKTEST',					'(if you want to test the bookmarklet first, click the link)');

define('_BOOKMARKLET_ERROR_SOMETHINGWRONG',			'Something went wrong');
define('_BOOKMARKLET_ERROR_COULDNTNEWCAT',			'Could not create new category');

// BAN
define('_BAN_EXAMPLE_TITLE',						'An example');
define('_BAN_EXAMPLE_TEXT',							': "134.58.253.193" will only block one computer, while "134.58.253" will block 256 IP addresses, including the one from the first example.');
define('_BAN_IP_CUSTOM',							'Custom: ');
define('_BAN_BANBLOGNAME',							'Only blog %s');

// Plugin Options
define('_PLUGIN_OPTIONS_TITLE',							'Options for %s');

// Plugin file loda error
define('_PLUGINFILE_COULDNT_BELOADED',				'Error: plugin file <strong>%s.php</strong> could not be loaded, or it has been set inactive because it does not support some features (check the <a href="?action=actionlog">actionlog</a> for more info)');

//ITEM add/edit template (for japanese only)
define('_ITEM_ADDEDITTEMPLATE_FORMAT',				'Format :');
define('_ITEM_ADDEDITTEMPLATE_YEAR',				'Year');
define('_ITEM_ADDEDITTEMPLATE_MONTH',				'Month');
define('_ITEM_ADDEDITTEMPLATE_DAY',					'Day');
define('_ITEM_ADDEDITTEMPLATE_HOUR',				'Hour');
define('_ITEM_ADDEDITTEMPLATE_MINUTE',				'Minute');

// Errors
define('_ERRORS_INSTALLSQL',						'install.sql should be deleted');
define('_ERRORS_INSTALLDIR',						'install directory should be deleted');  // <add by shizuki />
define('_ERRORS_INSTALLPHP',						'install.php should be deleted');
define('_ERRORS_UPGRADESDIR',						'nucleus/upgrades directory should be deleted');
define('_ERRORS_CONVERTDIR',						'nucleus/convert directory should be deleted');
define('_ERRORS_CONFIGPHP',							'config.php should be non-writable (chmod to 444)');
define('_ERRORS_STARTUPERROR1',						'<p>One or more of the Nucleus installation files are still present on the webserver, or are writable.</p><p>You should remove these files or change their permissions to ensure security. Here are the files that were found by Nucleus</p> <ul><li>');
define('_ERRORS_STARTUPERROR2',						'</li></ul><p>If you don\'t want to see this error message again, without solving the problem, set <code>$CONF[\'alertOnSecurityRisk\']</code> in <code>globalfunctions.php</code> to <code>0</code>, or do this at the end of <code>config.php</code>.</p>');
define('_ERRORS_STARTUPERROR3',						'Security Risk');

// PluginAdmin tickets by javascript
define('_PLUGINADMIN_TICKETS_JAVASCRIPT',			'<p><b>Error occured during automatic addition of tickets.</b></p>');

// Global settings disablesite URL
define('_SETTINGS_DISABLESITEURL',					'Redirect URL:');

// Skin import/export
define('_SKINIE_SEELEMENT_UNEXPECTEDTAG',			'UNEXPECTED TAG');
define('_SKINIE_ERROR_FAILEDOPEN_FILEURL',			'Failed to open file/URL');
define('_SKINIE_NAME_CLASHES_DETECTED',				'Name clashes detected, re-run with allowOverwrite = 1 to force overwrite');

// ACTIONS.php parse_commentform
define('_ACTIONURL_NOTLONGER_PARAMATER',			'actionurl is not longer a parameter on commentform skinvars. Moved to be a global setting instead.');

// ADMIN.php addToTemplate 'Query error: '
define('_ADMIN_SQLDIE_QUERYERROR',					'Query error: ');

// backyp.php Backup WARNING
define('_BACKUP_BACKUPFILE_TITLE',					'This is a backup file generated by Nucleus');
define('_BACKUP_BACKUPFILE_BACKUPDATE',				'backup-date:');
define('_BACKUP_BACKUPFILE_NUCLEUSVERSION',			'Nucleus CMS version:');
define('_BACKUP_BACKUPFILE_DATABASE_NAME',			'Nucleus CMS Database name:');
define('_BACKUP_BACKUPFILE_TABLE_NAME',				'TABLE:');
define('_BACKUP_BACKUPFILE_TABLEDATAFOR',			'Table Data for %s');
define('_BACKUP_WARNING_NUCLEUSVERSION',			'WARNING: Only try to restore on servers running the exact same version of Nucleus');
define('_BACKUP_RESTOR_NOFILEUPLOADED',				'No file uploaded');
define('_BACKUP_RESTOR_UPLOAD_ERROR',				'File Upload Error');
define('_BACKUP_RESTOR_UPLOAD_NOCORRECTTYPE',		'The uploaded file is not of the correct type');
define('_BACKUP_RESTOR_UPLOAD_NOZLIB',				'Cannot decompress gzipped backup (zlib package not installed)');
define('_BACKUP_RESTOR_SQL_ERROR',					'SQL Error: ');

// BLOG.php addTeamMember
define('_TEAM_ADD_NEWTEAMMEMBER',					'Added %s (ID=%d) to the team of blog "%s"');

// ADMIN.php systemoverview()
define('_ADMIN_SYSTEMOVERVIEW_HEADING',				'System Overview');
define('_ADMIN_SYSTEMOVERVIEW_PHPANDMYSQL',			'PHP and MySQL');
define('_ADMIN_SYSTEMOVERVIEW_VERSIONS',			'Versions');
define('_ADMIN_SYSTEMOVERVIEW_PHPVERSION',			'PHP version');
define('_ADMIN_SYSTEMOVERVIEW_MYSQLVERSION',		'MySQL version');
define('_ADMIN_SYSTEMOVERVIEW_SETTINGS',			'Settings');
define('_ADMIN_SYSTEMOVERVIEW_GDLIBRALY',			'GD Libraly');
define('_ADMIN_SYSTEMOVERVIEW_MODULES',				'Modules');
define('_ADMIN_SYSTEMOVERVIEW_ENABLE',				'enabled');
define('_ADMIN_SYSTEMOVERVIEW_DISABLE',				'disabled');
define('_ADMIN_SYSTEMOVERVIEW_NUCLEUSSYSTEM',		'Your Nucleus CMS System');
define('_ADMIN_SYSTEMOVERVIEW_NUCLEUSVERSION',		'Nucleus CMS version');
define('_ADMIN_SYSTEMOVERVIEW_NUCLEUSPATCHLEVEL',	'Nucleus CMS patch level');
define('_ADMIN_SYSTEMOVERVIEW_NUCLEUSSETTINGS',		'Important settings');
define('_ADMIN_SYSTEMOVERVIEW_VERSIONCHECK',		'Check for a new version');
define('_ADMIN_SYSTEMOVERVIEW_VERSIONCHECK_TXT',	'Check on nucleuscms.org if a new version is available: ');
define('_ADMIN_SYSTEMOVERVIEW_VERSIONCHECK_URL',	'http://nucleuscms.org/version.php?v=%d&amp;pl=%d');
define('_ADMIN_SYSTEMOVERVIEW_VERSIONCHECK_TITLE',	'Check for upgrade');
define('_ADMIN_SYSTEMOVERVIEW_NOT_ADMIN',			"You haven't enough rights to see the system informations.");

// ENCAPSULATE.php
define('_ENCAPSULATE_ENCAPSULATE_NOENTRY',			'No entries');

// globalfunctions.php
define('_GFUNCTIONS_LOGINPCSHARED_YES',				'on shared PC');
define('_GFUNCTIONS_LOGINPCSHARED_NO',				'on not shared PC');
define('_GFUNCTIONS_LOGINSUCCESSFUL_TXT',			'Login successful for %s (%s)');
define('_GFUNCTIONS_LOGINFAILED_TXT',				'Login failed for %s');
define('_GFUNCTIONS_LOGOUT_TXT',					'%s is logouted');
define('_GFUNCTIONS_HEADERSALREADYSENT_FILE',		' in <code>%s</code> line <code>%s</code>');
define('_GFUNCTIONS_HEADERSALREADYSENT_TITLE',		' Page headers already sent');
define('_GFUNCTIONS_HEADERSALREADYSENT_TXT',		'<p>The page headers have already been sent out%s. This could cause Nucleus not to work in the expected way.</p><p>Usually, this is caused by spaces or newlines at the end of the <code>config.php</code> file, at the end of the translation file or at the end of a plugin file. Please check this and try again.</p><p>If you don\'t want to see this error message again, without solving the problem, set <code>$CONF[\'alertOnHeadersSent\']</code> in <code>globalfunctions.php</code> to <code>0</code></p>');
define('_GFUNCTIONS_PARSEFILE_FILEMISSING',			'A file is missing');
define('_GFUNCTIONS_AN_ERROR_OCCURRED',				'Sorry. An error occurred.');
define('_GFUNCTIONS_YOU_AERNT_LOGGEDIN',			"You aren't logged in.");

// MANAGER.php
define('_MANAGER_PLUGINFILE_NOCLASS',				"Plugin %s was not loaded (Class not found in file, possible parse error)");
define('_MANAGER_PLUGINTABLEPREFIX_NOTSUPPORT',		"Plugin %s was not loaded (does not support SqlTablePrefix)");

// mysql.php
define('_NO_SUITABLE_MYSQL_LIBRARY',				"<p>No suitable mySQL library was found to run Nucleus</p>");

// PLUGIN.php
define('_ERROR_PLUGIN_NOSUCHACTION',				'No Such Action');

// PLUGINADMIN.php
define('_ERROR_INVALID_PLUGIN',						'Invalid plugin');

// showlist.php
define('_LIST_PLUGS_DEPREQ',						'Plugin(s) requires:');
define('_LIST_SKIN_PREVIEW',						"Preview for '%s' skin");
define('_LIST_SKIN_PREVIEW_VIEWLARGER',				"View larger");
define('_LIST_SKIN_README',							"More info on the '%s' skin");
define('_LIST_SKIN_README_TXT',						'Read me');

// BLOG.php createNewCategory()
define('_CREATED_NEW_CATEGORY_NAME',				'newcat');
define('_CREATED_NEW_CATEGORY_DESC',				'New category');

// ADMIN.php blog settings
define('_EBLOG_CURRENT_TEAM_MEMBER',				'Members currently on your team:');

/********************************************
 *        End New for 3.40                  *
 ********************************************/

// START changed/added after 3.3 START
define('_AUTOSAVEDRAFT',		'Auto save draft');
define('_AUTOSAVEDRAFT_LASTSAVED',	'Last saved: ');
define('_AUTOSAVEDRAFT_NOTYETSAVED',	'No saves have been made yet');
define('_AUTOSAVEDRAFT_NOW',		'Auto save now');
define('_SKIN_PARTS_SPECIAL',		'Special skin parts');
define('_ERROR_SKIN_PARTS_SPECIAL_FORMAT',		'You must enter a name that exists only out of lowercase letters and digits');
define('_ERROR_SKIN_PARTS_SPECIAL_DELETE',		'Can\'t delete this skin part');
define('_CONFIRMTXT_SKIN_PARTS_SPECIAL',		'Do you really want to delete this special skin part?');
define('_ERROR_PLUGIN_LOAD',		'Plugin could not be loaded, or does not support certain features that are required for it to run on your Nucleus installation (you might want to check the <a href="?action=actionlog">actionlog</a> for more info)');
// END changed/added after 3.3 END

// START changed/added after 3.22 START
define('_SEARCHFORM_QUERY',			'Keywords to search');
define('_ERROR_EMAIL_REQUIRED',		'Email address is required');
define('_COMMENTFORM_MAIL',			'Website:');
define('_COMMENTFORM_EMAIL',		'E-mail:');
define('_EBLOG_REQUIREDEMAIL',		'Require E-mail address with comments?');
define('_ERROR_COMMENTS_SPAM',      'Your comment was rejected because it did not pass the spam test');
// END changed/added after 3.22 END

// START changed/added after 315 START

define('_LIST_PLUG_SUBS_NEEDUPDATE','Per favore usa il pulsante \'Aggiorna lista di sottoscrizione\' per aggiornare la lista di sottoscrizione dei plugin.');
define('_LIST_PLUGS_DEP',			'I Plugin richiedono:');

// END changed/added after 3.15

// START changed/added after 3.1 START

// comments list per weblog
define('_COMMENTS_BLOG',			'Όλα τα σχόλια για το ιστολόγιο');
define('_NOCOMMENTS_BLOG',			'Δεν έχουν γινει σχόλια σε άρθρα αυτού του ιστολογίου');
define('_BLOGLIST_COMMENTS',		'Σχόλια');
define('_BLOGLIST_TT_COMMENTS',		'Μια λίστα με όλα τα σχόλια που έχουν γίνει σε άρθρα αυτού του ιστολογίου');


// for use in archivetype-skinvar
define('_ARCHIVETYPE_DAY',			'ημέρα');
define('_ARCHIVETYPE_MONTH',		'μήνας');

// tickets (prevents malicious users to trick an admin to perform actions he doesn't want)
define('_ERROR_BADTICKET',			'Μη έγκυρο ή ληγμένο εισιτήριο.');

// plugin dependency
define('_ERROR_INSREQPLUGIN',		'Η εγκατάσταση προσθέτου απέτυχε, απαιτεί ');
define('_ERROR_DELREQPLUGIN',		'Η διαγραφή προσθέτου απέτυχε, απαιτείται από');

// cookie prefix
define('_SETTINGS_COOKIEPREFIX',	'Πρόθεμα cookie');

// account activation
define('_ERROR_NOLOGON_NOACTIVATE',	'Δεν είναι δυνατή η αποστολή συνδέσμου ενεργοποίησης. Δεν σας επιτρέπεται να συνδεθείτε.');
define('_ERROR_ACTIVATE',			'Το κλειδί ενεργοποίησης δεν υπάρχει, δεν είναι έγκυρο ή έχει λήξει.');
define('_ACTIONLOG_ACTIVATIONLINK', 'Ο σύνδεσμος ενεργοποίησης έχει σταλεί');
define('_MSG_ACTIVATION_SENT',		'Ένας σύνδεσμος ενεργοποίησης έχει σταλεί με e-mail.');

// activation link emails
define('_ACTIVATE_REGISTER_MAIL',	"Γεια σας <%memberName%>,\n\nΠρέπει να ενεργοποιήσετε τον λογαριασμό σας στο <%siteName%> (<%siteUrl%>).\nΜπορείτε να το κάνετε πηγαίνοντας στον παρακάτω σύνδεσμο: \n\n\t<%activationUrl%>\n\nΈχετε 2 περιθώριο για να το κάνετε. Ύστερα, ο σύνδεσμος ενεργοποίησης δεν θα είναι πλέον έγκυρος.");
define('_ACTIVATE_REGISTER_MAILTITLE',	"Ενεργοποιήστε τον λογαριασμό σας '<%memberName%>'");
define('_ACTIVATE_REGISTER_TITLE',	'Καλώς όρισες <%memberName%>');
define('_ACTIVATE_REGISTER_TEXT',	'Έχετε σχεδόν τελειώσει. Παρακαλώ επιλέξτε έναν κωδικό πρόσβασης για τον παρακάτω λογαριασμό σας.');
define('_ACTIVATE_FORGOT_MAIL',		"Hi <%memberName%>,\n\nΧρησιμοποιώντας τον παρακάτω σύνδεσμο, μπορείτε να επιλέξτε έναν νέο κωδικό πρόσβασης για τον λογαριασμό σας στο <%siteName%> (<%siteUrl%>) επιλέγοντας έναν νέο κωδικό πρόσβασης .\n\n\t<%activationUrl%>\n\nΈχετε 2 περιθώριο για να το κάνετε. Ύστερα, ο σύνδεσμος ενεργοποίησης δεν θα είναι πλέον έγκυρος.");
define('_ACTIVATE_FORGOT_MAILTITLE',"Ενεργοποιήστε ξανά στον λογαριασμό σας '<%memberName%>'");
define('_ACTIVATE_FORGOT_TITLE',	'Καλώς όρισες <%memberName%>');
define('_ACTIVATE_FORGOT_TEXT',		'Μπορείτε να επιλέξτε έναν νέο κωδικό πρόσβασης για τον λογαριασμό σας παρακάτω:');
define('_ACTIVATE_CHANGE_MAIL',		"Hi <%memberName%>,\n\nΚαθώς η διεύθυνσή σας e-mail έχει αλλάξει, θα χρειαστε να ενεργοποιήσετε ξανά το λογαριασμό σας στο <%siteName%> (<%siteUrl%>).\nΜπορείτε να το κάνετε πηγαίνοντας στον παρακάτω σύνδεσμο: \n\n\t<%activationUrl%>\n\nΈχετε 2 περιθώριο για να το κάνετε. Ύστερα, ο σύνδεσμος ενεργοποίησης δεν θα είναι πλέον έγκυρος.");
define('_ACTIVATE_CHANGE_MAILTITLE',"Ενεργοποιήστε ξανά στον λογαριασμό σας '<%memberName%>'");
define('_ACTIVATE_CHANGE_TITLE',	'Καλώς όρισες <%memberName%>');
define('_ACTIVATE_CHANGE_TEXT',		'Η διεύθυνσή σας επαληθεύτηκε. Ευχαριστούμε!');
define('_ACTIVATE_SUCCESS_TITLE',	'Η ενεργοποίηση πέτυχε');
define('_ACTIVATE_SUCCESS_TEXT',	'Ο λογαριασμός σας ενεργοποιήθηκε με επιτυχία.');
define('_MEMBERS_SETPWD',			'Ορισμός κωδικού πρόσβασης');
define('_MEMBERS_SETPWD_BTN',		'Ορισμός κωδικού πρόσβασης');
define('_QMENU_ACTIVATE',			'Ενεργοποίηση λογαριασμού');
define('_QMENU_ACTIVATE_TEXT',		'<p>Αφού ενεργοποιήσετε τον λογαριασμό σας, μπορείτε να αρχίσετε να τον χρησιμοποιείτε αφού <a href="index.php?action=showlogin">συνδεθείτε</a>.</p>');

define('_PLUGS_BTN_UPDATE',			'Ενημέρωση λίστας συνδρομής');

// global settings
define('_SETTINGS_JSTOOLBAR',		'Γραμμή εργαλείων σε στυλ Javascript');
define('_SETTINGS_JSTOOLBAR_FULL',	'Πλήρης γραμμή εργαλείων (IE)');
define('_SETTINGS_JSTOOLBAR_SIMPLE','Απλή γραμμή εργαλείων (Όχι IE)');
define('_SETTINGS_JSTOOLBAR_NONE',	'Απενεργοποίηση γραμμής εργαλείων');
define('_SETTINGS_URLMODE_HELP',	'(Info: <a href="documentation/tips.html#searchengines-fancyurls">Πώς να ενεργοποιήσετε τα προχωρημένα URL</a>)');

// extra plugin settings part when editing categories/members/blogs/...
define('_PLUGINS_EXTRA',			'Επιπρόσθετες ρυθμίσεις προσθέτων');

// itemlist info column keys
define('_LIST_ITEM_BLOG',			'ιστολόγιο:');
define('_LIST_ITEM_CAT',			'κατ:');
define('_LIST_ITEM_AUTHOR',			'συντάκτης:');
define('_LIST_ITEM_DATE',			'ημερομηνία:');
define('_LIST_ITEM_TIME',			'ώρα:');

// indication of registered members in comments list
define('_LIST_COMMENTS_MEMBER', 	'(μέλος)');

// batch operations
define('_BATCH_WITH_SEL',			'Με τα επιλεγμένα:');
define('_BATCH_EXEC',				'Εκτέλεση');

// quickmenu
define('_QMENU_HOME',				'Αρχική');
define('_QMENU_ADD',				'Προσθήκη άρθρου');
define('_QMENU_ADD_SELECT',			'-- επιλέξτε --');
define('_QMENU_USER_SETTINGS',		'Ρυθμίσεις');
define('_QMENU_USER_ITEMS',			'Άρθρα');
define('_QMENU_USER_COMMENTS',		'Σχόλια');
define('_QMENU_MANAGE',				'Διαχείριση');
define('_QMENU_MANAGE_LOG',			'Ημερολόγιο καταγραφής ενεργειών');
define('_QMENU_MANAGE_SETTINGS',	'Γενικές ρυθμίσεις');
define('_QMENU_MANAGE_MEMBERS',		'Μέλη');
define('_QMENU_MANAGE_NEWBLOG',		'Νέο ιστολόγιο');
define('_QMENU_MANAGE_BACKUPS',		'Αντίγραφα ασφαλείας');
define('_QMENU_MANAGE_PLUGINS',		'Πρόσθετα');
define('_QMENU_LAYOUT',				'Διάταξη');
define('_QMENU_LAYOUT_SKINS',		'Εμφανίσεις');
define('_QMENU_LAYOUT_TEMPL',		'Πρότυπα');
define('_QMENU_LAYOUT_IEXPORT',		'Εισαγωγή/Εξαγωγή');
define('_QMENU_PLUGINS',			'Πρόσθετα');

// quickmenu on logon screen
define('_QMENU_INTRO',				'Εισαγωγή');
define('_QMENU_INTRO_TEXT',			'<p>Αυτή είναι η σελίδα σύνδεσης στο Nucleus CMS, το σύστημα διαχείρισης περιεχομένου που χρησιμοποιείτε για τη λειτουργία αυτού του δικτυακού τόπου.</p><p>Εάν έχετε λογαριασμό, μπορείτε να συνδεθείτε και να αρχίσετε να δημοσιεύεται νέα άρθρα.</p>');

// helppages for plugins
define('_ERROR_PLUGNOHELPFILE',		'Δεν είναι δυνατή η εύρεση του αρχείου βοηθείας για αυτό το πρόσθετο');
define('_PLUGS_HELP_TITLE',			'Σελίδα βοήθειας για το πρόσθετο');
define('_LIST_PLUGS_HELP', 			'βοήθεια');


// END changed/started after 3.1



// general settings (security)
define('_SETTINGS_EXTAUTH',			'Ενεργοποίηση εξωτερικής πιστοποίησης ταυτότητας');
define('_WARNING_EXTAUTH',			'Προειδοποίηση: Ενεργοποιήστε το μόνο αν το χρειάζεστε.');

// member profile
define('_MEMBERS_BYPASS',			'Χρήση εξωτερικής πιστοποίησης ταυτότητας');

// 'always include in search' blog setting (yes/no) [in v2.5beta, the 'always' part wasn't clear]
define('_EBLOG_SEARCH',				'<em>Πάντα</em> να συμπεριλαμβάνεται στην αναζήτηση');

// END changed/added after v2.5beta

// START introduced after v2.0 START

// media library
define('_MEDIA_VIEW',				'Προβολή');
define('_MEDIA_VIEW_TT',			'Προβολή αρχείου (άνοιγμα σε νέο παράθυρο)');
define('_MEDIA_FILTER_APPLY',		'Εφαρμογή φίλτρου');
define('_MEDIA_FILTER_LABEL',		'Φίλτρο: ');
define('_MEDIA_UPLOAD_TO',			'Αποστολή στο...');
define('_MEDIA_UPLOAD_NEW',		'Αποστολή νέου αρχείου...');
define('_MEDIA_COLLECTION_SELECT',	'Επιλογή');
define('_MEDIA_COLLECTION_TT',		'Εναλλαγή σε αυτή την κατηγορία');
define('_MEDIA_COLLECTION_LABEL',	'Τρέχουσα κατηγορία: ');

// tooltips on toolbar
define('_ADD_ALIGNLEFT_TT',			'Αριστερή στοίχιση');
define('_ADD_ALIGNRIGHT_TT',		'Δεξιά στοίχιση');
define('_ADD_ALIGNCENTER_TT',		'Κεντρική στοίχιση');


// generic upload failure
define('_ERROR_UPLOADFAILED',		'Η αποστολή απέτυχε');

// END introduced after v2.0 END

// START introduced after v1.5 START

// posting to the past/edit timestamps
define('_EBLOG_ALLOWPASTPOSTING',	'Επιτρέπεται η δημοσίευση σε παρελθούσα ημερομηνία');
define('_ADD_CHANGEDATE',			'Ενημέρωση ώρας');
define('_BMLET_CHANGEDATE',		'Ενημέρωση ώρας');

// skin import/export
define('_OVERVIEW_SKINIMPORT',		'Εισάγωγη/Εξαγωγή εμφάνισης...');

// skin settings
define('_PARSER_INCMODE_NORMAL',	'Κανονική');
define('_PARSER_INCMODE_SKINDIR',	'Χρήση φακέλου εμφανίσεων');
define('_SKIN_INCLUDE_MODE',		'Λειτουργία συμπερίληψης');
define('_SKIN_INCLUDE_PREFIX',		'Συμπερίληψη προθέματος');

// global settings
define('_SETTINGS_BASESKIN',		'Βασική εμφάνιση');
define('_SETTINGS_SKINSURL',		'URL εμφανίσεων');
define('_SETTINGS_ACTIONSURL',		'Πλήρες URL για το action.php');

// category moves (batch)
define('_ERROR_MOVEDEFCATEGORY',	'Δεν είναι δυνατή η μεταφορά της προεπιλεγμένης κατηγορίας');
define('_ERROR_MOVETOSELF',		'Δεν είναι δυνατή η μεταφορά της κατηγορίας (το ιστολόγιο προορισμού ειναι το ίδιο με το ιστολόγιο προέλευσης)');
define('_MOVECAT_TITLE',			'Επιλέξτε ιστολόγιο στο οποίο να μετακινηθεί η κατηγορία');
define('_MOVECAT_BTN',				'Μετακίνηση κατηγορίας');

// URLMode setting
define('_SETTINGS_URLMODE',		'Λειτουργία URL');
define('_SETTINGS_URLMODE_NORMAL',	'Κανονική');
define('_SETTINGS_URLMODE_PATHINFO','Προχωρημένη');

// Batch operations
define('_BATCH_NOSELECTION',		'Δεν εχει επιλεγεί τίποτα για να πραγματοποιηθούν ενέργειας σε αυτό');
define('_BATCH_ITEMS',				'Μαζική λειτουργία στα άρθρα');
define('_BATCH_CATEGORIES',		'Μαζική λειτουργία σε κατηγορίες');
define('_BATCH_MEMBERS',			'Μαζική λειτουργία σε μέλη');
define('_BATCH_TEAM',				'Μαζική λειτουργία σε ομάδες μελών');
define('_BATCH_COMMENTS',			'Μαζική λειτουργία σε σχόλια');
define('_BATCH_UNKNOWN',			'Άγνωστη μαζική λειτουργία: ');
define('_BATCH_EXECUTING',			'Εκτέλεση');
define('_BATCH_ONCATEGORY',		'στην κατηγορία');
define('_BATCH_ONITEM',			'στο άρθρο');
define('_BATCH_ONCOMMENT',		'στο σχόλιο');
define('_BATCH_ONMEMBER',			'στο μέλος');
define('_BATCH_ONTEAM',			'στην ομάδα μελών');
define('_BATCH_SUCCESS',			'Επιτυχία!');
define('_BATCH_DONE',				'Ολοκληρώθηκε!');
define('_BATCH_DELETE_CONFIRM',	'Επιβεβαίωση μαζικής διαγραφής');
define('_BATCH_DELETE_CONFIRM_BTN','Επιβεβαίωση μαζικής διαγραφής');
define('_BATCH_SELECTALL',			'επιλογή όλων');
define('_BATCH_DESELECTALL',		'αποεπιλογή όλων');

// batch operations: options in dropdowns
define('_BATCH_ITEM_DELETE',		'Διαγραφή');
define('_BATCH_ITEM_MOVE',			'Μετακίνηση');
define('_BATCH_MEMBER_DELETE',		'Διαγραφή');
define('_BATCH_MEMBER_SET_ADM',	'Απόδοση δικαιωμάτων διαχειριστή');
define('_BATCH_MEMBER_UNSET_ADM',	'Στέρηση δικαιωμάτων διαχειριστή');
define('_BATCH_TEAM_DELETE',		'Διαγραφή από την ομάδα');
define('_BATCH_TEAM_SET_ADM',		'Απόδοση δικαιωμάτων διαχειριστή');
define('_BATCH_TEAM_UNSET_ADM',	'Στέρηση δικαιωμάτων διαχειριστή');
define('_BATCH_CAT_DELETE',		'Διαγραφή');
define('_BATCH_CAT_MOVE',			'Μετακίνηση σε άλλο ιστολόγιο');
define('_BATCH_COMMENT_DELETE',	'Διαγραφή');

// itemlist: Add new item...
define('_ITEMLIST_ADDNEW',			'Προσθήκη νέου άρθρου...');
define('_ADD_PLUGIN_EXTRAS',		'Επιπλέον ρυθμίσεις Προσθέτων');

// errors
define('_ERROR_CATCREATEFAIL',		'Δεν ήταν δυνατή η δημιουργία νέας κατηγορίας');
define('_ERROR_NUCLEUSVERSIONREQ',	'Αυτό το πρόσθετο απαιτεί μία νεότερη έκδοση του Nucleus: ');

// backlinks
define('_BACK_TO_BLOGSETTINGS',	'Επιστροφή στις ρυθμίσεις του ιστολογίου');

// skin import export
define('_SKINIE_TITLE_IMPORT',		'Εισαγωγή');
define('_SKINIE_TITLE_EXPORT',		'Εξαγωγή');
define('_SKINIE_BTN_IMPORT',		'Εισαγωγή');
define('_SKINIE_BTN_EXPORT',		'Εξαγωγή επιλεγμένων εμφανίσεων/προτύπων');
define('_SKINIE_LOCAL',				'Εισαγωγή από τοπικό αρχείο:');
define('_SKINIE_NOCANDIDATES',		'Δεν βρέθηκαν υποψήφιοι για εισαγωγή στο φάκελο των εμφανίσεων');
define('_SKINIE_FROMURL',			'Εισαγωγή από το URL:');
define('_SKINIE_EXPORT_INTRO',		'Επιλέξτε παρακάτω τις εμφανίσεις και τα πρότυπα που θέλετε να εξάγετε');
define('_SKINIE_EXPORT_SKINS',		'Εμφανίσεις');
define('_SKINIE_EXPORT_TEMPLATES',	'Πρότυπα');
define('_SKINIE_EXPORT_EXTRA',		'Επιπλέον πληροφορίες');
define('_SKINIE_CONFIRM_OVERWRITE','Επανεγγραφή των ήδη υπαρχόντων εμφανίσεων (βλ. nameclashes)');
define('_SKINIE_CONFIRM_IMPORT',	'Ναι, επιθυμώ να το εισάγω');
define('_SKINIE_CONFIRM_TITLE',		'Πρόκειται να εισαχθούν πρότυπα εμφανίσεων');
define('_SKINIE_INFO_SKINS',		'Εμφανίσεις στο αρχείο:');
define('_SKINIE_INFO_TEMPLATES',	'Πρότυπα στο αρχείο:');
define('_SKINIE_INFO_GENERAL',		'Πληροφορίες:');
define('_SKINIE_INFO_SKINCLASH',	'Το όνομα της εμφάνισης είναι ίδιο με:');
define('_SKINIE_INFO_TEMPLCLASH',	'Το όνομα του προτύπου είναι ίδιο με:');
define('_SKINIE_INFO_IMPORTEDSKINS','Εισαγώμενες εμφανίσεις:');
define('_SKINIE_INFO_IMPORTEDTEMPLS','Εισαγωμενα πρότυπα:');
define('_SKINIE_DONE',				'Η εισαγωγή ολοκληρώθηκε');

define('_AND',						'και');
define('_OR',						'ή');

// empty fields on template edit
define('_EDITTEMPLATE_EMPTY',		'κενό πεδίο (κάντε κλικ για επεξεργασία)');

// skin overview list
define('_LIST_SKINS_INCMODE',		'Λειτουργία συμπερίληψης:');
define('_LIST_SKINS_INCPREFIX',		'Πρόθεμα συμπερίληψης:');
define('_LIST_SKINS_DEFINED',		'Καθορισμένα μέρη:');

// backup
define('_BACKUPS_TITLE',			'Αντίγραφο ασφάλειας/Επαναφορά');
define('_BACKUP_TITLE',				'Αντίγραφο ασφάλειας');
define('_BACKUP_INTRO',			'Πατήστε το παρακάτω κουμπί για να δημιουργήσετε ένα αντίγραφο ασφαλείας της βάσης δεδομένων σας. Θα σας προταθεί να αποθηκεύσετε ένα αρχείο αντιγράφου ασφαλείας. Αποθηκεύστε το σε ένα ασφαλές μέρος.');
define('_BACKUP_ZIP_YES',			'Προσπάθεια για συμπίεση');
define('_BACKUP_ZIP_NO',			'Χωρίς συμπίεση');
define('_BACKUP_BTN',				'Δημιουργία αντιγράφου ασφαλείας');
define('_BACKUP_NOTE',				'<b>Σημείωση:</b> Μόνο τα περιεχόμενα της βάσης δεδομένων αποθηκεύονται στο αντίγραφο ασφαλείας. Τα αρχεία και οι ρυθμίσεις πολυμέσων στο config.php συνεπώς <b>ΔΕΝ</b> συμπεριλαμβάνονται στο αντίγραφο ασφαλείας.');
define('_RESTORE_TITLE',			'Επαναφορά');
define('_RESTORE_NOTE',			'<b>ΠΡΟΕΙΔΟΠΟΙΗΣΗ:</b> Κάνοντας επαναφορά από ένα αντίγραφο ασφαλείας θα <b>ΔΙΑΓΡΑΨΕΤΕ</b> όλα τα τρέχοντα δεδομένα του Nucleus στη βάση δεδομένων! Κάντετο μόνο αν είστε πραγματικά σίγουροι!	<br />	<b>Σημείωση:</b> Βεβαιωθείτε ότι η έκδοση του Nucleus στην οποία δημιουργήσατε το αντίγραφο ασφαλείας είναι η ίδια με την έκδοση που εκτελείτε τώρα! Δεν θα λειτουργήσει σε αντίθετη περίπτωση');
define('_RESTORE_INTRO',			'Επιλέξτε το αρχείο αντιγράφου ασφαλείας (θα γίνει αποστολή στον διακομιστή) και κάντε κλικ στο Επαναφορά για έναρξη.');
define('_RESTORE_IMSURE',			'Ναι, είμαι σίγουρος ότι επιθυμώ να το κάνω!');
define('_RESTORE_BTN',				'Επαναφορά από αρχείο');
define('_RESTORE_WARNING',			'(βεβαιωθείτε ότι επαναφέρετε το σωστό αντίγραφο ασφάλειας, ίσως να κάνετε και ένα νέο αντίγραφο ασφάλειας πριν να ξεκινήσετε)');
define('_ERROR_BACKUP_NOTSURE',	'Θα χρειαστεί να τσεκάρετε το \'Έίμαι σίγουρος\' testbox');
define('_RESTORE_COMPLETE',		'Η επαναφορά ολοκληρώθηκε');

// new item notification
define('_NOTIFY_NI_MSG',			'Ένα νέο άρθρο έχει δημοσιευθεί:');
define('_NOTIFY_NI_TITLE',			'Νέο άρθρο!');
define('_NOTIFY_KV_MSG',			'Ψήφος karma στο άρθρο:');
define('_NOTIFY_KV_TITLE',			'Nucleus karma:');
define('_NOTIFY_NC_MSG',			'Σχόλιο στο άρθρο:');
define('_NOTIFY_NC_TITLE',			'Σχόλιο Nucleus:');
define('_NOTIFY_USERID',			'ID χρήστη:');
define('_NOTIFY_USER',				'Χρήστης:');
define('_NOTIFY_COMMENT',			'Σχόλιο:');
define('_NOTIFY_VOTE',				'Ψήφος:');
define('_NOTIFY_HOST',				'Διακομιστής:');
define('_NOTIFY_IP',				'IP:');
define('_NOTIFY_MEMBER',			'Μέλος:');
define('_NOTIFY_TITLE',				'Τίτλος:');
define('_NOTIFY_CONTENTS',			'Περιεχόμενα:');

// member mail message
define('_MMAIL_MSG',				'Σας έχει σταλεί ένα μήνυμα από');
define('_MMAIL_FROMANON',			'έναν ανώνυμο επισκέπτη');
define('_MMAIL_FROMNUC',			'Δημοσιεύθηκε από ένα ιστολόγιο Nucleus στο');
define('_MMAIL_TITLE',				'Ένα μήνυμα από');
define('_MMAIL_MAIL',				'Μήνυμα:');

// END introduced after v1.5 END


// START introduced after v1.1 START

// bookmarklet buttons
define('_BMLET_EDIT',				'Επεξεργασία');
define('_BMLET_ADD',				'Προσθήκη');
define('_BMLET_DELETE',				'Διαγραφή');
define('_BMLET_BODY',				'Σώμα');
define('_BMLET_MORE',				'Περισσότερα');
define('_BMLET_OPTIONS',			'Επιλογές');
define('_BMLET_PREVIEW',			'Προεπισκόπηση');

// used in bookmarklet
define('_ITEM_UPDATED',			'Το άρθρο ενημερώθηκε');
define('_ITEM_DELETED',				'Το άρθρο διαγράφηκε');

// plugins
define('_CONFIRMTXT_PLUGIN',		'Είστε σίγουροι ότι θέλετε να διαγράψετε το πρόσθετο με το όνομα');
define('_ERROR_NOSUCHPLUGIN',		'Δεν υπάρχει τέτοιο πρόσθετο');
define('_ERROR_DUPPLUGIN',			'Λυπούμαστε, το πρόσθετο αυτό έχει ήδη εγκατασταθεί');
define('_ERROR_PLUGFILEERROR',		'Δεν υπάρχει τέτοιο πρόσθετο, ή οι άδειες έχουν ορισθεί λανθασμένα');
define('_PLUGS_NOCANDIDATES',		'Δεν βρέθηκαν πρόσθετα');

define('_PLUGS_TITLE_MANAGE',		'Διαχείριση προσθέτων');
define('_PLUGS_TITLE_INSTALLED',	'Ήδη εγκατεστημένα');
define('_PLUGS_TITLE_UPDATE',		'Ενημέρωση λίστας εγγραφών');
define('_PLUGS_TEXT_UPDATE',		'Το Nucleus διατηρεί μια προσωρινή μνήμη (cache) των γεγονότων εγγραφής των προσθέτων. Όταν αναβαθμίζετε ένα πρόσθετο αντικαθιστώντας το αρχείο του, πρέπει να εκτελείτε αυτό το αρχείο ενημέρωσης για να βεβαιωθείτε ότι γίνεται προσωρινή αποθήκευση των σωστών εγγραφών.');
define('_PLUGS_TITLE_NEW',			'Εγκατάσταση νέου προσθέτου');
define('_PLUGS_ADD_TEXT',			'Παρακάτω υπάρχει μια λίστα όλων των αρχείων στον φάκελο των προσθέτων, τα οποία πιθανώς να είναι μη εγκατεστημένα πρόσθετα. Βεβαιωθείτε ότι είστε <strong>πραγματικά σίγουροι</strong> ότι είοναι ένα πρόσθετο πριν το προσθέσετε.');
define('_PLUGS_BTN_INSTALL',		'Εγκατάσταση Προσθέτου');
define('_BACKTOOVERVIEW',			'Επιστροφή στην προεπισκόπηση');

// editlink
define('_TEMPLATE_EDITLINK',		'Επεξεργασία συνδέσμου άρθρου');

// add left / add right tooltips
define('_ADD_LEFT_TT',				'Προσθήκη αριστερού πλαισίου');
define('_ADD_RIGHT_TT',				'Προσθήκη δεξιου πλαισίου');

// add/edit item: new category (in dropdown box)
define('_ADD_NEWCAT',				'Νέα κατηγορία...');

// new settings
define('_SETTINGS_PLUGINURL',		'URL προσθέτου');
define('_SETTINGS_MAXUPLOADSIZE',	'Μέγιστο μέγεθος αρχείου για αποστολή (bytes)');
define('_SETTINGS_NONMEMBERMSGS',	'Να επιτρέπεται η απόστολή μηνυμάτων από μη μέλη');
define('_SETTINGS_PROTECTMEMNAMES','Προστασία ονομάτων μελών');

// overview screen
define('_OVERVIEW_PLUGINS',		'Διαχείριση προσθέτων...');

// actionlog
define('_ACTIONLOG_NEWMEMBER',	'Εγγραφή νέου μέλους:');

// membermail (when not logged in)
define('_MEMBERMAIL_MAIL',			'Η διεύθυνση email σας:');

// file upload
define('_ERROR_DISALLOWEDUPLOAD2','Δεν έχετε δικαιώματα διαχειριστή πάνω σε κανένα από τα ιστολόγια τα οποία έχουν το μέλος προορισμού στο teamlist. Συνεπώς, δεν σας επιτρέπετε να ανεβάσετε αρχεία στο φάκελο πολυμέσων αυτού του μέλους');

// plugin list
define('_LISTS_INFO',				'Πληροφορίες');
define('_LIST_PLUGS_AUTHOR',		'Από:');
define('_LIST_PLUGS_VER',			'Έκδοση:');
define('_LIST_PLUGS_SITE',			'Επίσκεψη δικτυακού τόπου');
define('_LIST_PLUGS_DESC',			'Περιγραφή:');
define('_LIST_PLUGS_SUBS',			'Εγγραφές στα ακόλουθα γεγονότα:');
define('_LIST_PLUGS_UP',			'μετακίνηση επάνω');
define('_LIST_PLUGS_DOWN',			'μετακίνηση κάτω');
define('_LIST_PLUGS_UNINSTALL',		'απεγκατάσταση');
define('_LIST_PLUGS_ADMIN',			'διαχείριση');
define('_LIST_PLUGS_OPTIONS',		'Επεξεργασία&nbsp;επιλογών');

// plugin option list
define('_LISTS_VALUE',				'τιμή');



// plugin options
define('_ERROR_NOPLUGOPTIONS',		'Δεν έχουν ρυθμιστεί οι επιλογές για αυτό το πρόσθετο');
define('_PLUGS_BACK',				'Επιστροφή στο προεπισκόπηση προσθέτου');
define('_PLUGS_SAVE',				'Αποθήκευση επιλογών');
define('_PLUGS_OPTIONS_UPDATED',	'Οι επιλογές του προσθέτου ενημερώθηκαν');

define('_OVERVIEW_MANAGEMENT',	'Διαχείριση');
define('_OVERVIEW_MANAGE',		'Διαχείριση Nucleus...');
define('_MANAGE_GENERAL',			'Γενική διαχείριση');
define('_MANAGE_SKINS',			'Εμφανίσεις και πρότυπα');
define('_MANAGE_EXTRA',			'Επιπλέον χαρακτηριστικά');

define('_BACKTOMANAGE',			'Επιστροφή στη διαχείριση Nucleus');


// END introduced after v1.1 END

// global stuff
define('_LOGOUT',					'Αποσύνδεση');
define('_LOGIN',					'Σύνδεση');
define('_YES',						'Ναι');
define('_NO',						'Όχι');
define('_SUBMIT',					'Υποβολή');
define('_ERROR',					'Σφάλμα');
define('_ERRORMSG',				'Προέκυψε ένα σφάλμα!');
define('_BACK',					'Επιστροφή');
define('_NOTLOGGEDIN',				'Δεν είστε συνδεμένοι');
define('_LOGGEDINAS',				'Συνδεθήκατε ως');
define('_ADMINHOME',				'Αρχική σελίδα διαχείρισης');
define('_NAME',					'Όνομα');
define('_BACKHOME',				'Επιστρογή στην αρχική σελίδα διαχείρισης');
define('_BADACTION',				'Ζητήθηκε μη υπάρχουσα δράση');
define('_MESSAGE',					'Μήνυμα');
define('_HELP_TT',					'Βοήθεια!');
define('_YOURSITE',					'Ο δικτυακός σας τόπος');


define('_POPUP_CLOSE',				'Κλείσιμο παραθύρου');

define('_LOGIN_PLEASE',				'Παρακαλώ συνδεθείτε πρώτα');

// commentform
define('_COMMENTFORM_YOUARE',		'Είστε ο/η');
define('_COMMENTFORM_SUBMIT',		'Προσθήκη σχολίου');
define('_COMMENTFORM_COMMENT',	'Το σχόλιό σας');
define('_COMMENTFORM_NAME',		'Όνομα');
define('_COMMENTFORM_MAIL',		'E-mail/HTTP');
define('_COMMENTFORM_REMEMBER',	'Θυμήσου με');

// loginform
define('_LOGINFORM_NAME',			'Όνομα χρήστη');
define('_LOGINFORM_PWD',			'Κωδικός πρόσβασης');
define('_LOGINFORM_YOUARE',		'Συνδεθήκατε ως');
define('_LOGINFORM_SHARED',		'Κοινόχρηστός υπολογιστής');

// member mailform
define('_MEMBERMAIL_SUBMIT',		'Αποστολή μηνύματος');

// search form
define('_SEARCHFORM_SUBMIT',		'Εύρεση');

// add item form
define('_ADD_ADDTO',				'Προσθήκη νέου άρθρου στο');
define('_ADD_CREATENEW',			'Δημιουργία νέα άρθρου');
define('_ADD_BODY',				'Σώμα');
define('_ADD_TITLE',				'Τίτλος');
define('_ADD_MORE',				'Εκτεταμένος (προαιρετικό)');
define('_ADD_CATEGORY',			'Κατηγορία');
define('_ADD_PREVIEW',				'Προεπισκόπηση');
define('_ADD_DISABLE_COMMENTS',	'Απενεργοποίηση σχολίων;');
define('_ADD_DRAFTNFUTURE',		'Πρόχειρα &amp; μελλοντικά άρθρα');
define('_ADD_ADDITEM',				'Προσθήκη άρθρου');
define('_ADD_ADDNOW',				'Προσθηκη τώρα');
define('_ADD_ADDLATER',			'Προσθήκη αργότερα');
define('_ADD_PLACE_ON',			'Τοποθετηση πάνω στο');
define('_ADD_ADDDRAFT',			'Προσθήκη στα πρόχειρα');
define('_ADD_NOPASTDATES',			'(Ημερομηνίες και ώρες στο παρελθόν ΔΕΝ είναι έγκυρες, η τρέχουσα όρα θα χρησιμοποιηθεί σε τέτοια περίπτωση)');
define('_ADD_BOLD_TT',				'Έντονα');
define('_ADD_ITALIC_TT',			'Πλάγια');
define('_ADD_HREF_TT',				'Δημιουργία συνδέσμου');
define('_ADD_MEDIA_TT',			'Προσθήκη πολυμέσου');
define('_ADD_PREVIEW_TT',			'Εμφάνιση/Απόκρυψη προεπισκόπησης');
define('_ADD_CUT_TT',				'Αποκοπή');
define('_ADD_COPY_TT',				'Αντιγραφή');
define('_ADD_PASTE_TT',				'Επικόλληση');


// edit item form
define('_EDIT_ITEM',				'Προσθήκη άρθρου');
define('_EDIT_SUBMIT',				'Προσθήκη άρθρου');
define('_EDIT_ORIG_AUTHOR',		'Αρχικός συντάκτης');
define('_EDIT_BACKTODRAFTS',		'Προσθήκη πίσω στα πρόχειρα');
define('_EDIT_COMMENTSNOTE',		'(Σημείωση: Η απενεργοποίηση σχολίων δεν θα αποκρύψει σχόλια που έχουν καταχωρηθεί παλαιότερα)');

// used on delete screens
define('_DELETE_CONFIRM',			'Παρακαλώ επιβεβαιώστε τη διαγραφή');
define('_DELETE_CONFIRM_BTN',		'Επιβεβαιώστε τη διαγραφή');
define('_CONFIRMTXT_ITEM',			'Πρόκειται να διαγράψετε το ακόλουθο άρθρο:');
define('_CONFIRMTXT_COMMENT',		'Πρόκειται να διαγράψετε το ακόλουθο σχόλιο:');
define('_CONFIRMTXT_TEAM1',		'Πρόκειται να διαγράψετε ');
define('_CONFIRMTXT_TEAM2',		' από τη λίστα ομάδας του ιστολογίου');
define('_CONFIRMTXT_BLOG',			'Το ιστολόγιο που προκειται να διαγράψετε είναι το: ');
define('_WARNINGTXT_BLOGDEL',		'Προειδοποίηση! Διαγράφοντας ένα ιστολόγιο θα διαγράψετε ΟΛΑ τα άρθρα του και όλα τα σχόλια. Παρακαλώ επιβεβαιώστε για να κάνετε σαφές ότι είστε ΣΙΓΟΥΡΟΙ για αυτό που κάνετε!<br />Επίσης, μη διακόψετε το Nucleus καθώς διαγράφει το ιστολόγιο.');
define('_CONFIRMTXT_MEMBER',		'Πρόκειται να διαγράψετε το ακόλουθο προφίλ μέλους: ');
define('_CONFIRMTXT_TEMPLATE',		'Πρόκειται να διαγράψετε το πρότυπο με το όνομα');
define('_CONFIRMTXT_SKIN',			'Πρόκειται να διαγράψετε την εμφάνιση με το όνομα');
define('_CONFIRMTXT_BAN',			'Πρόκειται να διαγράψετε τον αποκλεισμό για το πεδίο ip');
define('_CONFIRMTXT_CATEGORY',		'Πρόκειται να διαγράψετε την κατηγορία ');

// some status messages
define('_DELETED_ITEM',				'Το άρθρο διαγράφηκε');
define('_DELETED_MEMBER',			'Το μέλος διαγράφηκε');
define('_DELETED_COMMENT',			'Το σχόλιο διαγράφηκε');
define('_DELETED_BLOG',			'Το ιστολόγιο διαγράφηκε');
define('_DELETED_CATEGORY',		'Η κατηγορία διαγράφηκε');
define('_ITEM_MOVED',				'Το άρθρο μετακινήθηκε');
define('_ITEM_ADDED',				'Το άρθρο προστέθηκε');
define('_COMMENT_UPDATED',		'Το σχόλιο ενημερώθηκε');
define('_SKIN_UPDATED',			'Τα δεδομένα της εμφάνισης έχουν αποθηκευτεί');
define('_TEMPLATE_UPDATED',		'Τα δεδομένα του προτύπου έχουν αποθηκευτεί');

// errors
define('_ERROR_COMMENT_LONGWORD',	'Παρακαλώ μη χρησιμοποιείτε λέξεις μεγαλύτερες των 90 χαρακτήρων στα σχόλιά σας');
define('_ERROR_COMMENT_NOCOMMENT',	'Παρακαλώ εισαγάγετε ένα σχόλιο');
define('_ERROR_COMMENT_NOUSERNAME',	'Μη έγκυρο όνομα χρήστη');
define('_ERROR_COMMENT_TOOLONG',		'Τα σχόλιά σας είναι υπερβολικά μεγάλα (μεγ. 5000 χαρακτήρες)');
define('_ERROR_COMMENTS_DISABLED',		'Τα σχόλια για αυτό το ιστολόγιο είναι προς το παρόν απενεργοποιημένα.');
define('_ERROR_COMMENTS_NONPUBLIC',	'Πρέπει να είστε συνδεμένος ως μέλος για να προσθέσετε σχόλιο σε αυτό το ιστολόγιο');
define('_ERROR_COMMENTS_MEMBERNICK',	'Το όνομα που θέλετε να χρησιμοποιήσετε για να δημοσιεύσετε σχόλια χρησιμοποιείτε από ένα μέλος του δικτυακού τόπου. Επιλέξτε κάτι άλλο.');
define('_ERROR_SKIN',					'Σφάλμα στην εμφάνιση');
define('_ERROR_ITEMCLOSED',			'Το άρθρο έχει κλείσει, δεν είναι δυνατό να προσθέσετε σχόλια σε αυτό ή να ψηφίσετε για αυτό');
define('_ERROR_NOSUCHITEM',			'Δεν υπάρχει τέτοιο άρθρο');
define('_ERROR_NOSUCHBLOG',			'Δεν υπάρχει τέτοιο ιστολόγιο');
define('_ERROR_NOSUCHSKIN',			'Δεν υπάρχει τέτοια εμφάνιση');
define('_ERROR_NOSUCHMEMBER',			'Δεν υπάρχει τέτοιο μέλος');
define('_ERROR_NOTONTEAM',			'Δεν είστε στην λίστα ομάδας αυτού του ιστολογίου.');
define('_ERROR_BADDESTBLOG',			'Δεν υπάρχει το ιστολόγιο προορισμού');
define('_ERROR_NOTONDESTTEAM',		'Δεν είναι δυνατή η μετακίνηση του άρθρου, καθώς δεν είστε στη λίστα ομάδας του ιστολόγιο προορισμού');
define('_ERROR_NOEMPTYITEMS',			'Δεν είναι δυνατή η προσθήκη κενών άρθρων!');
define('_ERROR_BADMAILADDRESS',		'Μη έγκυρη διεύθυνση ηλεκτρονικού ταχυδρομείου');
define('_ERROR_BADNOTIFY',				'Μία η περισσότερες από τις δοθείσες διευθύνσεις για ειδοποίηση δεν είναι έγκυρες διευθύνσεις ηλ. ταχυδρομείου');
define('_ERROR_BADNAME',				'Μη έγκυρο όνομα (επιτρέπονται μόνο a-z και 0-9, χωρίς κενά σε αρχή/τέλος)');
define('_ERROR_NICKNAMEINUSE',			'Ένα άλλο μέλος χρησιμοποιεί ήδη αυτό το ψευδώνυμο');
define('_ERROR_PASSWORDMISMATCH',		'Οι κωδικοί πρέπει να ταιριάζουν');
define('_ERROR_PASSWORDTOOSHORT',		'Οι κωδικοί πρέπει να είναι τουλάχιστον 6 χαρακτήρων');
define('_ERROR_PASSWORDMISSING',		'Ο κωδικός πρόσβασης δεν μπορεί να είναι κενός');
define('_ERROR_REALNAMEMISSING',		'Πρέπει να εισαγάγετε ένα πραγματικό όνομα');
define('_ERROR_ATLEASTONEADMIN',		'Πρέπει να υπάρχει πάντοτε τουλάχιστον ένας super-admin που να μπορεί να συνδεθεί με την admin area.');
define('_ERROR_ATLEASTONEBLOGADMIN',	'Πραγματοποιόντας αυτή την ενέργεια θα καταστήσετε το ιστολόγιο μη διατηρήσιμο. Παρακαλώ βεβαιωθείτε ότι υπάρχει πάντοτε τουλάχιστον ένας admin.');
define('_ERROR_ALREADYONTEAM',			'Δεν είναι δυνατή η προσθήκη ενός μέλους που υπάρχει ήδη στην ομάδα');
define('_ERROR_BADSHORTBLOGNAME',		'Το σύντομο όνομα ιστολόγιο πρέπει να περιέχει μόνο a-z και 0-9, χωρίς κενά');
define('_ERROR_DUPSHORTBLOGNAME',		'Κάποιο άλλο ιστολόγιο έχει ήδη το επιλεγμένο σύντομο όνομα. Αυτά τα ονόματα πρέπει να είναι μοναδικά');
define('_ERROR_UPDATEFILE',				'Δεν δίνεται άδεια εγγραφής για το συγκεκριμένο αρχείο ενημέρωσης. Βεβαιωθείτε ότι οι άδειες των αρχείων έχουν ορισθεί σωστά (try chmodding it to 666). Επίσης σημειώστε ότι η τοποθεσία εναι σχετική με το φάκελο admin-area, οπότε ίσωσ θα θέλατε να χρησιμοποιήσετε ένα απόλυτο μονοπάτι (κάτι σαν το /your/path/to/nucleus/)');
define('_ERROR_DELDEFBLOG',			'Δεν είναι δυνατή η διαγραφή του προεπιλεγμένου ιστολογίου');
define('_ERROR_DELETEMEMBER',			'Δεν είναι δυνατή η διαγραφή αυτού του μέλους, πιθανώς επειδή είναι ο συντάκτης άρθρων ή σχολιών');
define('_ERROR_BADTEMPLATENAME',		'Μη έγκυρο όνομα για πρότυπο, χρησιμοποιήστε μόνο a-z και 0-9, χωρίς κενά');
define('_ERROR_DUPTEMPLATENAME',		'Υπάρχει ήδη κάποιο άλλο πρότυπο με αυτό το όνομα');
define('_ERROR_BADSKINNAME',			'Μη έγκυρο όνομα για εμφάνιση (επιτρέπονται μόνο a-z, 0-9, χωρίς κενά)');
define('_ERROR_DUPSKINNAME',			'Υπάρχει ήδη κάποιο άλλη εμφάνιση με αυτό το όνομα');
define('_ERROR_DEFAULTSKIN',			'Πρέπει πάντοτε να υπάρχει μια εμφάνιση με το όνομα "προεπιλεγμένο"');
define('_ERROR_SKINDEFDELETE',			'Δεν είναι δυνατή η διαγραφή της εμφάνισης καθώς είναι η προεπιλεγμένη εμφάνιση για το ακόλουθο ιστολόγιο: ');
define('_ERROR_DISALLOWED',			'Λυπούμαστε, δεν σας επιτρέπεται να πραγματοποιήσετε αυτή την ενέργεια');
define('_ERROR_DELETEBAN',				'Σφάλμα κατα την προσπάθεια διαγραφής του ban (Ο αποκλεισμός δεν υπάρχει)');
define('_ERROR_ADDBAN',				'Σφάλμα κατα την προσπάθεια προσθήκης του αποκλεισμού. Πιθανώς ο αποκλεισμός να μην ενεργοποιηθεί σωστά σε όλα τα ιστολόγια.');
define('_ERROR_BADACTION',				'Η Απαιτούμενη ενέργεια δεν υπάρχει');
define('_ERROR_MEMBERMAILDISABLED',	'Τα μηνύματα από μέλος σε μέλος είναι απενεργοποιημένα');
define('_ERROR_MEMBERCREATEDISABLED',	'Η δημιουργιά λογαριασμών μέλών είναι απενεργοποιημένη');
define('_ERROR_INCORRECTEMAIL',		'Λανθασμένη διεύθυνση ηλεκτρονικού ταχυδρομείου');
define('_ERROR_VOTEDBEFORE',			'Έχετε ήδη ψηφίσει για αυτό το άρθρο');
define('_ERROR_BANNED1',				'Δεν είναι δυνατή η πραγματοποίηση της ενέργειας (ip range ');
define('_ERROR_BANNED2',			 	'καθώς σας έχει απαγορευτεί. Το μήνυμα ήταν:');
define('_ERROR_BANNED3',				'\'');
define('_ERROR_LOGINNEEDED',			'Πρέπει να είστε συνδεδεμένοι για να πραγματοποιήσετε αυτή την ενέργεια');
define('_ERROR_CONNECT',				'Σφάλμα στη σύνδεση');
define('_ERROR_FILE_TOO_BIG',			'Το αρχείο είναι υπερβολικά μεγάλο!');
define('_ERROR_BADFILETYPE',			'Λυπούμαστε, αυτός ο τύπος αρχείου δεν επιτρέπεται');
define('_ERROR_BADREQUEST',			'Εσφαλμένη αίτηση αποστολής');
define('_ERROR_DISALLOWEDUPLOAD',		'Δεν είσαστε σε καμία λίστα ομάδας ιστολογίων. Συνεπώς, δεν σας επιτρέπεται να ανεβάσετε αρχεία');
define('_ERROR_BADPERMISSIONS',		'Τα δικαιώματα αρχείων/καταλόγων δεν έχουν οριστεί σωστά');
define('_ERROR_UPLOADMOVEP',			'Σφάλμα κατα τη μετακίνηση αρχείου που έχει αποσταλεί');
define('_ERROR_UPLOADCOPY',			'Σφάλμα κατά την αντιγραφή αρχείου');
define('_ERROR_UPLOADDUPLICATE',		'Υπάρχει ήδη κάποιο άλλο αρχείο με αυτό το όνομα. Προσπαθείστε να το μετονομάσετε πριν το ανεβάσετε.');
define('_ERROR_LOGINDISALLOWED',		'Λυπούμαστε, δεν σας επιτρέπετε να συνδεθείτε στην περιοχή διαχείρισης. Μπορείτε όμως να συνδεθείτε ως κάποιος άλλος χρήστης');
define('_ERROR_DBCONNECT',			'Δεν ήταν δυνατή η σύνδεση στον διακομιστή mySQL');
define('_ERROR_DBSELECT',				'Δεν ήταν δυνατή η επιλογή της βάσης δεδομένων nucleus.');
define('_ERROR_NOSUCHLANGUAGE',		'Δεν υπάρχει τέτοιο αρχείο γλώσσας');
define('_ERROR_NOSUCHCATEGORY',		'Δεν υπάρχει τέτοια κατηγορία');
define('_ERROR_DELETELASTCATEGORY',	'Πρέπει να υπάρχει τουλάχιστον μια κατηγορία');
define('_ERROR_DELETEDEFCATEGORY',		'Δεν είναι δυνατή η διαγραφή της προεπιλεγμένηςκατηγορίας');
define('_ERROR_BADCATEGORYNAME',		'Μη έγκυρο όνομα κατηγορίας');
define('_ERROR_DUPCATEGORYNAME',		'Υπάρχει ήδη κάποια άλλη κατηγορία με αυτό το όνομα');

// some warnings (used for mediadir setting)
define('_WARNING_NOTADIR',			'Προειδοποίηση: Η τρέχουσα τιμή δεν είναι κάποιος φάκελος!');
define('_WARNING_NOTREADABLE',		'Προειδοποίηση: Η τρέχουσα τιμή δεν είναι ένας μη αναγνώσιμος φάκελος!');
define('_WARNING_NOTWRITABLE',		'Προειδοποίηση: Η τρέχουσα τιμή δεν είναι κάποιος εγγράψιμος φάκελος!');

// media and upload
define('_MEDIA_UPLOADLINK',			'Αποστολή νέου αρχείου');
define('_MEDIA_MODIFIED',				'τροποποιημένο');
define('_MEDIA_FILENAME',				'όνομα αρχείου');
define('_MEDIA_DIMENSIONS',			'διαστάσεις');
define('_MEDIA_INLINE',					'Ενσωματωμένο');
define('_MEDIA_POPUP',					'Αναδυόμενο');
define('_UPLOAD_TITLE',					'Επιλογή αρχείου');
define('_UPLOAD_MSG',					'Επιλέξτε παρακάτω το αρχείο που θέλετε να ανεβάσετε, και πατήστε το κουμπί \'Αποστολή\'.');
define('_UPLOAD_BUTTON',				'Αποστολή');

// some status messages
define('_MSG_ACCOUNTCREATED',			'Ο λογαριασμός δημιουργήθηκε, ο κωδικός πρόσβασης θα σας σταλεί μέσω ηλεκτρονικού ταχυδρομείου');
define('_MSG_PASSWORDSENT',			'Ο κωδικός πρόσβασης έχει σταλεί μέσω ηλεκτρονικού ταχυδρομείου.');
define('_MSG_LOGINAGAIN',				'Θα χρειαστεί να ξανασυνδεθείτε, επείδη τα άρθρα σας έχουν αλλάξει');
define('_MSG_SETTINGSCHANGED',			'Οι ρυθμίσεις έχουν αλλάξει');
define('_MSG_ADMINCHANGED',			'Ο διαχειριστής έχει αλλάξει');
define('_MSG_NEWBLOG',				'Ένα νέο ιστολόγιο δημιουργήθηκε');
define('_MSG_ACTIONLOGCLEARED',		'Το ημερολόγιο ενεργειών έχει καθαρισθεί');

// actionlog in admin area
define('_ACTIONLOG_DISALLOWED',		'Μη επιτρεπόμενη ενέργεια: ');
define('_ACTIONLOG_PWDREMINDERSENT',	'Νέος κωδικός πρόσβασης έχει σταλεί για ');
define('_ACTIONLOG_TITLE',				'Ημερολόγιο ενεργειών');
define('_ACTIONLOG_CLEAR_TITLE',		'Καθαρισμός ημερολογίου ενεργειών');
define('_ACTIONLOG_CLEAR_TEXT',		'Καθαρισμός ημερολογίου ενεργειών τώρα');

// team management
define('_TEAM_TITLE',				'Διαχείριση ομάδας για ιστολόγιο');
define('_TEAM_CURRENT',			'Τρέχουσα ομάδα');
define('_TEAM_ADDNEW',			'Προσθήκη νέου μέλους στην ομάδα');
define('_TEAM_CHOOSEMEMBER',		'Επιλογή μέλους');
define('_TEAM_ADMIN',				'Δικαιώματα διαχειριστή ;');
define('_TEAM_ADD',				'Προσθήκη στην ομάδα');
define('_TEAM_ADD_BTN',			'προσθήκη στην ομάδα');

// blogsettings
define('_EBLOG_TITLE',				'Επεγεργασία ρυθμίσεων ιστολογίου');
define('_EBLOG_TEAM_TITLE',			'Επεξεργασία ομάδας');
define('_EBLOG_TEAM_TEXT',			'Πατήστε εδώ για να επεξεργαστείτε την ομάδα σας...');
define('_EBLOG_SETTINGS_TITLE',		'Ρυθμίσεις ιστολογίου');
define('_EBLOG_NAME',				'Όνομα ιστολογίου');
define('_EBLOG_SHORTNAME',			'Σύντομο όνομα ιστολογίου');
define('_EBLOG_SHORTNAME_EXTRA',	'<br />(πρέπει να περιέχει μόνο a-z και χωρίς κενά)');
define('_EBLOG_DESC',				'Περιγραφή ιστολογίου');
define('_EBLOG_URL',				'URL');
define('_EBLOG_DEFSKIN',			'Προεπιλεγμένη εμφάνιση');
define('_EBLOG_DEFCAT',			'Προεπιλεγμένη Κατηγορία');
define('_EBLOG_LINEBREAKS',			'Μετατροπή αλλαγών γραμμής');
define('_EBLOG_DISABLECOMMENTS',	'Επιτρέπονται τα σχόλια;<br /><small>(Η απενεργοποίηση σχολίων σημαίνει ότι η προσθήκη σχολίων δεν είναι δυνατή.)</small>');
define('_EBLOG_ANONYMOUS',		'Επιτρέπονται τα σχόλια από μη μέλη;');
define('_EBLOG_NOTIFY',				'Διευθύνσεις για ειδοποίηση (χρησιμοποιείστε το ; ως διαχωριστικό)');
define('_EBLOG_NOTIFY_ON',			'Ειδοποίηση όταν');
define('_EBLOG_NOTIFY_COMMENT',	'Νέα σχόλια');
define('_EBLOG_NOTIFY_KARMA',		'Νέοι ψήφοι κάρμα');
define('_EBLOG_NOTIFY_ITEM',		'Νέα άρθρα ιστολογίου');
define('_EBLOG_PING',				'Ping Weblogs.com κατά την ενημέρωση;');
define('_EBLOG_MAXCOMMENTS',		'Μέγιστος αριθμός σχολίων');
define('_EBLOG_UPDATE',			'Ενημέρωση αρχείου');
define('_EBLOG_OFFSET',			'Χρονική μετάθεση');
define('_EBLOG_STIME',				'Η τρέχουσα ώρα του διακομιστή είναι');
define('_EBLOG_BTIME',				'Η τρέχουσα ώρα του ιστολογίου είναι :');
define('_EBLOG_CHANGE',			'Αλλαγή ρυθμίσεων');
define('_EBLOG_CHANGE_BTN',		'Αλλαγή ρυθμίσεων');
define('_EBLOG_ADMIN',				'Διαχειριστής ιστολογίου');
define('_EBLOG_ADMIN_MSG',			'Θα σας αποδωθούν δικαιώματα διαχειριστή');
define('_EBLOG_CREATE_TITLE',		'Δημιουργία νέου ιστολογίου');
define('_EBLOG_CREATE_TEXT',		'Συμπληρώστε την παρακάτω φόρμα για να δημιουργήσετε ένα νεό ιστολόγιο. <br /><br /> <b>Σημείωση:</b> Παρατίθενται μόνο οι απαραίτητες επιλογές. Αν θέλετε να ρυθμίσετε επιπλέον επιλογές, μπείτε στην σελίδα ρυθμίσεων ιστολογίου αφού δημιουργήσετε το ιστολόγιο.');
define('_EBLOG_CREATE',			'Δημιουργία!');
define('_EBLOG_CREATE_BTN',		'Δημιουργία ιστολογίου');
define('_EBLOG_CAT_TITLE',			'Κατηγορίες');
define('_EBLOG_CAT_NAME',			'Όνομα κατηγορίας');
define('_EBLOG_CAT_DESC',			'Περιγραφή κατηγορίας');
define('_EBLOG_CAT_CREATE',		'Δημιουργία νέας κατηγορίας');
define('_EBLOG_CAT_UPDATE',		'Ενημέρωση κατηγορίας');
define('_EBLOG_CAT_UPDATE_BTN',	'Ενημέρωση κατηγορίας');

// templates
define('_TEMPLATE_TITLE',			'Επεξεργασία προτύπων');
define('_TEMPLATE_AVAILABLE_TITLE',	'Διαθέσιμα πρότυπα');
define('_TEMPLATE_NEW_TITLE',		'Νέο πρότυπο');
define('_TEMPLATE_NAME',			'Όνομα προτύπου');
define('_TEMPLATE_DESC',			'Περιγραφή προτύπου');
define('_TEMPLATE_CREATE',			'Δημιουργία προτύπου');
define('_TEMPLATE_CREATE_BTN',		'Δημιουργία προτύπου');
define('_TEMPLATE_EDIT_TITLE',		'Επεξεργασία προτύπου');
define('_TEMPLATE_BACK',			'Επιστροφή στην προεπισκόπηση προτύπου');
define('_TEMPLATE_EDIT_MSG',		'Δεν είναι απαραραίτητα όλα τα μέρη του προτύπου, αφήστε κενά αυτά που δεν είναι απαραίτητα.');
define('_TEMPLATE_SETTINGS',		'Ρυθμίσεις προτύπου');
define('_TEMPLATE_ITEMS',			'άρθρα');
define('_TEMPLATE_ITEMHEADER',		'Κεφαλίδα άρθρου');
define('_TEMPLATE_ITEMBODY',		'Σώμα άρθρου');
define('_TEMPLATE_ITEMFOOTER',		'Υποσέλιδο άρθρου');
define('_TEMPLATE_MORELINK',		'Σύνδεση σε εκτεταμένη καταχώρηση');
define('_TEMPLATE_NEW',			'Ένδειξη νέου άρθρου');
define('_TEMPLATE_COMMENTS_ANY',	'Σχόλια (αν υπάρχουν)');
define('_TEMPLATE_CHEADER',		'Κεφαλίδα σχολίων');
define('_TEMPLATE_CBODY',			'Σώμα σχολίου');
define('_TEMPLATE_CFOOTER',		'Υποσέλιδο σχολίων');
define('_TEMPLATE_CONE',			'Ένα σχόλιο');
define('_TEMPLATE_CMANY',			'Δύο (ή περισσότερα) σχόλια');
define('_TEMPLATE_CMORE',			'Περισσότερα αναγνωσμένα σχόλια');
define('_TEMPLATE_CMEXTRA',		'Επιπλέον μέλος');
define('_TEMPLATE_COMMENTS_NONE',	'Σχόλια (αν υπάρχουν)');
define('_TEMPLATE_CNONE',			'Καθόλου σχόλια');
define('_TEMPLATE_COMMENTS_TOOMUCH','Σχόλια (αν υπάρχουν, αλλά πάρα πολλά για να εμφανιστούν σε μια γραμμή)');
define('_TEMPLATE_CTOOMUCH',		'Υπερβολικά πολλά σχόλια');
define('_TEMPLATE_ARCHIVELIST',		'Λίστες αρχείου');
define('_TEMPLATE_AHEADER',		'Κεφαλίδα λίστας αρχείου');
define('_TEMPLATE_AITEM',			'Άρθρο λίστας αρχείου');
define('_TEMPLATE_AFOOTER',		'Υποσέλιδο λίστας αρχείου');
define('_TEMPLATE_DATETIME',		'Ημερομηνία και ώρα');
define('_TEMPLATE_DHEADER',		'Κεφαλίδα ημερομηνίας');
define('_TEMPLATE_DFOOTER',		'Υποσέλιδο ημερομηνίας');
define('_TEMPLATE_DFORMAT',		'Μορφή ημερομηνίας');
define('_TEMPLATE_TFORMAT',		'Μορφή ώρας');
define('_TEMPLATE_LOCALE',			'Τοπικές ρυθμίσεις');
define('_TEMPLATE_IMAGE',			'Αναδυόμενες εικόνες');
define('_TEMPLATE_PCODE',			'Κωδικός αναδυόμενου συνδέσμου');
define('_TEMPLATE_ICODE',			'Ενσωματωμένος κώδικας εικόνας');
define('_TEMPLATE_MCODE',			'Κώδικας συνδέσμου άρθρου μέσων');
define('_TEMPLATE_SEARCH',			'Εύρεση');
define('_TEMPLATE_SHIGHLIGHT',		'Επισήμανση');
define('_TEMPLATE_SNOTFOUND',		'Δεν βρέθηκε τίποτα');
define('_TEMPLATE_UPDATE',			'Ενημέρωση');
define('_TEMPLATE_UPDATE_BTN',		'Ενημέρωση προτύπου');
define('_TEMPLATE_RESET_BTN',		'Επαναφορά δεδομένων');
define('_TEMPLATE_CATEGORYLIST',	'Λίστες κατηγοριών');
define('_TEMPLATE_CATHEADER',		'Κεφαλίδα λίστας κατηγοριών');
define('_TEMPLATE_CATITEM',			'Στοιχείο λίστας κατηγοριών');
define('_TEMPLATE_CATFOOTER',		'Υποσέλιδο λίστας κατηγοριών');

// skins - KOSTANTINOS
define('_SKIN_EDIT_TITLE',			'Επεξεργασία εμφανίσεων');
define('_SKIN_AVAILABLE_TITLE',		'Διαθέσιμες εμφανίσεις');
define('_SKIN_NEW_TITLE',			'Νέα εμφάνιση');
define('_SKIN_NAME',				'Όνομα');
define('_SKIN_DESC',				'Περιγραφή');
define('_SKIN_TYPE',				'Τύπος Περιεχομένου');
define('_SKIN_CREATE',				'Δημιουργία');
define('_SKIN_CREATE_BTN',			'Δημιουργία εμφάνισης');
define('_SKIN_EDITONE_TITLE',		'Επεξεργασία εμφάνισης');
define('_SKIN_BACK',				'Πίσω στη γενική προεπισκόπηση εμφάνισης ');
define('_SKIN_PARTS_TITLE',			'Μέρη εμφάνισης');
define('_SKIN_PARTS_MSG',			'Δεν χρειάζονται όλοι οι τύποι για κάθε εμφάνιση. Άφησε κενά αυτά που δεν χρειάζονται. Διαλέξτε τον τύπο εμφάνισης που θα επεξεργαστείτε:');
define('_SKIN_PART_MAIN',			'Αρχική σελίδα');
define('_SKIN_PART_ITEM',			'Σελίδες άρθρων');
define('_SKIN_PART_ALIST',			'Λίστα αρχείων');
define('_SKIN_PART_ARCHIVE',		'Αρχείο');
define('_SKIN_PART_SEARCH',			'Αναζήτηση');
define('_SKIN_PART_ERROR',			'Λάθη');
define('_SKIN_PART_MEMBER',		'Στοιχεία μελών');
define('_SKIN_PART_POPUP',			'Αναδυόμενες εικόνες');
define('_SKIN_GENSETTINGS_TITLE',	'Γενικές ρυθμίσεις');
define('_SKIN_CHANGE',				'Αλλαγή');
define('_SKIN_CHANGE_BTN',			'Αλλαγή των ρυθμίσεων');
define('_SKIN_UPDATE_BTN',			'Ανανέωση εμφάνισης');
define('_SKIN_RESET_BTN',			'Επαναφορά δεδομένων');
define('_SKIN_EDITPART_TITLE',		'Επεξεργασία εμφάνισης');
define('_SKIN_GOBACK',				'Πήγαινε Πίσω');
define('_SKIN_ALLOWEDVARS',		'Επιτρεπόμενες μεταβλητές (πατήστε για πληροφορίες):');

// global settings
define('_SETTINGS_TITLE',			'Γενικές ρυθμίσεις');
define('_SETTINGS_SUB_GENERAL',		'Γενικές ρυθμίσεις');
define('_SETTINGS_DEFBLOG',			'Προεπιλεγμένο ιστολόγιο');
define('_SETTINGS_ADMINMAIL',		'Email διαχειριστή' );
define('_SETTINGS_SITENAME',		'Όνομα δικτυακού τόπου');
define('_SETTINGS_SITEURL',			'URL δικτυακού τόπου (πρέπει να τελειώνει με κάθετο)');
define('_SETTINGS_ADMINURL',		'URL περιοχής διαχείρισης (πρέπει να τελειώνει με κάθετο)');
define('_SETTINGS_DIRS',			' Κατάλογοι Nucleus ');
define('_SETTINGS_MEDIADIR',		' Κατάλογοι Media ');
define('_SETTINGS_SEECONFIGPHP',	'(βλέπε config.php)');
define('_SETTINGS_MEDIAURL',		'Media URL (πρέπει να τελειώνει με κάθετο)');
define('_SETTINGS_ALLOWUPLOAD',	'Να επιτρέπεται η αποστολή αρχείων;');
define('_SETTINGS_ALLOWUPLOADTYPES','Τύποι αρχείων που επιτρέπεται η αποστολή τους');
define('_SETTINGS_CHANGELOGIN',	'Να επιτρέπεται στους χρήστες να αλλάξουν όνομα χρήστη/κωδικό πρόσβασης');
define('_SETTINGS_COOKIES_TITLE',	' Ρυθμίσεις cookie');
define('_SETTINGS_COOKIELIFE',		'Διάρκεια cookie σύνδεσης');
define('_SETTINGS_COOKIESESSION',	'Cookies περιόδου λειτουργίας');
define('_SETTINGS_COOKIEMONTH',	'Διάρκεια για ένα μήνα');
define('_SETTINGS_COOKIEPATH',		' Διαδρομή cookie (προχωρημένο)');
define('_SETTINGS_COOKIEDOMAIN',	'Cookie τομέα (προχωρημένο)');
define('_SETTINGS_COOKIESECURE',	'Ασφαλές cookie (προχωρημένο)');
define('_SETTINGS_LASTVISIT',		'Αποθήκευση cookies τελευταίας επίσκεψης');
define('_SETTINGS_ALLOWCREATE',	'Να επιτρέπεται στους επισκέπτες να δημιουργήσουν λογαριασμό μέλους');
define('_SETTINGS_NEWLOGIN',		'Να επιτρέπεται η σύνδεση σε λογαριασμούς που δημιούργησαν χρήστες');
define('_SETTINGS_NEWLOGIN2',		'(ισχύει μόνο για νέους λογαριασμούς)');
define('_SETTINGS_MEMBERMSGS',		'Να επιτρέπεται η υπηρεσία μέλος-σε-μέλος');
define('_SETTINGS_LANGUAGE',		'Προεπιλεγμένη γλώσσα');
define('_SETTINGS_DISABLESITE',		'Απενεργοποίηση δικτυακού τόπου');
define('_SETTINGS_DBLOGIN',			'mySQL Login &amp; Database');
define('_SETTINGS_UPDATE',			'Ανανέωση ρυθμίσεων');
define('_SETTINGS_UPDATE_BTN',		'Ανανέωση ρυθμίσεων');
define('_SETTINGS_DISABLEJS',		'Απενεργοποίηση γραμμών εργαλείων JavaScript ');
define('_SETTINGS_MEDIA',			'Μέσα/Αποστολή αρχείων');
define('_SETTINGS_MEDIAPREFIX',		'Προκαθορισμένα αρχεία για αποστολή με ημερομηνία');
define('_SETTINGS_MEMBERS',		'Ρυθμίσεις μέλους');

// bans
define('_BAN_TITLE',				'Λίστα αποκλεισμού για');
define('_BAN_NONE',				'Όχι απαγορέυσεις για αυτό το ιστολόγιο');
define('_BAN_NEW_TITLE',			'Προσθήκη νέας αποκλεισμού');
define('_BAN_NEW_TEXT',			'Προσθήκη νέου αποκλεισμού τώρα');
define('_BAN_REMOVE_TITLE',			'Κατάργηση αποκλεισμού');
define('_BAN_IPRANGE',				'Εύρος IP');
define('_BAN_BLOGS',				'Ποια ιστολόγια;');
define('_BAN_DELETE_TITLE',			'Διαγραφή αποκλεισμού');
define('_BAN_ALLBLOGS',			'Όλα τα ιστολόγια στα οποία έχετε δικαιώματα διαχειριστή ');
define('_BAN_REMOVED_TITLE',		'Ο αποκλεισμός διαγράφηκε');
define('_BAN_REMOVED_TEXT',		'Ο αποκλεισμός καταργήθηκε από τα παρακάτω ιστολόγια:');
define('_BAN_ADD_TITLE',			'Προσθήκη αποκλεισμού');
define('_BAN_IPRANGE_TEXT',			'Επιλογή εμβέλεια IP που θέλετε να μπλοκάρετε. Όσο πιο λίγους αριθμούς περιέχει, τόσο περισσότερες διευθύνσεις θα αποκλειστούν');
define('_BAN_BLOGS_TEXT',			'Μπορείτε είτε να διαλέξετε να αποκλείσετε την IP σε ένα μόνο ιστολόγιο είτε να την αποκλείσετε σε όλα τα ιστολόγια στα οποία έχετε δικαιώματα διαχειριστή. Κάντε την επιλογή σας παρακάτω');
define('_BAN_REASON_TITLE',			'Λόγος');
define('_BAN_REASON_TEXT',			'Μπορείτε να δώσετε ένα λόγο για τον αποκλεισμό, ο οποίος θα εμφανίζεται όταν ο κάτοχος IP προσπαθήσει να προσθέσει άλλο σχόλιο ή να δώσει ψήφο karma. Το μέγιστο μήκος είναι 256 χαρακτήρες.');
define('_BAN_ADD_BTN',				'Προσθήκη αποκλεισμού');

// LOGIN screen
define('_LOGIN_MESSAGE',			'Μήνυμα');
define('_LOGIN_NAME',				'Όνομα');
define('_LOGIN_PASSWORD',			'Κωδικός πρόσβασης');
define('_LOGIN_SHARED',			'Κοινόχρηστη φόρμα σύνδεσης');
define('_LOGIN_FORGOT',			'Ξεχάσατε τον κωδικό σας;');

// membermanagement
define('_MEMBERS_TITLE',			'Διαχείριση μέλους');
define('_MEMBERS_CURRENT',			'Υπάρχοντα μέλη');
define('_MEMBERS_NEW',			'Νέο μέλος');
define('_MEMBERS_DISPLAY',			'Εμφάνιση ονόματος');
define('_MEMBERS_DISPLAY_INFO',		'(Αυτό είναι το όνομα που χρησιμοποιείς για login)');
define('_MEMBERS_REALNAME',		'Πραγματικό όνομα');
define('_MEMBERS_PWD',			'Κωδικός πρόσβασης');
define('_MEMBERS_REPPWD',			'Επανάληψη κωδικού πρόσβασης');
define('_MEMBERS_EMAIL',			'Διεύθυνση ηλεκτρονικού ταχυδρομείου');
define('_MEMBERS_EMAIL_EDIT',		'(Όταν αλλάξετε τη διεύθυνση ηλεκτρονικού ταχυδρομείου, ένας νέος κωδικός πρόσβασης θα σταλεί αυτόματα σε αυτή τη διεύθυνση )');
define('_MEMBERS_URL',				'Διεύθυνση τοποθεσίας (URL)');
define('_MEMBERS_SUPERADMIN',		'Δικαιώματα διαχειριστή');
define('_MEMBERS_CANLOGIN',		'Μπορείτε να συνδεθείτε στην περιοχή του Διαχειριστή');
define('_MEMBERS_NOTES',			'Σημειώσεις');
define('_MEMBERS_NEW_BTN',		'Προσθήκη μέλους');
define('_MEMBERS_EDIT',			'Επεξεργασία μέλους');
define('_MEMBERS_EDIT_BTN',		'Αλλαγή Ρυθμίσεων');
define('_MEMBERS_BACKTOOVERVIEW',	'Πίσω στην προεπισκόπηση μέλους');
define('_MEMBERS_DEFLANG',			'Γλώσσα');
define('_MEMBERS_USESITELANG',		'- Χρήση ρυθμίσεων δικτυακού τόπου -');

// List of blogs (TT = tooltip)
define('_BLOGLIST_TT_VISIT',		'Επίσκεψη δικτυακού τόπου');
define('_BLOGLIST_ADD',			'Προσθήκη άρθρου');
define('_BLOGLIST_TT_ADD',		'Προσθήκη νέου άρθρου σε αυτό το ιστολόγιο');
define('_BLOGLIST_EDIT',		'Επεξεργασία /Διαγραφή άρθρων');
define('_BLOGLIST_TT_EDIT',			'');
define('_BLOGLIST_BMLET',			'Σελιδοδεικτίδιο');
define('_BLOGLIST_TT_BMLET',		'');
define('_BLOGLIST_SETTINGS',		'Ρυθμίσεις');
define('_BLOGLIST_TT_SETTINGS',		'Επεξεργασία ρυθμίσεων ή διαχείριση ομάδας');
define('_BLOGLIST_BANS',			'Απαγορεύσεις');
define('_BLOGLIST_TT_BANS',			'Προβολή, προσθήκη ή κατάργηση απαγορευμένων IP');
define('_BLOGLIST_DELETE',			'Διαγραφή όλων');
define('_BLOGLIST_TT_DELETE',		'Διαγραφή αυτής της καταγραφής');

// OVERVIEW screen
define('_OVERVIEW_YRBLOGS',		'Οι καταγραφές σας');
define('_OVERVIEW_YRDRAFTS',		'Το προσχέδιό σας');
define('_OVERVIEW_YRSETTINGS',		'Οι ρυθμίσεις σας');
define('_OVERVIEW_GSETTINGS',		'Γενικές ρυθμίσεις');
define('_OVERVIEW_NOBLOGS',		'Δεν είστε σε καμία ομαδική λίστα καταγραφών');
define('_OVERVIEW_NODRAFTS',		'Κανένα προσχέδιο');
define('_OVERVIEW_EDITSETTINGS',	'Επεξεργασία ρυθμίσεων...');
define('_OVERVIEW_BROWSEITEMS',	'Περιήγηση στα άρθρα...');
define('_OVERVIEW_BROWSECOMM',	'Περιήγηση στα σχόλια...');
define('_OVERVIEW_VIEWLOG',		'Προβολή ημερολογίου ενεργειών...');
define('_OVERVIEW_MEMBERS',		'Διαχείριση μελών...');
define('_OVERVIEW_NEWLOG',		'Δημιουργία νέου ημερολογίου ενεργειών...');
define('_OVERVIEW_SETTINGS',		'Επεξεργασία ρυθμίσεων...');
define('_OVERVIEW_TEMPLATES',		'Επεξεργασία προτύπου...');
define('_OVERVIEW_SKINS',			'Επεξεργασία εμφανίσεων...');
define('_OVERVIEW_BACKUP',			'Αντίγραφο ασφαλείας/Επαναφορά...');

// ITEMLIST
define('_ITEMLIST_BLOG',			'Άρθρα για το ιστολόγιο'); 
define('_ITEMLIST_YOUR',			'Τα άρθρα σας');

// Comments
define('_COMMENTS',				'Σχόλια');
define('_NOCOMMENTS',				'Κανένα σχόλιο για αυτό το άρθρο');
define('_COMMENTS_YOUR',			'Τα σχόλιά σας');
define('_NOCOMMENTS_YOUR',		'Δεν γράψατε κανένα σχόλιο');

// LISTS (general)
define('_LISTS_NOMORE',			'Δεν υπάρχουν άλλα αποτελέσματα ή δεν βρέθηκαν καθόλου αποτελέσματα');
define('_LISTS_PREV',				'Προηγούμενο');
define('_LISTS_NEXT',				'Επόμενο');
define('_LISTS_SEARCH',				'Εύρεση');
define('_LISTS_CHANGE',				'Αλλαγή');
define('_LISTS_PERPAGE',			'άρθρα/σελίδα');
define('_LISTS_ACTIONS',			'Ενέργειες');
define('_LISTS_DELETE',				'Διαγραφή');
define('_LISTS_EDIT',				'Επεξεργασία');
define('_LISTS_MOVE',				'Μετακίνηση');
define('_LISTS_CLONE',				'Κλωνοποίηση');
define('_LISTS_TITLE',				'Τίτλος');
define('_LISTS_BLOG',				'Ιστολόγιο');
define('_LISTS_NAME',				'Όνομα');
define('_LISTS_DESC',				'Περιγραφή');
define('_LISTS_TIME',				'Ώρα');
define('_LISTS_COMMENTS',			'Σχόλια');
define('_LISTS_TYPE',				'Τύπος ');


// member list 
define('_LIST_MEMBER_NAME',		'Εμφάνιση ονόματος');
define('_LIST_MEMBER_RNAME',		'Πραγματικό όνομα');
define('_LIST_MEMBER_ADMIN',		'Υπέρδιαχειριστής; ');
define('_LIST_MEMBER_LOGIN',		'Μπορώ να συνδεθώ; ');
define('_LIST_MEMBER_URL',			'Δικτυακός τόπος');

// banlist
define('_LIST_BAN_IPRANGE',			'Εμβέλεια IP');
define('_LIST_BAN_REASON',			'Λόγος');

// actionlist
define('_LIST_ACTION_MSG',			'Μήνυμα');

// commentlist
define('_LIST_COMMENT_BANIP',		'Αποκλεισμός IP');
define('_LIST_COMMENT_WHO',		'Συντάκτης');
define('_LIST_COMMENT',			'Σχόλιο');
define('_LIST_COMMENT_HOST',		'Host');

// itemlist
define('_LIST_ITEM_INFO',			'Πληροφορία');
define('_LIST_ITEM_CONTENT',		'Τίτλος και Κείμενο');


// teamlist
define('_LIST_TEAM_ADMIN',			'Διαχειριστής ');
define('_LIST_TEAM_CHADMIN',		'Αλλαγή διαχειριστή');

// edit comments
define('_EDITC_TITLE',				'Επεξεργασία σχολίων');
define('_EDITC_WHO',				'Συντάκτης');
define('_EDITC_HOST',				'Από πού;');
define('_EDITC_WHEN',				'Πότε;');
define('_EDITC_TEXT',				'Κείμενο');
define('_EDITC_EDIT',				'Επεξεργασία σχολίου');
define('_EDITC_MEMBER',			'μέλος');
define('_EDITC_NONMEMBER',			'όχι μέλος');

// move item
define('_MOVE_TITLE',				'Μεταφορά σε ποιο ιστολόγιο;');
define('_MOVE_BTN',				'Μεταφορά άρθρου');
