<?php
/*
 nce (ntch cloud environment.)
 name: database.php
 author: Akira Ohta (akohta001.gmail.com)
 date: 2013-apr-13th
 License: GPLv3
 */
include_once "preference.php";

abstract class nc_Database{
	
	abstract function open();
	abstract function execute($query);
	abstract function close();
	abstract function lastError();
}

class nc_MySqlDB extends nc_Database{
	private $handle = null;
	
	function open(){
		$this->close();
	 	@$this->handle = new mysqli(
			HOST_NAME, 
			DB_LOGIN_ID, 
			DB_LOGIN_PASS, 
			DB_NAME);
		if(mysqli_connect_errno()){
			throw new Exception(mysqli_connect_error());
		}
	}
	function execute($query){
		$result = $this->handle->query($query);
		if(!$result){
			throw new Exception($this->lastError());
		}
		return $result;
	}
	function close(){
		if($this->handle){
			$this->handle->close();
		}
		$this->handle = null;
	}
	function lastError(){
		if(null == $this->handle){
			return null;
		}
		return $this->handle->error;
	}
}

class nc_SqliteDB extends nc_Database{
	private $handle = null;
	private $result = null;
	function open(){
		$this->close();
		@$this->handle = new SQLiteDatabase(DB_FILE_NAME);
		if(!$this->handle){
			throw new Exception("Couldn't open database file.");
		}
	}
	function execute($query){
		if(!@$this->handle->queryExec($sql, $error)){  
			throw new Exception($this->lastError());
		}
	}
	function close(){
		if($this->result){
			$this->result->close();
		}
		if($this->handle){
			$this->handle->close();
		}
		$this->result = null;
		$this->handle = null;
	}
	function lastError(){
		if(null == $this->handle)
			return null;

		return sqlite_error_string($this->handle->lastError());
	}
}

$db =  null;

if(USE_DB === "mysql"){
	$db = new nc_MySqlDB();
}else if(USE_DB === "sqlite"){
	$db = new nc_SqliteDB();
}else{
	exit;
}

$nc_ACCOUNTTABLE_NAME = TABLE_PREFIX."account";
?>
