/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.Serializable;
import twitter4j.RateLimitStatus;
import twitter4j.RateLimitStatusJSONImpl;
import twitter4j.TwitterResponse;
import twitter4j.internal.http.HttpResponse;

abstract class TwitterResponseImpl
implements TwitterResponse,
Serializable {
    private transient RateLimitStatus rateLimitStatus = null;
    private static final long serialVersionUID = -7284708239736552059L;
    private transient int accessLevel;

    public TwitterResponseImpl() {
        this.accessLevel = 0;
    }

    public TwitterResponseImpl(HttpResponse res) {
        this.rateLimitStatus = RateLimitStatusJSONImpl.createFromResponseHeader(res);
        this.accessLevel = TwitterResponseImpl.toAccessLevel(res);
    }

    static int toAccessLevel(HttpResponse res) {
        int accessLevel;
        if (null == res) {
            return -1;
        }
        String xAccessLevel = res.getResponseHeader("X-Access-Level");
        if (null == xAccessLevel) {
            accessLevel = 0;
        } else {
            switch (xAccessLevel.length()) {
                case 4: {
                    accessLevel = 1;
                    break;
                }
                case 10: {
                    accessLevel = 2;
                    break;
                }
                case 25: {
                    accessLevel = 3;
                    break;
                }
                case 26: {
                    accessLevel = 3;
                    break;
                }
                default: {
                    accessLevel = 0;
                }
            }
        }
        return accessLevel;
    }

    public RateLimitStatus getRateLimitStatus() {
        return this.rateLimitStatus;
    }

    public int getAccessLevel() {
        return this.accessLevel;
    }
}

