/*
 * Decompiled with CFR 0.152.
 */
package twitter4j.media;

import twitter4j.TwitterException;
import twitter4j.auth.OAuthAuthorization;
import twitter4j.conf.Configuration;
import twitter4j.internal.http.HttpParameter;
import twitter4j.media.AbstractImageUploadImpl;

class TwiplUpload
extends AbstractImageUploadImpl {
    public TwiplUpload(Configuration conf, String apiKey, OAuthAuthorization oauth) {
        super(conf, apiKey, oauth);
    }

    protected String postUpload() throws TwitterException {
        int j;
        String h;
        int i;
        int statusCode = this.httpResponse.getStatusCode();
        if (statusCode != 200) {
            throw new TwitterException("Twipl image upload returned invalid status code", this.httpResponse);
        }
        String response = this.httpResponse.asString();
        if (-1 != response.indexOf("<response status=\"ok\">")) {
            int j2;
            String h2 = "<mediaurl>";
            int i2 = response.indexOf(h2);
            if (i2 != -1 && (j2 = response.indexOf("</mediaurl>", i2 + h2.length())) != -1) {
                return response.substring(i2 + h2.length(), j2);
            }
        } else if (-1 != response.indexOf("<rsp status=\"fail\">") && (i = response.indexOf(h = "msg=\"")) != -1 && (j = response.indexOf("\"", i + h.length())) != -1) {
            String msg = response.substring(i + h.length(), j);
            throw new TwitterException("Invalid Twitgoo response: " + msg);
        }
        throw new TwitterException("Unknown Twipl response", this.httpResponse);
    }

    protected void preUpload() throws TwitterException {
        this.uploadUrl = "http://api.twipl.net/2/upload.xml";
        String verifyCredentialsAuthorizationHeader = this.generateVerifyCredentialsAuthorizationHeader("https://api.twitter.com/1/account/verify_credentials.xml");
        this.headers.put("X-OAUTH-AUTHORIZATION ", verifyCredentialsAuthorizationHeader);
        this.headers.put("X-OAUTH-SP-URL ", "https://api.twitter.com/1/account/verify_credentials.xml");
        if (null == this.apiKey) {
            throw new IllegalStateException("No API Key for Twipl specified. put media.providerAPIKey in twitter4j.properties.");
        }
        String fname = this.image.getFile().getName();
        HttpParameter[] params = new HttpParameter[]{new HttpParameter("key", this.apiKey), new HttpParameter("media1", fname, this.image.getFileBody())};
        if (this.message != null) {
            params = this.appendHttpParameters(new HttpParameter[]{this.message}, params);
        }
        this.postParameter = params;
    }
}

