/*
 * Decompiled with CFR 0.152.
 */
package twitter4j.auth;

import java.io.Serializable;
import javax.crypto.spec.SecretKeySpec;
import twitter4j.TwitterException;
import twitter4j.internal.http.HttpResponse;
import twitter4j.internal.util.T4JInternalStringUtil;

abstract class OAuthToken
implements Serializable {
    private static final long serialVersionUID = 3891133932519746686L;
    private String token;
    private String tokenSecret;
    private transient SecretKeySpec secretKeySpec;
    String[] responseStr = null;

    public OAuthToken(String token, String tokenSecret) {
        this.token = token;
        this.tokenSecret = tokenSecret;
    }

    OAuthToken(HttpResponse response) throws TwitterException {
        this(response.asString());
    }

    OAuthToken(String string) {
        this.responseStr = T4JInternalStringUtil.split(string, "&");
        this.tokenSecret = this.getParameter("oauth_token_secret");
        this.token = this.getParameter("oauth_token");
    }

    public String getToken() {
        return this.token;
    }

    public String getTokenSecret() {
        return this.tokenSecret;
    }

    void setSecretKeySpec(SecretKeySpec secretKeySpec) {
        this.secretKeySpec = secretKeySpec;
    }

    SecretKeySpec getSecretKeySpec() {
        return this.secretKeySpec;
    }

    public String getParameter(String parameter) {
        String value = null;
        String[] arr$ = this.responseStr;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            String str = arr$[i$];
            if (!str.startsWith(parameter + '=')) continue;
            value = T4JInternalStringUtil.split(str, "=")[1].trim();
            break;
        }
        return value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OAuthToken)) {
            return false;
        }
        OAuthToken that = (OAuthToken)o;
        if (!this.token.equals(that.token)) {
            return false;
        }
        return this.tokenSecret.equals(that.tokenSecret);
    }

    public int hashCode() {
        int result = this.token.hashCode();
        result = 31 * result + this.tokenSecret.hashCode();
        return result;
    }

    public String toString() {
        return "OAuthToken{token='" + this.token + '\'' + ", tokenSecret='" + this.tokenSecret + '\'' + ", secretKeySpec=" + this.secretKeySpec + '}';
    }
}

