/*
 * Decompiled with CFR 0.152.
 */
package twitter4j.media;

import twitter4j.TwitterException;
import twitter4j.auth.OAuthAuthorization;
import twitter4j.conf.Configuration;
import twitter4j.internal.http.HttpParameter;
import twitter4j.internal.org.json.JSONException;
import twitter4j.internal.org.json.JSONObject;
import twitter4j.media.AbstractImageUploadImpl;

class MobypictureUpload
extends AbstractImageUploadImpl {
    public MobypictureUpload(Configuration conf, String apiKey, OAuthAuthorization oauth) {
        super(conf, apiKey, oauth);
    }

    protected String postUpload() throws TwitterException {
        int statusCode = this.httpResponse.getStatusCode();
        if (statusCode != 200) {
            throw new TwitterException("Mobypic image upload returned invalid status code", this.httpResponse);
        }
        String response = this.httpResponse.asString();
        try {
            JSONObject json = new JSONObject(response);
            if (!json.isNull("media")) {
                return json.getJSONObject("media").getString("mediaurl");
            }
        }
        catch (JSONException e) {
            throw new TwitterException("Invalid Mobypic response: " + response, (Throwable)e);
        }
        throw new TwitterException("Unknown Mobypic response", this.httpResponse);
    }

    protected void preUpload() throws TwitterException {
        this.uploadUrl = "https://api.mobypicture.com/2.0/upload.json";
        String verifyCredentialsAuthorizationHeader = this.generateVerifyCredentialsAuthorizationHeader("https://api.twitter.com/1/account/verify_credentials.json");
        this.headers.put("X-Auth-Service-Provider", "https://api.twitter.com/1/account/verify_credentials.json");
        this.headers.put("X-Verify-Credentials-Authorization", verifyCredentialsAuthorizationHeader);
        if (null == this.apiKey) {
            throw new IllegalStateException("No API Key for Mobypic specified. put media.providerAPIKey in twitter4j.properties.");
        }
        HttpParameter[] params = new HttpParameter[]{new HttpParameter("key", this.apiKey), this.image};
        if (this.message != null) {
            params = this.appendHttpParameters(new HttpParameter[]{this.message}, params);
        }
        this.postParameter = params;
    }
}

