﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Diagnostics;   // for Debug.WriteLine
using System.IO;
using Microsoft.Win32;            // Path


namespace nodokaGuiEdit
{
    public partial class commandWizard : Form
    {
        public FormMain formMain;
        public commandWizard(int commandNumber)
        {
            InitializeComponent();

            Global_Val.status = false;
            Global_Val.commandNumber = commandNumber;

            // keyの時は下記でよいが、他では違う可能性がある。
            Debug.WriteLine("wizardModeNew:" + FormMain.Global_Val.wizardModeNew.ToString());
            Debug.WriteLine("caption:" + FormMain.Global_Val.caption);
            if (FormMain.Global_Val.wizardModeNew == true)      // 新規
            {
                Tab1CaptionTextBox.Text = mode_name[commandNumber];
                Global_Val.reWizardFirst = false;
                Debug.WriteLine("new \"" + Tab1CaptionTextBox.Text + "\"");
            }
            else
            {
                Tab1CaptionTextBox.Text = FormMain.Global_Val.caption;
                Global_Val.reWizardFirst = true;
            }
            Tab2NewTextBox.Text = FormMain.Global_Val.LeftString;
            Tab3NewTextBox.Text = FormMain.Global_Val.RightString;
            Tab2OldTextBox.Text = FormMain.Global_Val.LeftString;
            Tab3OldTextBox.Text = FormMain.Global_Val.RightString;

            // タブが変更された時のイベントハンドラー
            tabControl1.SelectedIndexChanged += new EventHandler(TabControl1_SelectedIndexChanged);
        }

        private void FormInsert_Load(object sender, EventArgs e)
        {
            // tabPage1 listboxの初期化
            this.Tab1CommandListBox.ClearSelected();
            this.Tab1CommandListBox.Items.AddRange(mode_list);
            this.Tab1CommandListBox.SelectedIndex = Global_Val.commandNumber;
            Global_Val.firstView = true;
            Global_Val.caption = String.Empty;
            Global_Val.leftString = String.Empty;
            Global_Val.rightString = String.Empty;
            Global_Val.left_mod = String.Empty;
            Global_Val.left_key = String.Empty;
            Global_Val.right_mod = String.Empty;
            Global_Val.right_key = String.Empty;

            Reg104Read();
        }

        private void Reg104Read()
        {
            // のどかインストール時に設定された104 layout状態を取り出す。
            this.Tab2RadioButton104.Enabled = true;
            this.Tab2RadioButton109.Enabled = true;

            string stringValue = string.Empty;

            RegistryKey rk = Registry.LocalMachine.OpenSubKey("Software\\appletkan\\nodoka", false);
            if (rk != null)
            {
                stringValue = (string)rk.GetValue("layout");
            }

            // system user104 user109   resurt 
            //   null  false   false     109
            //   104   false   false     104
            //   109   false   false     109
            //    *    true    false     104
            //    *    false   true      109
            
            // システム側 null だった場合、user側どちらが trueなら、その値を使う。
            if (stringValue == string.Empty)
            {
                if(readRegbUser104() == false && readRegbUser109() == false)
                {
                    this.Tab2RadioButton104.Checked = false;
                }
                if(readRegbUser104() == true && readRegbUser109() == false)
                {
                    this.Tab2RadioButton104.Checked = true;
                }
                if(readRegbUser104() == false && readRegbUser109() == true)
                {
                    this.Tab2RadioButton104.Checked = false;
                }
            }

            if (stringValue == "104")
            {
                if (readRegbUser104() == false && readRegbUser109() == false)
                {
                    this.Tab2RadioButton104.Checked = true;
                }
                if (readRegbUser104() == true && readRegbUser109() == false)
                {
                    this.Tab2RadioButton104.Checked = true;
                }
                if (readRegbUser104() == false && readRegbUser109() == true)
                {
                    this.Tab2RadioButton104.Checked = false;
                }
            }

            if (stringValue == "109")
            {
                if (readRegbUser104() == false && readRegbUser109() == false)
                {
                    this.Tab2RadioButton104.Checked = false;
                }
                if (readRegbUser104() == true && readRegbUser109() == false)
                {
                    this.Tab2RadioButton104.Checked = true;
                }
                if (readRegbUser104() == false && readRegbUser109() == true)
                {
                    this.Tab2RadioButton104.Checked = false;
                }
            }
        }


        private bool readRegbUser104()
        {
            string stringValue = String.Empty;

            // ユーザによるラジオボタン設定状態を取り出す
            RegistryKey rk = Registry.CurrentUser.CreateSubKey("Software\\appletkan\\nodoka");
            if (rk != null)
            {
                stringValue = (string)rk.GetValue("bUser104");
            }

            if (stringValue == "true")
            {
                return true;
            }
            else
            {
                return false;
            }
        }

        private bool readRegbUser109()
        {
            string stringValue = String.Empty;

            // ユーザによるラジオボタン設定状態を取り出す
            RegistryKey rk = Registry.CurrentUser.CreateSubKey("Software\\appletkan\\nodoka");
            if (rk != null)
            {
                stringValue = (string)rk.GetValue("bUser104");
            }

            if (stringValue == "false")
            {
                return true;
            }
            else
            {
                return false;
            }
        }

        private void setRegbUser104(bool bStatus)
        {
            // ユーザによるラジオボタン状態を保存。
            RegistryKey rk = Registry.CurrentUser.CreateSubKey("Software\\appletkan\\nodoka");

            if (rk != null)
            {
                if (bStatus == true)
                {
                    rk.SetValue("bUser104", "true");
                }
                else
                {
                    rk.SetValue("bUser104", "false");
                }
            }
        }

        // Windowを閉じる処理
        private void closeMyDialog()
        {
            Global_Val.caption = Tab1CaptionTextBox.Text;
            Global_Val.leftString = Tab2NewTextBox.Text;
            Global_Val.rightString = Tab3NewTextBox.Text;
            Global_Val.status = true;
            this.Close();
        }

        private void Tab3OkButton_Click(object sender, EventArgs e)
        {
            // 3rd tab OK
            closeMyDialog();
        }

        // Wizard的ボタン実装
        private void Tab1NextButton_Click(object sender, EventArgs e)
        {
            // tabPage1 Next Button
            this.tabControl1.SelectedTab = tabPage2;
        }

        private void Tab2PrevButton_Click(object sender, EventArgs e)
        {
            // tabPage2 Priv Button
            this.tabControl1.SelectedTab = tabPage1;
        }

        private void Tab2NextButton_Click(object sender, EventArgs e)
        {
            // tabPage2 Next Button
            if (Global_Val.commandNumber == 4)  // include
            {
                // includeではTab2の次ボタンは、OKに変えてあるので
                // Tab3を表示せずに閉じる。
                closeMyDialog();
            }
            else
            {
                this.tabControl1.SelectedTab = tabPage3;
            }
        }

        private void Tab3PrevButton_Click(object sender, EventArgs e)
        {
            // tabPage3 Priv Button
            this.tabControl1.SelectedTab = tabPage2;
        }

        // tabPage1の実装　Wizardのモード番号を取得する。
        private void Tab1CommandListBox_SelectedIndexChanged(object sender, EventArgs e)
        {
            Global_Val.commandNumber = Tab1CommandListBox.SelectedIndex;
            if (Global_Val.reWizardFirst == true)
            {
                Global_Val.reWizardFirst = false;
            }
            else
            {
                Tab1CaptionTextBox.Text = mode_name[Global_Val.commandNumber];    // 再Wizardでもコマンド変更された場合
            }
        }

        // タブが変更されたときにモード番号ごとに表示内容の初期化
        private void TabControl1_SelectedIndexChanged(object sender, EventArgs e)
        {
            // タブが変更された時のイベントハンドラー
            Debug.WriteLine("current tab = " + tabControl1.SelectedTab.Name.ToString());

            // 表示されているタブにおいて、通知領域をコマンドごとに初期化する。
            switch (tabControl1.SelectedIndex)
            {
                case 0: // タブ1
                    this.FormInsertStatusLabel.Text = "コマンドを選択して説明文の入力してください。";
                    break;
                case 1: // タブ2
                    switch (Global_Val.commandNumber)
                    {
                        case 0: // keymap
                            this.FormInsertStatusLabel.Text = "キーマップ名の入力してください。";
                            break;
                        case 1: // key
                            this.FormInsertStatusLabel.Text = "変更前のキーバインドを入力してください。";
                            Reg104Read();
                            break;
                        case 2: // mod
                            this.FormInsertStatusLabel.Text = "設定を変更したいモディファイヤ種別を選択してください。";
                            Reg104Read();
                            break;
                        case 3: // window
                            break;
                        case 4: // include
                            this.FormInsertStatusLabel.Text = "読み込ませるファイル名を指定してください。";
                            break;
                        case 5: // def option
                            break;
                        case 6: // def key
                            break;
                        case 7: // other
                            break;
                        default:
                            this.FormInsertStatusLabel.Text = string.Empty;
                            break;
                    }
                    break;
                case 2: // タブ3
                    switch (Global_Val.commandNumber)
                    {
                        case 0: // keymap
                            this.FormInsertStatusLabel.Text = "親キーマップ名を入力してください。";
                            break;
                        case 1: // key
                            this.FormInsertStatusLabel.Text = "変更後のキーバインドを入力してください。";
                            break;
                        case 2: // mod
                            this.FormInsertStatusLabel.Text = "モディファイヤに追加/削除したいキーを選択してください。";
                            break;
                        case 3: // window
                            break;
                        case 4: // include
                            this.FormInsertStatusLabel.Text = string.Empty;
                            break;
                        case 5: // def option
                            break;
                        case 6: // def key
                            break;
                        case 7: // other
                            break;
                        default:
                            this.FormInsertStatusLabel.Text = string.Empty;
                            break;
                    }
                    break;
                default:
                    this.FormInsertStatusLabel.Text = string.Empty;
                    break;
            }

            // コマンドに応じてタブ2,3を初期化する。

            // ファイル名選択ボタンを無効にして隠す。
            this.SelectFileButton.Enabled = false;
            this.SelectFileButton.Visible = false;

            switch (Global_Val.commandNumber)
            {
                case 0:     // keymap
                    // 必要なコントロールを有効にして、他は無効にすること。
                    // 文言も変更する必要がある。
                    this.tabControl1.TabPages[1].Text = "キーマップ名";
                    this.tabControl1.TabPages[2].Text = "親キーマップ名";

                    this.Tab2LeftLabel.Text = "キーマップ名";
                    this.Tab2LeftCheckedListBox.Items.Clear();
                    this.Tab2LeftCheckedListBox.Items.AddRange(keymapGlobal);

                    this.Tab2AsterCheckBox.Text = string.Empty;
                    this.Tab2AsterCheckBox.Enabled = false;
                    this.Tab2AsterCheckBox.Visible = false;

                    this.Tab2CenterLabel.Text = string.Empty;
                    this.Tab2RightLabel.Text = string.Empty;
                    this.Tab2CenterListBox.Items.Clear();
                    this.Tab2RightListBox.Items.Clear();
                    this.Tab2CenterListBox.Enabled = false;
                    this.Tab2RightListBox.Enabled = false;

                    this.Tab2RadioButton104.Text = string.Empty;
                    this.Tab2RadioButton109.Text = string.Empty;
                    this.Tab2RadioButton104.Enabled = false;
                    this.Tab2RadioButton109.Enabled = false;
                    this.Tab2RadioButton104.Visible = false;
                    this.Tab2RadioButton109.Visible = false;

                    this.Tab2NextButton.Text = "次";

                    this.Tab3LeftLabel.Text = "親キーマップ名";
                    this.Tab3LeftCheckedListBox.Items.Clear();
                    this.Tab3LeftCheckedListBox.Items.AddRange(keymapGlobal);


                    this.Tab3CenterLabel.Text = string.Empty;
                    this.Tab3RightLabel.Text = string.Empty;
                    this.Tab3CenterListBox.Items.Clear();
                    this.Tab3RightListBox.Items.Clear();
                    this.Tab3CenterListBox.Enabled = false;
                    this.Tab3RightListBox.Enabled = false;

                    this.Tab3AddModeCheckBox.Text = string.Empty;
                    this.Tab3AddModeCheckBox.Enabled = false;
                    this.Tab3AddModeCheckBox.Visible = false;
                    break;

                case 1:     // key
                    // tab2
                    this.tabControl1.TabPages[1].Text = "変更前のキーバインド";
                    this.tabControl1.TabPages[2].Text = "変更後のキーバインド";
                    this.Tab2LeftLabel.Text = "モディファイヤ";
                    this.Tab2CenterLabel.Text = "キーの種類";
                    this.Tab2RightLabel.Text = "キー";
                    this.Tab2AsterCheckBox.Text = "他のモディファイヤを無視";
                    this.Tab2RadioButton104.Text = "101/104";
                    this.Tab2RadioButton109.Text = "106/109";
                    Reg104Read();
                    this.Tab3LeftLabel.Text = "モディファイヤ";
                    this.Tab3CenterLabel.Text = "キーの種類";
                    this.Tab3RightLabel.Text = "キー";
                    this.Tab3AddModeCheckBox.Text = "追加モード";
                    this.Tab3AddModeCheckBox.Enabled = true;
                    this.Tab2NextButton.Text = "次";


                    if (Global_Val.firstView == true)   // 下記、本当にfirstViewの時に必要な処理だけにして、残りは上にあげる。
                    {
                        Global_Val.firstView = false;
                        this.Tab2AsterCheckBox.Enabled = true;
                        this.Tab2AsterCheckBox.Checked = true;
                        this.Tab2AsterCheckBox.Visible = true;

                        Global_Val.aster = "*";

                        Reg104Read();

                        this.Tab2LeftCheckedListBox.Items.Clear();
                        this.Tab2LeftCheckedListBox.Items.AddRange(mods_list);
                        //this.checkedListBox1.SetSelected(0, true);      // 初期状態では「無し」をチェックする。
                        //this.checkedListBox1.SetItemChecked(0, true);   // 同様

                        this.Tab2CenterListBox.Enabled = true;
                        this.Tab2RightListBox.Enabled = true;

                        this.Tab2CenterListBox.Items.Clear();
                        this.Tab2RightListBox.Items.Clear();
                        if (this.Tab2RadioButton104.Checked == true)
                        {                                                   // 101/104
                            this.Tab2CenterListBox.Items.AddRange(key_cat104);
                            this.Tab2CenterListBox.SetSelected(0, true);             // 初期状態では「英字」をチェックする。
                            this.Tab2RightListBox.Items.AddRange(key_104[0]);       // 0「英字」をloadする。
                        }
                        else
                        {                                                   // 106/109
                            this.Tab2CenterListBox.Items.AddRange(key_cat109);
                            this.Tab2CenterListBox.SetSelected(0, true);             // 初期状態では「英字」をチェックする。
                            this.Tab2RightListBox.Items.AddRange(key_109[0]);       // 0「英字」をloadする。
                        }

                        // tab3
                        this.Tab3LeftCheckedListBox.Items.Clear();
                        this.Tab3LeftCheckedListBox.Items.AddRange(mods_list);
                        //this.checkedListBox2.SetSelected(0, true);      // 初期状態では「無し」をチェックする。
                        //this.checkedListBox2.SetItemChecked(0, true);   // 同様

                        this.Tab3CenterListBox.Enabled = true;
                        this.Tab3RightListBox.Enabled = true;

                        this.Tab3CenterListBox.Items.Clear();
                        this.Tab3RightListBox.Items.Clear();

                        if (this.Tab2RadioButton104.Checked == true)
                        {                                                   // 101/104
                            this.Tab3CenterListBox.Items.AddRange(key_cat104);
                            this.Tab3CenterListBox.SetSelected(0, true);             // 初期状態では「英字」をチェックする。
                            this.Tab3RightListBox.Items.AddRange(key_104[0]);       // 0「英字」をloadする。
                        }
                        else
                        {
                            this.Tab3CenterListBox.Items.AddRange(key_cat109);
                            this.Tab3CenterListBox.SetSelected(0, true);             // 初期状態では「英字」をチェックする。
                            this.Tab3RightListBox.Items.AddRange(key_109[0]);       // 0「英字」をloadする。
                        }

                        this.Tab3AddModeCheckBox.Checked = false;                 // 追加モードはクリア
                        if (FormMain.Global_Val.addMode == true)
                        {
                            this.Tab3AddModeCheckBox.Checked = true;              // ただし再Wizardで開いた時には、追加モードにする。
                        }

                        Global_Val.right_mod = string.Empty;                      // 初期化しておかないと追加モード時に一度も選択しないときに初期化されない。
                    }
                    break;
                case 2: // mod
                    // 必要なコントロールを有効にして、他は無効にすること。
                    // 文言も変更する必要がある。
                    this.tabControl1.TabPages[1].Text = "モディファイヤ種別の選択";
                    this.tabControl1.TabPages[2].Text = "モディファイヤに設定するキー";

                    this.Tab2LeftLabel.Text = string.Empty;;
                    this.Tab2LeftCheckedListBox.Items.Clear();
                    //this.Tab2LeftCheckedListBox.Items.AddRange(keymapGlobal);

                    this.Tab2AsterCheckBox.Text = string.Empty;
                    this.Tab2AsterCheckBox.Enabled = false;
                    this.Tab2AsterCheckBox.Visible = false;

                    this.Tab2CenterLabel.Text = "モディファイヤ";
                    this.Tab2RightLabel.Text = string.Empty;
                    this.Tab2CenterListBox.Items.Clear();
                    this.Tab2CenterListBox.Items.AddRange(modifier);
                    this.Tab2RightListBox.Items.Clear();
                    this.Tab2RightListBox.Items.AddRange(modifier_mode_name);

                    this.Tab2CenterListBox.Enabled = true;
                    this.Tab2RightListBox.Enabled = true;

                    this.Tab2RadioButton104.Text = "101/104";
                    this.Tab2RadioButton109.Text = "106/109";
                    Reg104Read();

                    this.Tab2NextButton.Text = "次";

                    this.Tab3LeftLabel.Text = "モディファイヤ種別";
                    this.Tab3LeftCheckedListBox.Items.Clear();
                    this.Tab3LeftCheckedListBox.Items.AddRange(modifier_cat_name);


                    this.Tab3CenterLabel.Text = string.Empty;
                    this.Tab3RightLabel.Text = string.Empty;
                    this.Tab3CenterListBox.Items.Clear();
                    this.Tab3RightListBox.Items.Clear();
                    this.Tab3CenterListBox.Enabled = true;
                    this.Tab3RightListBox.Enabled = true;

                    this.Tab3AddModeCheckBox.Text = string.Empty;
                    this.Tab3AddModeCheckBox.Enabled = false;
                    this.Tab3AddModeCheckBox.Visible = false;

                    if (this.Tab2RadioButton104.Checked == true)
                    {                                                   // 101/104
                        this.Tab3CenterListBox.Items.AddRange(key_cat104);
                        this.Tab3CenterListBox.SetSelected(0, true);             // 初期状態では「英字」をチェックする。
                        this.Tab3RightListBox.Items.AddRange(key_104[0]);       // 0「英字」をloadする。
                    }
                    else
                    {
                        this.Tab3CenterListBox.Items.AddRange(key_cat109);
                        this.Tab3CenterListBox.SetSelected(0, true);             // 初期状態では「英字」をチェックする。
                        this.Tab3RightListBox.Items.AddRange(key_109[0]);       // 0「英字」をloadする。
                    }

                    break;
                case 3: // window
                    break;
                case 4: // include
                    // ファイル名選択ボタンを有効にして見えるようにする。
                    this.SelectFileButton.Enabled = true;
                    this.SelectFileButton.Visible = true;

                    this.tabControl1.TabPages[1].Text = "読み込ませるファイル名";
                    this.tabControl1.TabPages[2].Text = String.Empty;
                    this.Tab2LeftLabel.Text = String.Empty;
                    this.Tab2CenterLabel.Text = "デフォルト設定ファイル";
                    this.Tab2RightLabel.Text = String.Empty;

                    this.Tab2AsterCheckBox.Text = String.Empty;
                    this.Tab2AsterCheckBox.Enabled = false;
                    this.Tab2AsterCheckBox.Checked = false;
                    this.Tab2AsterCheckBox.Visible = false;

                    this.Tab2LeftCheckedListBox.Enabled = false;
                    this.Tab2LeftCheckedListBox.Items.Clear();
                    this.Tab2CenterListBox.Enabled = true;
                    this.Tab2CenterListBox.Items.Clear();
                    this.Tab2CenterListBox.Items.AddRange(includeFileList);
                    this.Tab2RightListBox.Enabled = false;
                    this.Tab2RightListBox.Items.Clear();

                    this.Tab2NextButton.Text = "OK";

                    this.Tab2RadioButton104.Text = String.Empty;
                    this.Tab2RadioButton109.Text = String.Empty;
                    this.Tab2RadioButton109.Checked = false;
                    this.Tab2RadioButton104.Enabled = false;
                    this.Tab2RadioButton109.Enabled = false;
                    this.Tab2RadioButton104.Visible = false;
                    this.Tab2RadioButton109.Visible = false;

                    this.Tab3LeftLabel.Text = String.Empty;
                    this.Tab3CenterLabel.Text = String.Empty;
                    this.Tab3RightLabel.Text = String.Empty;

                    this.Tab3LeftCheckedListBox.Enabled = false;
                    this.Tab3LeftCheckedListBox.Items.Clear();
                    this.Tab3CenterListBox.Enabled = false;
                    this.Tab3CenterListBox.Items.Clear();
                    this.Tab3RightListBox.Enabled = false;
                    this.Tab3RightListBox.Items.Clear();

                    this.Tab3AddModeCheckBox.Text = String.Empty;
                    this.Tab3AddModeCheckBox.Enabled = false;
                    this.Tab3AddModeCheckBox.Visible = false;

                    break;
                case 5: // def option
                    break;
                case 6: // def key
                    break;
                case 7: // other
                    break;
                default:
                    break;
            }

        }

        // tabPage2 の実装
        private void Tab2LeftCheckedListBoxItemCheck(object sender, EventArgs e)
        {
            Global_Val.left_mod = String.Empty;
            switch (Global_Val.commandNumber)
            {
                case 0: // keymap
                    if (Tab2LeftCheckedListBox.GetItemChecked(0))
                    {
                        Debug.WriteLine(Tab2LeftCheckedListBox.GetItemChecked(0).ToString());
                        Global_Val.left_mod += "Global";
                    }
                    break;
                case 1: // key
                    for (int i = 0; i < Tab2LeftCheckedListBox.Items.Count; i++)
                    {
                        if (Tab2LeftCheckedListBox.GetItemChecked(i))
                        {
                            Debug.WriteLine(Tab2LeftCheckedListBox.GetItemChecked(i).ToString());
                            Global_Val.left_mod += mods_text[i];
                        }
                    }
                    break;
                default:
                    break;
            }
            SetLeftEditBox();
        }

        // tab2のcenter
        private void Tab2CenterListBoxItemCheck(object sender, EventArgs e)
        {
            switch (Global_Val.commandNumber)
            {
                case 1: // key
                    this.Tab2RightListBox.Items.Clear();
                    if (this.Tab2RadioButton104.Checked == true)
                    {
                        this.Tab2RightListBox.Items.AddRange(key_104[Tab2CenterListBox.SelectedIndex]);       // Centerのチェック位置でRightのlistBoxロードし直す。
                    }
                    else
                    {
                        this.Tab2RightListBox.Items.AddRange(key_109[Tab2CenterListBox.SelectedIndex]);       // Centerのチェック位置でRightのlistBoxロードし直す。
                    }
                    break;
                case 2: // mod
                    Global_Val.left_mod = this.Tab2CenterListBox.Text;
                    SetLeftEditBox();
                    break;
                case 4: // include
                    Global_Val.left_mod = this.Tab2CenterListBox.Text;
                    SetLeftEditBox();
                    break;
            }

        }

        // tab2のright
        private void Tab2RightListBoxItemCheck(object sender, EventArgs e)
        {
            switch (Global_Val.commandNumber)
            {
                case 1: // key
                    //Debug.WriteLine(" {3}", listBox3.SelectedIndex.ToString());
                    if (this.Tab2RadioButton104.Checked == true)
                    {
                        string[] tempString = key_104[Tab2CenterListBox.SelectedIndex][Tab2RightListBox.SelectedIndex].Split(' ');
                        Global_Val.left_key = tempString[0];
                    }
                    else
                    {
                        string[] tempString = key_109[Tab2CenterListBox.SelectedIndex][Tab2RightListBox.SelectedIndex].Split(' ');
                        Global_Val.left_key = tempString[0];
                    }
                    SetLeftEditBox();
                    break;
                case 2: // mod
                    Global_Val.left_key = modifier_mode[Tab2RightListBox.SelectedIndex];
                    SetLeftEditBox();
                    break;
            }
        }

        // modifierにおける * の設定
        private void Tab2AsterCheckBoxCheckd(object sender, EventArgs e)
        {
            Global_Val.aster = string.Empty;
            if (this.Tab2AsterCheckBox.Checked == true)
            {
                Global_Val.aster = "*";
            }
            SetLeftEditBox();
        }

        // tabPage2の EditBox更新
        private void SetLeftEditBox()
        {
            switch (Global_Val.commandNumber)
            {
                case 0: // keymap
                    this.Tab2NewTextBox.Text = "keymap " + Global_Val.left_mod;
                    break;
                case 1: // key
                    this.Tab2NewTextBox.Text = "key " + Global_Val.left_mod + Global_Val.aster + Global_Val.left_key;
                    break;
                case 2: // mod
                    this.Tab2NewTextBox.Text = "mod " + Global_Val.left_mod + " " + Global_Val.left_key;
                    break;
                case 4: // include
                    this.Tab2NewTextBox.Text = "include \"" + Global_Val.left_mod + "\"";
                    break;
            }
        }

        // tabPage3 の実装
        private void Tab3LeftCheckedListBoxItemCheck(object sender, EventArgs e)
        {
            bool addMode = true;
            switch (Global_Val.commandNumber)
            {
                case 0:
                    Global_Val.right_mod = string.Empty;
                    addMode = false;
                    if (Tab3LeftCheckedListBox.GetItemChecked(0))
                    {
                        Debug.WriteLine(Tab3LeftCheckedListBox.GetItemChecked(0).ToString());
                        Global_Val.right_mod += ": Global";
                    }
                    SetRightEditBox(addMode);
                    break;

                case 1:
                    addMode = this.Tab3AddModeCheckBox.Checked;
                    Global_Val.right_mod = string.Empty;
                    for (int i = 0; i < Tab3LeftCheckedListBox.Items.Count; i++)
                    {
                        if (Tab3LeftCheckedListBox.GetItemChecked(i))
                        {
                            Debug.WriteLine(Tab3LeftCheckedListBox.GetItemChecked(i).ToString());
                            Global_Val.right_mod += mods_text[i];
                        }
                    }
                    if (addMode == false)       // 追加モードの時には、まだ変更しない。
                    {
                        SetRightEditBox(addMode);
                    }
                    break;

                case 2: // mod
                    // checkboxだが単一選択にする。
                    int currentIndex = Tab3LeftCheckedListBox.SelectedIndex;
                    if (Tab3LeftCheckedListBox.GetItemChecked(currentIndex))    // checkされた?
                    {
                        for (int i = 0; i < Tab3LeftCheckedListBox.Items.Count; i++)
                        {
                            if (i != currentIndex)
                            {
                                Tab3LeftCheckedListBox.SetItemChecked(i, false);
                            }
                        }
                    }
                    Global_Val.right_mod = modifier_cat[Tab3LeftCheckedListBox.SelectedIndex];
                    SetRightEditBox(false);
                    break;

                default:
                    break;
            }
        }

        // tabPage3のcenter
        private void Tab3CenterListBoxItemCheck(object sender, EventArgs e)
        {
            this.Tab3RightListBox.Items.Clear();
            if (this.Tab2RadioButton104.Checked == true)
            {
                this.Tab3RightListBox.Items.AddRange(key_104[Tab3CenterListBox.SelectedIndex]);       // Centerのチェック位置でRightのlistBoxロードし直す。
            }
            else
            {
                this.Tab3RightListBox.Items.AddRange(key_109[Tab3CenterListBox.SelectedIndex]);       // Centerのチェック位置でRightのlistBoxロードし直す。
            }
        }

        // tabPage3のright
        private void Tab3RightListBoxItemCheck(object sender, EventArgs e)
        {
            switch (Global_Val.commandNumber)
            {
                case 1: // key
                case 2: // mod
                    bool addMode = this.Tab3AddModeCheckBox.Checked;
                    //Debug.WriteLine(" {3}", listBox3.SelectedIndex.ToString());
                    if (this.Tab2RadioButton104.Checked == true)
                    {
                        string[] tempString = key_104[Tab3CenterListBox.SelectedIndex][Tab3RightListBox.SelectedIndex].Split(' ');
                        Global_Val.right_key = tempString[0];
                    }
                    else
                    {
                        string[] tempString = key_109[Tab3CenterListBox.SelectedIndex][Tab3RightListBox.SelectedIndex].Split(' ');
                        Global_Val.right_key = tempString[0];
                    }

                    SetRightEditBox(addMode);
                    break;

            }
        }

        // modifierにおける * の設定
        /*private void AsterCheckd2(object sender, EventArgs e)
        {
            Global_Val.aster = string.Empty;
            if (this.checkBox1.Checked == true)
            {
                Global_Val.aster = "*";
            }
            SetLeftEditBox();
        }
        */

        // tabPage3の EditBox更新
        private void SetRightEditBox(bool addMode)
        {
            switch (Global_Val.commandNumber)
            {
                case 0: // keymap
                    this.Tab3NewTextBox.Text = Global_Val.right_mod;
                    break;
                case 1: // key
                    if (addMode == false)
                    {
                        this.Tab3NewTextBox.Text = "= " + Global_Val.right_mod + Global_Val.right_key;
                    }
                    else
                    {
                        this.Tab3NewTextBox.Text = this.Tab3NewTextBox.Text + " " + Global_Val.right_mod + Global_Val.right_key;
                    }
                    break;
                case 2: // mod
                    this.Tab3NewTextBox.Text = "= " + Global_Val.right_mod + Global_Val.right_key;
                    break;
            }
        }

        private void Tab2RadioButton104_CheckedChanged(object sender, EventArgs e)
        {
            // 101/104 RadioButtonの状態変更
            // 現状 コマンド key, modだけ、このRadioButtonは有効。
            this.Tab2CenterListBox.Items.Clear();
            this.Tab2RightListBox.Items.Clear();
            this.Tab3CenterListBox.Items.Clear();
            this.Tab3RightListBox.Items.Clear();

            if (this.Tab2RadioButton104.Checked == true)
            {                                                               // 101/104
                this.Tab2CenterListBox.Items.AddRange(key_cat104);
                this.Tab2CenterListBox.SetSelected(0, true);                // 初期状態では「英字」をチェックする。
                this.Tab2RightListBox.Items.AddRange(key_104[0]);           // 0「英字」をloadする。
                this.Tab3CenterListBox.Items.AddRange(key_cat104);
                this.Tab3CenterListBox.SetSelected(0, true);                // 初期状態では「英字」をチェックする。
                this.Tab3RightListBox.Items.AddRange(key_104[0]);           // 0「英字」をloadする。
                setRegbUser104(true);
            }
            else
            {                                                               // 106/109
                this.Tab2CenterListBox.Items.AddRange(key_cat109);
                this.Tab2CenterListBox.SetSelected(0, true);                // 初期状態では「英字」をチェックする。
                this.Tab2RightListBox.Items.AddRange(key_109[0]);           // 0「英字」をloadする。
                this.Tab3CenterListBox.Items.AddRange(key_cat109);
                this.Tab3CenterListBox.SetSelected(0, true);                // 初期状態では「英字」をチェックする。
                this.Tab3RightListBox.Items.AddRange(key_109[0]);           // 0「英字」をloadする。
                setRegbUser104(false);
            }
        }

        private void SelectFileButton_Click(object sender, EventArgs e)
        {
            // File Open Dialog
            string file_name;

            OpenFileDialog OF_Dialog = new OpenFileDialog();
            OF_Dialog.FileName = string.Empty;
            OF_Dialog.InitialDirectory = Environment.GetFolderPath(Environment.SpecialFolder.UserProfile);
            OF_Dialog.Filter =
                "nodokaファイル(*.nodoka;*.mayu)|*.nodoka;*.mayu|すべてのファイル(*.*)|*.*";
            OF_Dialog.FilterIndex = 1;
            OF_Dialog.Title = "include文の引数として指定するファイルを選択してください";
            OF_Dialog.RestoreDirectory = true;
            OF_Dialog.CheckFileExists = true;
            OF_Dialog.CheckPathExists = true;

            if (OF_Dialog.ShowDialog() == DialogResult.OK)
            {
                // file name取得
                file_name = Path.GetFileName(OF_Dialog.FileName);

                this.Tab2CenterListBox.ClearSelected(); // 選択されているものは解除
                // set left_mod
                Global_Val.left_mod = file_name;
                SetLeftEditBox();
            }
        }

        private void tabPage2_Click(object sender, EventArgs e)
        {

        }
    }
}
