package org.mineap.nndd.player
{
	import flash.events.AsyncErrorEvent;
	import flash.events.Event;
	import flash.events.IOErrorEvent;
	import flash.events.TimerEvent;
	import flash.filesystem.File;
	import flash.media.Video;
	import flash.net.NetConnection;
	import flash.net.NetStream;
	import flash.utils.Timer;
	import flash.utils.flash_proxy;
	
	import mx.collections.ArrayCollection;
	import mx.controls.SWFLoader;
	
	import org.mineap.nicovideo4as.model.Comment;
	import org.mineap.nicovideo4as.model.VideoType;
	import org.mineap.nndd.LogManager;
	import org.mineap.nndd.NNDDDownloader;
	import org.mineap.nndd.android.library.LibraryManager;
	import org.mineap.nndd.android.nnddServer.NNDDServerInfoManager;
	import org.mineap.nndd.android.user.UserManager;
	import org.mineap.nndd.model.NNDDVideo;
	import org.mineap.nndd.player.comment.CommentManager;
	import org.mineap.nndd.player.comment.Comments;
	import org.mineap.nndd.util.PathMaker;
	
	import spark.primitives.Path;
	
	import views.player.VideoPlayView;

	public class PlayerController
	{
		
		private var videoPlayView:VideoPlayView;
		
		private var nnddDownloader:NNDDDownloader = null;
		
		private var ngListManager:NGListManager = null;
		
		private var commentTimer:Timer = null;
		
		private var commentManager:CommentManager = null;
		
		private var commentTimerVpos:Number = 0;
		
		private var time:Number = 0;
		
		// ----動画再生オブジェクト----
		// video
		private var video:Video;
		private var netStream:NetStream;
		
		// swf
		private var swfLoader:SWFLoader;
		
		public function PlayerController(targetView:VideoPlayView)
		{
			
			this.videoPlayView = targetView;
			
			this.ngListManager = new NGListManager();
			
			this.videoPlayView.videoController.addEventListener("startButtonClickedEvent", startButtonClicked);
			this.videoPlayView.videoController.addEventListener("stopButtonClickedEvent", stopButtonClicked);
		}
		
		protected function stopButtonClicked(event:Event):void
		{
			trace(event);
			
			commentTimer.stop();
			commentTimer.reset();
			commentTimerVpos = 0;
			
			if (video != null && netStream != null)
			{
				// 一時停止して先頭に戻す
				netStream.pause();
				netStream.seek(0);
			}
			else if (swfLoader != null)
			{
				
			}
			
		}
		
		protected function startButtonClicked(event:Event):void
		{
			trace(event);
			
			if (commentTimer.running)
			{
				commentTimer.stop();
				commentTimer.reset();
			}
			else
			{
				commentTimer.start();
			}
			
			if (video != null && netStream != null)
			{
				// 再生/一時停止 の切り替え
				netStream.togglePause();
			}
			else if (swfLoader != null)
			{
				
			}
			
		}
		
		public function play(video:NNDDVideo):void
		{
			if (nnddDownloader != null)
			{
				nnddDownloader.close(true, false);
				nnddDownloader = null;
			}
			
			commentTimerVpos = 0;
			
			var url:String = video.getDecodeUrl();
			var videoId:String = url.substr(url.lastIndexOf("/") + 1);
			
			var nnddServerAddress:String = NNDDServerInfoManager.instance.nnddServerAddress;
			var nnddServerPort:int = NNDDServerInfoManager.instance.nnddServerPort;
			
			nnddDownloader = new NNDDDownloader();
			if (nnddServerAddress != null && nnddServerAddress.length > 0 && nnddServerPort > 0)
			{
				nnddDownloader._isEnableGetVideoFromOtherNNDDServer = true;
				nnddDownloader._otherNNDDServerAddress = nnddServerAddress;
				nnddDownloader._otherNNDDServerPort = nnddServerPort;
			}
			nnddDownloader.addEventListener(NNDDDownloader.DOWNLOAD_PROCESS_COMPLETE, downloadProcessCompleteListener);
			
			nnddDownloader.addEventListener(NNDDDownloader.COMMENT_GET_START, getProgressListener);
			nnddDownloader.addEventListener(NNDDDownloader.GETFLV_API_ACCESS_START, getProgressListener);
			nnddDownloader.addEventListener(NNDDDownloader.ICHIBA_INFO_GET_START, getProgressListener);
			nnddDownloader.addEventListener(NNDDDownloader.LOGIN_START, getProgressListener);
			nnddDownloader.addEventListener(NNDDDownloader.NICOWARI_GET_START, getProgressListener);
			nnddDownloader.addEventListener(NNDDDownloader.OWNER_COMMENT_GET_START, getProgressListener);
			nnddDownloader.addEventListener(NNDDDownloader.THUMB_IMG_GET_START, getProgressListener);
			nnddDownloader.addEventListener(NNDDDownloader.THUMB_INFO_GET_START, getProgressListener);
			nnddDownloader.addEventListener(NNDDDownloader.VIDEO_GET_START, getProgressListener);
			nnddDownloader.addEventListener(NNDDDownloader.WATCH_START, getProgressListener);
			nnddDownloader.addEventListener(NNDDDownloader.REMOTE_NNDD_SERVER_ACCESS_SUCCESS, getProgressListener);
			
			nnddDownloader.addEventListener(NNDDDownloader.COMMENT_GET_SUCCESS, getProgressListener);
			nnddDownloader.addEventListener(NNDDDownloader.GETFLV_API_ACCESS_SUCCESS, getProgressListener);
			nnddDownloader.addEventListener(NNDDDownloader.ICHIBA_INFO_GET_SUCCESS, getProgressListener);
			nnddDownloader.addEventListener(NNDDDownloader.LOGIN_SUCCESS, getProgressListener);
			nnddDownloader.addEventListener(NNDDDownloader.NICOWARI_GET_SUCCESS, getProgressListener);
			nnddDownloader.addEventListener(NNDDDownloader.OWNER_COMMENT_GET_SUCCESS, getProgressListener);
			nnddDownloader.addEventListener(NNDDDownloader.THUMB_IMG_GET_SUCCESS, getProgressListener);
			nnddDownloader.addEventListener(NNDDDownloader.THUMB_INFO_GET_SUCCESS, getProgressListener);
			nnddDownloader.addEventListener(NNDDDownloader.VIDEO_GET_SUCCESS, getProgressListener);
			nnddDownloader.addEventListener(NNDDDownloader.WATCH_SUCCESS, getProgressListener);
			nnddDownloader.addEventListener(NNDDDownloader.DOWNLOAD_PROCESS_COMPLETE, getProgressListener);
			
			nnddDownloader.addEventListener(NNDDDownloader.COMMENT_GET_FAIL, getFailListener);
			nnddDownloader.addEventListener(NNDDDownloader.GETFLV_API_ACCESS_FAIL, getFailListener);
			nnddDownloader.addEventListener(NNDDDownloader.ICHIBA_INFO_GET_FAIL, getFailListener);
			nnddDownloader.addEventListener(NNDDDownloader.LOGIN_FAIL, getFailListener);
			nnddDownloader.addEventListener(NNDDDownloader.NICOWARI_GET_FAIL, getFailListener);
			nnddDownloader.addEventListener(NNDDDownloader.OWNER_COMMENT_GET_FAIL, getFailListener);
			nnddDownloader.addEventListener(NNDDDownloader.THUMB_IMG_GET_FAIL, getFailListener);
			nnddDownloader.addEventListener(NNDDDownloader.THUMB_INFO_GET_FAIL, getFailListener);
			nnddDownloader.addEventListener(NNDDDownloader.VIDEO_GET_FAIL, getFailListener);
			nnddDownloader.addEventListener(NNDDDownloader.WATCH_FAIL, getFailListener);
			nnddDownloader.addEventListener(NNDDDownloader.DOWNLOAD_PROCESS_ERROR, streamingPlayFailListener);
			nnddDownloader.addEventListener(NNDDDownloader.DOWNLOAD_PROCESS_CANCELD, streamingPlayFailListener);
			nnddDownloader.requestDownloadForStreaming(UserManager.instance.user, 
				UserManager.instance.password, 
				videoId, 
				LibraryManager.instance.tempDir, 
				false,
				false);
		}
		
		/**
		 * 動画取得成功時に呼ばれるリスナ
		 * @param event
		 * 
		 */
		protected function downloadProcessCompleteListener(event:Event):void
		{
			
			videoPlayView.title = (event.target as NNDDDownloader).nicoVideoName;
			
			videoPlayView.label_downloadStatus.visible = false;
			videoPlayView.label_downloadStatus.text = null;
			
			var url:String = (event.target as NNDDDownloader).videoUrl;
			
			
			// 再生領域の生成
			if (VideoType.VIDEO_TYPE_FLV == (event.target as NNDDDownloader).videoType 
					|| VideoType.VIDEO_TYPE_MP4 == (event.target as NNDDDownloader).videoType)
			{
				initVideo(url);
				initComment(nnddDownloader);
			}
			else if (VideoType.VIDEO_TYPE_SWF == (event.target as NNDDDownloader).videoType)
			{
				initSwf(url);
				initComment(nnddDownloader);
			}
			
		}
		
		protected function initVideo(url:String):void
		{
			var video:Video = new Video();
			
			var connection:NetConnection = new NetConnection();
			connection.connect(null);
			
			var netStream:NetStream = new NetStream(connection);
			netStream.addEventListener(AsyncErrorEvent.ASYNC_ERROR, asyncErrorEventListener);
			netStream.client = new Object();
			
			video.attachNetStream(netStream);
			video.addEventListener(Event.ENTER_FRAME, videoEnterFrameEventListener);
			netStream.play(url);
			
			if (this.video != null)
			{
				try {
					videoPlayView.videoPlayArea.removeChild(video);
				}catch (e:RangeError)
				{
					trace(e);
				}
			}
			
			this.netStream = netStream;
			this.video = video;
			
			videoPlayView.videoPlayArea.addChild(video);
			video.width = videoPlayView.width;
			video.height = videoPlayView.height;
		}
		
		protected function initComment(nnddDownloader:NNDDDownloader):void
		{
		
			var videoFile:File = nnddDownloader.savedVideoPath;			
			var savedDir:File = videoFile.parent;
			
			this.commentManager = new CommentManager(this, this.videoPlayView.videoPlayArea);
			
			var comments:Comments = new Comments(
				PathMaker.createNomalCommentPathByVideoPath(savedDir.url + "/nndd.flv"), 
				PathMaker.createOwnerCommentPathByVideoPath(savedDir.url + "/nndd.flv"), 
				new ArrayCollection(), 
				new ArrayCollection(), 
				this.ngListManager, 
				false, 
				false, 
				500,
				500,
				true, 
				null);
			
			this.commentManager.initComment(comments, this.videoPlayView.videoPlayArea);
			this.commentManager.setCommentAlpha(1);
			this.commentManager.adjustCommentHight();
			
			this.time = new Date().time;
			
			commentTimer = new Timer(100, 0);
			commentTimer.addEventListener(TimerEvent.TIMER, commentUppterTimerEventListener);
			commentTimer.start();
			
		}
		
		protected function commentUppterTimerEventListener(event:TimerEvent):void
		{
			var tempTime:Number = (new Date).time;
			
			this.commentTimerVpos += (tempTime - this.time);
			
			this.commentManager.setComment(commentTimerVpos, (tempTime - this.time)*3, true, true);
			this.commentManager.moveComment(tempTime/1000 - this.time/1000, 3);
			this.commentManager.removeComment(commentTimerVpos, 3000);
			
			this.time = tempTime;
			
		}
		
		protected function videoEnterFrameEventListener(event:Event):void
		{
			
			if (video == null || netStream == null)
			{
				return;
			}
			
			// 秒
			var currentTime:int = netStream.time;
			
			var allSec:String="00",allMin:String="0";
			var nowSec:String="00",nowMin:String="0";
			
			nowSec = String(int(currentTime%60));
			nowMin = String(int(currentTime/60));
			
//			allSec = String(int(this.videoDisplay.duration%60));
//			allMin = String(int(this.videoDisplay.duration/60));
			
			if(nowSec.length == 1){
				nowSec = "0" + nowSec;
			}
			if(allSec.length == 1){
				allSec = "0" + allSec;
			}
			this.videoPlayView.videoController.updateTimeLabel(nowMin + ":" + nowSec + "/" + allMin + ":" + allSec);
		}
		
		protected function asyncErrorEventListener(event:AsyncErrorEvent):void
		{
			trace(event);
		}
		
		protected function initSwf(url:String):void
		{
			try {
				videoPlayView.videoPlayArea.removeChildAt(0);
			}catch (e:RangeError)
			{
			}
		}
		
		/**
		 * 動画の再生および動画のDL処理を停止します。
		 * 
		 */
		public function stop():void
		{
			if (nnddDownloader != null)
			{
				nnddDownloader.close(false, false);
				nnddDownloader = null;
			}
			
			if (video != null)
			{
				netStream.pause();
				netStream = null;

				video.attachNetStream(null);
			}
			else if(swfLoader != null)
			{
				
			}
			
		}
		
		/**
		 * 
		 * @param event
		 * 
		 */
		public function getProgressListener(event:Event):void{
			var status:String = null;
			if(event.type == NNDDDownloader.LOGIN_SUCCESS){
				status = "成功";
			}else if(event.type == NNDDDownloader.WATCH_SUCCESS){
				status = "成功";
			}else if(event.type == NNDDDownloader.GETFLV_API_ACCESS_SUCCESS){
				status = "成功";
			}else if(event.type == NNDDDownloader.COMMENT_GET_SUCCESS){
				status = "成功";
			}else if(event.type == NNDDDownloader.OWNER_COMMENT_GET_SUCCESS){
				status = "成功";
			}else if(event.type == NNDDDownloader.NICOWARI_GET_SUCCESS){
				status = "成功";
			}else if(event.type == NNDDDownloader.THUMB_INFO_GET_SUCCESS){
				status = "成功";
			}else if(event.type == NNDDDownloader.THUMB_IMG_GET_SUCCESS){
				status = "成功";
			}else if(event.type == NNDDDownloader.ICHIBA_INFO_GET_SUCCESS){
				status = "成功";
			}else if(event.type == NNDDDownloader.VIDEO_GET_SUCCESS){
				status = "成功";
			}
			
			if(event.type == NNDDDownloader.LOGIN_START){
				status = "ログインしています...";
			}else if(event.type == NNDDDownloader.WATCH_START){
				status = "動画ページにアクセスしています...";
			}else if(event.type == NNDDDownloader.GETFLV_API_ACCESS_START){
				status = "動画取得APIにアクセスしています...";
			}else if(event.type == NNDDDownloader.COMMENT_GET_START){
				status = "コメントを取得しています...";
			}else if(event.type == NNDDDownloader.OWNER_COMMENT_GET_START){
				status = "投稿者コメントを取得しています...";
			}else if(event.type == NNDDDownloader.NICOWARI_GET_START){
				status = "ニコ割を取得しています...";
			}else if(event.type == NNDDDownloader.THUMB_INFO_GET_START){
				status = "サムネイル情報を取得しています...";
			}else if(event.type == NNDDDownloader.THUMB_IMG_GET_START){
				status = "サムネイル画像を取得しています...";
			}else if(event.type == NNDDDownloader.ICHIBA_INFO_GET_START){
				status = "市場情報を取得しています...";
			}else if(event.type == NNDDDownloader.VIDEO_GET_START){
				status = "動画を取得しています...";
			}
			
			if (event.type == NNDDDownloader.REMOTE_NNDD_SERVER_ACCESS_SUCCESS)
			{
				status = "代替URLを使用(" + (event.currentTarget as NNDDDownloader).nnddServerVideoUrl + ")";
			} 
			
			trace(status);
			if ("成功" == status)
			{
				videoPlayView.label_downloadStatus.text = videoPlayView.label_downloadStatus.text + " " + status;
			}
			else
			{
				videoPlayView.label_downloadStatus.text = videoPlayView.label_downloadStatus.text + "\n\t" + status;
			}
		}
		
		/**
		 * 
		 * @param event
		 * 
		 */
		public function streamingPlayFailListener(event:Event):void{
			var tempStr:String = videoPlayView.label_downloadStatus.text;
			if(event.type == NNDDDownloader.DOWNLOAD_PROCESS_CANCELD){
				videoPlayView.label_downloadStatus.text = tempStr + "\n\nアクセスをキャンセルしました。";
				LogManager.instance.addLog("***ストリーミング再生をキャンセル***");
			}else if(event.type == NNDDDownloader.DOWNLOAD_PROCESS_ERROR){
				videoPlayView.label_downloadStatus.text = tempStr + "\n\n動画を取得できませんでした。\n" + (event as IOErrorEvent).text + "\n" + event;
				LogManager.instance.addLog(NNDDDownloader.DOWNLOAD_PROCESS_ERROR + ":" + event + ":" + (event as IOErrorEvent).text);
				LogManager.instance.addLog("***ストリーミング再生に失敗***");
			}
			stop();
			
			nnddDownloader == null;
			
		}
		
		/**
		 * 取得失敗系リスナー
		 * @param event
		 * 
		 */
		public function getFailListener(event:IOErrorEvent):void{
			var status:String = "";
			if(event.type == NNDDDownloader.LOGIN_FAIL){
				status = "ログイン失敗";
			}else if(event.type == NNDDDownloader.WATCH_FAIL){
				status = "動画ページアクセス失敗";
			}else if(event.type == NNDDDownloader.GETFLV_API_ACCESS_FAIL){
				status = "APIアクセス失敗";
			}else if(event.type == NNDDDownloader.COMMENT_GET_FAIL){
				status = "コメント取得失敗";
			}else if(event.type == NNDDDownloader.OWNER_COMMENT_GET_FAIL){
				status = "投稿者コメント取得失敗";
			}else if(event.type == NNDDDownloader.NICOWARI_GET_FAIL){
				status = "ニコ割取得失敗";
			}else if(event.type == NNDDDownloader.THUMB_INFO_GET_FAIL){
				status = "サムネイル情報取得失敗";
			}else if(event.type == NNDDDownloader.THUMB_IMG_GET_FAIL){
				status = "サムネイル画像取得失敗";
			}else if(event.type == NNDDDownloader.ICHIBA_INFO_GET_FAIL){
				status = "市場情報取得失敗";
			}else if(event.type == NNDDDownloader.VIDEO_GET_FAIL){
				status = "動画取得失敗";
			} 
			
			LogManager.instance.addLog("\t" + status + ":" + event.type + ":" + event.text);
			videoPlayView.label_downloadStatus.text =  videoPlayView.label_downloadStatus.text + "\n\t" + status;
		}
		
		public function jump(id:String, msg:String):void
		{
			// TODO Auto Generated method stub
			
		}
		
		public function seekOperation(param0:Number):void
		{
			// TODO Auto Generated method stub
			
		}
		
		public function playNicowari(nicowariVideoID:String, isPlay:int):void
		{
			// TODO Auto Generated method stub
			
		}
	}
}