package org.mineap.nndd.android.nnddServer
{
	import flash.errors.IllegalOperationError;
	
	import org.mineap.nndd.android.conf.ConfigManager;

	public class NNDDServerInfoManager
	{
		private static const manager:NNDDServerInfoManager = new NNDDServerInfoManager();
		
		public static const STORE_KEY_NNDD_SERVER_ADDRESS:String = "nnddServerAddress";
		public static const STORE_KEY_NNDD_SERVER_PORT:String = "nnddServerPort";
		
		private var _nnddServerAddress:String = null;
		private var _nnddServerPort:int = -1;
		
		public static function get instance():NNDDServerInfoManager
		{
			return manager;
		}

		public function NNDDServerInfoManager()
		{
			if (manager != null)
			{
				throw new IllegalOperationError("インスタンス化できません。");
			}
			
			_nnddServerAddress = ConfigManager.instance.getItem(STORE_KEY_NNDD_SERVER_ADDRESS);
			_nnddServerPort = int(ConfigManager.instance.getItem(STORE_KEY_NNDD_SERVER_PORT));
			
		}
		
		
		public function get nnddServerAddress():String
		{
			return _nnddServerAddress;
		}
		
		public function set nnddServerAddress(value:String):void
		{
			_nnddServerAddress = value;
			ConfigManager.instance.setItem(STORE_KEY_NNDD_SERVER_ADDRESS, _nnddServerAddress);
			ConfigManager.instance.save();
		}
		
		public function get nnddServerPort():int
		{
			return _nnddServerPort;
		}
		
		public function set nnddServerPort(value:int):void
		{
			_nnddServerPort = value;
			ConfigManager.instance.setItem(STORE_KEY_NNDD_SERVER_PORT, _nnddServerPort);
			ConfigManager.instance.save();
		}
		
	}
}