using System ;
using System.Collections.Generic ;
using System.Runtime.InteropServices ;
using System.Text ;


namespace DxLibDLL
{


	public static partial class DX
	{


	#if UNICODE
		[ StructLayout( LayoutKind.Sequential , CharSet = CharSet.Unicode ) ]
	#else
		[ StructLayout( LayoutKind.Sequential , CharSet = CharSet.Ansi ) ]
	#endif
		public struct POINT
		{

			public int x ;

			public int y ;

			public POINT( int x , int y )
			{
				this.x = x ;
				this.y = y ;
			}
		}


	#if UNICODE
		[ StructLayout( LayoutKind.Sequential , CharSet = CharSet.Unicode ) ]
	#else
		[ StructLayout( LayoutKind.Sequential , CharSet = CharSet.Ansi ) ]
	#endif
		public struct SIZE
		{

			public int cx ;

			public int cy ;

			public SIZE( int cx , int cy )
			{
				this.cx = cx ;
				this.cy = cy ;
			}
		}


	#if UNICODE
		[ StructLayout( LayoutKind.Sequential , CharSet = CharSet.Unicode ) ]
	#else
		[ StructLayout( LayoutKind.Sequential , CharSet = CharSet.Ansi ) ]
	#endif
		public struct RECT
		{

			public int left ;

			public int top ;

			public int right ;

			public int bottom ;

			public int x
			{
				get { return this.left ; }
			}

			public int y
			{
				get { return this.top ; }
			}

			public int cx
			{
				get { return this.right - this.left ; }
			}

			public int cy
			{
				get { return this.bottom - this.top ; }
			}

			public RECT( int left , int top , int right , int bottom )
			{
				this.left = left ;
				this.top = top ;
				this.right = right ;
				this.bottom = bottom ;
			}

			public RECT( POINT leftTop , POINT rightBottom )
			{
				this.left = leftTop.x ;
				this.top = leftTop.y ;
				this.right = rightBottom.x ;
				this.bottom = rightBottom.y ;
			}

			public RECT( POINT point , SIZE size )
			{
				this.left = point.x ;
				this.top = point.y ;
				this.right = size.cx ;
				this.bottom = size.cy ;
			}
		}


		/// <summary> hld͕̕`ɕKvȏ̓̕ߏ </summary>
	#if UNICODE
		[ StructLayout( LayoutKind.Sequential , CharSet = CharSet.Unicode ) ]
	#else
		[ StructLayout( LayoutKind.Sequential , CharSet = CharSet.Ansi ) ]
	#endif
		public struct IMEINPUTCLAUSEDATA
		{

			/// <summary> oCgڂ </summary>
			public int Position ;

			/// <summary> oCg </summary>
			public int Length ;
		}


		/// <summary> hld͕̕`ɕKvȏ </summary>
		public struct IMEINPUTDATA
		{

			/// <summary> ͒̕ </summary>
			public string InputString ;

			/// <summary> J[\͕̓񒆂̈ʒu(oCgP) </summary>
			public int CursorPosition ;

			/// <summary> ߏ </summary>
			public IMEINPUTCLAUSEDATA[] ClauseData ;

			/// <summary> I𒆂̕( -1 ̏ꍇ͂ǂ̕߂ɂĂȂ( ɃJ[\ ) ) </summary>
			public int SelectClause ;

			/// <summary> ϊ╶񃊃Xg( FԖڂ̌`悷ꍇ  DrawString( 0 , 0 , data.CandidateList[ n ] , GetColor(255 ,255 ,255) ); ) </summary>
			public string[] CandidateList ;

			/// <summary> I𒆂̕ϊ </summary>
			public int SelectCandidate ;
		}


		/// <summary> ʃ[hf[^^ </summary>
	#if UNICODE
		[ StructLayout( LayoutKind.Sequential , CharSet = CharSet.Unicode ) ]
	#else
		[ StructLayout( LayoutKind.Sequential , CharSet = CharSet.Ansi ) ]
	#endif
		public struct DISPLAYMODEDATA
		{

			/// <summary> 𑜓x </summary>
			public int Width ;

			/// <summary> 𑜓x </summary>
			public int Height ;

			/// <summary> Frbg[x </summary>
			public int ColorBitDepth ;

			/// <summary> tbV[g( -1 ̏ꍇ͋Kl ) </summary>
			public int RefreshRate ;
		}


		/// <summary> ^Cf[^^ </summary>
	#if UNICODE
		[ StructLayout( LayoutKind.Sequential , CharSet = CharSet.Unicode ) ]
	#else
		[ StructLayout( LayoutKind.Sequential , CharSet = CharSet.Ansi ) ]
	#endif
		public struct DATEDATA
		{

			/// <summary> N </summary>
			public int Year ;

			/// <summary>  </summary>
			public int Mon ;

			/// <summary>  </summary>
			public int Day ;

			/// <summary>  </summary>
			public int Hour ;

			/// <summary>  </summary>
			public int Min ;

			/// <summary> b </summary>
			public int Sec ;
		}


		/// <summary> t@C\ </summary>
	#if UNICODE
		[ StructLayout( LayoutKind.Sequential , CharSet = CharSet.Unicode ) ]
	#else
		[ StructLayout( LayoutKind.Sequential , CharSet = CharSet.Ansi ) ]
	#endif
		public struct FILEINFO
		{

			/// <summary> IuWFNg </summary>
			[ MarshalAs( UnmanagedType.ByValTStr , SizeConst = 260 ) ]
			public string Name ;

			/// <summary> fBNgǂ( TRUE:fBNg  FALSE:t@C ) </summary>
			public bool DirFlag ;

			/// <summary> TCY </summary>
			public long Size ;

			/// <summary> 쐬 </summary>
			public DATEDATA CreationTime ;

			/// <summary> ŏIXV </summary>
			public DATEDATA LastWriteTime ;
		}


		/// <summary> s\ </summary>
	#if UNICODE
		[ StructLayout( LayoutKind.Sequential , CharSet = CharSet.Unicode ) ]
	#else
		[ StructLayout( LayoutKind.Sequential , CharSet = CharSet.Ansi ) ]
	#endif
		public struct MATRIX
		{

			public float m_11 ;

			public float m_12 ;

			public float m_13 ;

			public float m_14 ;

			public float m_21 ;

			public float m_22 ;

			public float m_23 ;

			public float m_24 ;

			public float m_31 ;

			public float m_32 ;

			public float m_33 ;

			public float m_34 ;

			public float m_41 ;

			public float m_42 ;

			public float m_43 ;

			public float m_44 ;

			public MATRIX( float m_11 , float m_12 , float m_13 , float m_14 , float m_21 , float m_22 , float m_23 , float m_24 , float m_31 , float m_32 , float m_33 , float m_34 , float m_41 , float m_42 , float m_43 , float m_44 )
			{
				this.m_11 = m_11 ;
				this.m_12 = m_12 ;
				this.m_13 = m_13 ;
				this.m_14 = m_14 ;
				this.m_21 = m_21 ;
				this.m_22 = m_22 ;
				this.m_23 = m_23 ;
				this.m_24 = m_24 ;
				this.m_31 = m_31 ;
				this.m_32 = m_32 ;
				this.m_33 = m_33 ;
				this.m_34 = m_34 ;
				this.m_41 = m_41 ;
				this.m_42 = m_42 ;
				this.m_43 = m_43 ;
				this.m_44 = m_44 ;
			}
		}


		/// <summary> xNgf[^^ </summary>
	#if UNICODE
		[ StructLayout( LayoutKind.Sequential , CharSet = CharSet.Unicode ) ]
	#else
		[ StructLayout( LayoutKind.Sequential , CharSet = CharSet.Ansi ) ]
	#endif
		public struct VECTOR
		{

			public float x ;

			public float y ;

			public float z ;

			public VECTOR( float x , float y , float z )
			{
				this.x = x ;
				this.y = y ;
				this.z = z ;
			}
		}


		/// <summary> FLOAT2f[^^ </summary>
	#if UNICODE
		[ StructLayout( LayoutKind.Sequential , CharSet = CharSet.Unicode ) ]
	#else
		[ StructLayout( LayoutKind.Sequential , CharSet = CharSet.Ansi ) ]
	#endif
		public struct UV
		{

			public float u ;

			public float v ;

			public UV( float u , float v )
			{
				this.u = u ;
				this.v = v ;
			}
		}


		/// <summary> float ^̃J[l </summary>
	#if UNICODE
		[ StructLayout( LayoutKind.Sequential , CharSet = CharSet.Unicode ) ]
	#else
		[ StructLayout( LayoutKind.Sequential , CharSet = CharSet.Ansi ) ]
	#endif
		public struct COLOR_F
		{

			public float r ;

			public float g ;

			public float b ;

			public float a ;

			public COLOR_F( float r , float g , float b , float a )
			{
				this.r = r ;
				this.g = g ;
				this.b = b ;
				this.a = a ;
			}
		}


		/// <summary> unsigned char ^̃J[l </summary>
	#if UNICODE
		[ StructLayout( LayoutKind.Sequential , CharSet = CharSet.Unicode ) ]
	#else
		[ StructLayout( LayoutKind.Sequential , CharSet = CharSet.Ansi ) ]
	#endif
		public struct COLOR_U8
		{

			public byte b ;

			public byte g ;

			public byte r ;

			public byte a ;

			public static readonly COLOR_U8 Empty = new COLOR_U8( 0x00 , 0x00 , 0x00 , 0x00 ) ;

			public COLOR_U8( int argb )
			{
				this.b = ( byte )( ( argb >> 0 ) & 0xFF ) ;
				this.g = ( byte )( ( argb >> 8 ) & 0xFF ) ;
				this.r = ( byte )( ( argb >> 16 ) & 0xFF ) ;
				this.a = ( byte )( ( argb >> 24 ) & 0xFF ) ;
			}

			public COLOR_U8( int r , int g , int b )
			{
				this.b = ( byte )( b ) ;
				this.g = ( byte )( g ) ;
				this.r = ( byte )( r ) ;
				this.a = 0 ;
			}

			public COLOR_U8( int r , int g , int b , int a )
			{
				this.b = ( byte )( b ) ;
				this.g = ( byte )( g ) ;
				this.r = ( byte )( r ) ;
				this.a = ( byte )( a ) ;
			}

			public int ToInt()
			{
				return ( ( int )( this.a ) << 24 ) | ( ( int )( this.r ) << 16 ) | ( ( int )( this.g ) << 8 ) | ( ( int )( this.b ) << 0 ) ;
			}
		}


		/// <summary> FLOAT4f[^^ </summary>
	#if UNICODE
		[ StructLayout( LayoutKind.Sequential , CharSet = CharSet.Unicode ) ]
	#else
		[ StructLayout( LayoutKind.Sequential , CharSet = CharSet.Ansi ) ]
	#endif
		public struct FLOAT4
		{

			public float x ;

			public float y ;

			public float z ;

			public float w ;

			public FLOAT4( float x , float y , float z , float w )
			{
				this.x = x ;
				this.y = y ;
				this.z = z ;
				this.w = w ;
			}
		}


		/// <summary> INT4f[^^ </summary>
	#if UNICODE
		[ StructLayout( LayoutKind.Sequential , CharSet = CharSet.Unicode ) ]
	#else
		[ StructLayout( LayoutKind.Sequential , CharSet = CharSet.Ansi ) ]
	#endif
		public struct INT4
		{

			public int x ;

			public int y ;

			public int z ;

			public int w ;

			public INT4( int x , int y , int z , int w )
			{
				this.x = x ;
				this.y = y ;
				this.z = z ;
				this.w = w ;
			}
		}


		/// <summary> Qc`p_\(eNX`) </summary>
	#if UNICODE
		[ StructLayout( LayoutKind.Sequential , CharSet = CharSet.Unicode ) ]
	#else
		[ StructLayout( LayoutKind.Sequential , CharSet = CharSet.Ansi ) ]
	#endif
		public struct VERTEX_NOTEX_2D
		{

			public VECTOR pos ;

			public float rhw ;

			public COLOR_U8 color ;
		}


		/// <summary> Qc`Ɏgp钸_f[^^(DrawPrimitive2Dp) </summary>
	#if UNICODE
		[ StructLayout( LayoutKind.Sequential , CharSet = CharSet.Unicode ) ]
	#else
		[ StructLayout( LayoutKind.Sequential , CharSet = CharSet.Ansi ) ]
	#endif
		public struct VERTEX2D
		{

			public VECTOR pos ;

			public float rhw ;

			public COLOR_U8 dif ;

			public float u ;

			public float v ;
		}


		/// <summary> Qc`Ɏgp钸_f[^^(DrawPrimitive2DToShaderp) </summary>
	#if UNICODE
		[ StructLayout( LayoutKind.Sequential , CharSet = CharSet.Unicode ) ]
	#else
		[ StructLayout( LayoutKind.Sequential , CharSet = CharSet.Ansi ) ]
	#endif
		public struct VERTEX2DSHADER
		{

			public VECTOR pos ;

			public float rhw ;

			public COLOR_U8 dif ;

			public COLOR_U8 spc ;

			public float u ;

			public float v ;

			public float su ;

			public float sv ;
		}


		/// <summary> Qc`Ɏgp钸_f[^^(Jp) </summary>
	#if UNICODE
		[ StructLayout( LayoutKind.Sequential , CharSet = CharSet.Unicode ) ]
	#else
		[ StructLayout( LayoutKind.Sequential , CharSet = CharSet.Ansi ) ]
	#endif
		public struct VERTEX
		{

			public float x ;

			public float y ;

			public float u ;

			public float v ;

			public byte b ;

			public byte g ;

			public byte r ;

			public byte a ;
		}


		/// <summary> Rc`Ɏgp钸_f[^^( o[Ŵ ) </summary>
	#if UNICODE
		[ StructLayout( LayoutKind.Sequential , CharSet = CharSet.Unicode ) ]
	#else
		[ StructLayout( LayoutKind.Sequential , CharSet = CharSet.Ansi ) ]
	#endif
		public struct VERTEX_3D
		{

			public VECTOR pos ;

			public byte b ;

			public byte g ;

			public byte r ;

			public byte a ;

			public float u ;

			public float v ;
		}


		/// <summary> Rc`Ɏgp钸_f[^^ </summary>
	#if UNICODE
		[ StructLayout( LayoutKind.Sequential , CharSet = CharSet.Unicode ) ]
	#else
		[ StructLayout( LayoutKind.Sequential , CharSet = CharSet.Ansi ) ]
	#endif
		public struct VERTEX3D
		{

			public VECTOR pos ;

			public VECTOR norm ;

			public COLOR_U8 dif ;

			public COLOR_U8 spc ;

			public float u ;

			public float v ;

			public float su ;

			public float sv ;
		}


		/// <summary> Rc`Ɏgp钸_f[^^( DrawPrimitive3DToShaderp )
		/// Ӂcoϐɒǉ邩܂̂ŁA錾̏( VERTEX3DSHADER Vertex = { 0.0f , 0.0f , ... Ƃ悤Ȃ )͂Ȃǂł </summary>
	#if UNICODE
		[ StructLayout( LayoutKind.Sequential , CharSet = CharSet.Unicode ) ]
	#else
		[ StructLayout( LayoutKind.Sequential , CharSet = CharSet.Ansi ) ]
	#endif
		public struct VERTEX3DSHADER
		{

			public VECTOR pos ;

			public VECTOR norm ;

			public COLOR_U8 dif ;

			public COLOR_U8 spc ;

			public float u ;

			public float v ;

			public float su ;

			public float sv ;
		}


		/// <summary> Cgp[^ </summary>
	#if UNICODE
		[ StructLayout( LayoutKind.Sequential , CharSet = CharSet.Unicode ) ]
	#else
		[ StructLayout( LayoutKind.Sequential , CharSet = CharSet.Ansi ) ]
	#endif
		public struct LIGHTPARAM
		{

			/// <summary> Cg̃^Cv( DX_LIGHTTYPE_D3DLIGHT_POINT  ) </summary>
			public DX_LIGHTTYPE LightType ;

			/// <summary> fBt[YJ[ </summary>
			public COLOR_F Diffuse ;

			/// <summary> XyLJ[ </summary>
			public COLOR_F Specular ;

			/// <summary> ArGgF </summary>
			public COLOR_F Ambient ;

			/// <summary> ʒu </summary>
			public VECTOR Position ;

			/// <summary>  </summary>
			public VECTOR Direction ;

			/// <summary> L </summary>
			public float Range ;

			/// <summary> tH[It 1.0f ɂĂ̂D܂ </summary>
			public float Falloff ;

			/// <summary> ɂ錸WO </summary>
			public float Attenuation0 ;

			/// <summary> ɂ錸WP </summary>
			public float Attenuation1 ;

			/// <summary> ɂ錸WQ </summary>
			public float Attenuation2 ;

			/// <summary> X|bgCg̓R[̏Ɩpx( WA ) </summary>
			public float Theta ;

			/// <summary> X|bgCg̊OR[̏Ɩpx </summary>
			public float Phi ;
		}


		/// <summary> }eAp[^ </summary>
	#if UNICODE
		[ StructLayout( LayoutKind.Sequential , CharSet = CharSet.Unicode ) ]
	#else
		[ StructLayout( LayoutKind.Sequential , CharSet = CharSet.Ansi ) ]
	#endif
		public struct MATERIALPARAM
		{

			/// <summary> fBt[YJ[ </summary>
			public COLOR_F Diffuse ;

			/// <summary> ArGgJ[ </summary>
			public COLOR_F Ambient ;

			/// <summary> XyLJ[ </summary>
			public COLOR_F Specular ;

			/// <summary> G~bVuJ[ </summary>
			public COLOR_F Emissive ;

			/// <summary> XyLnCCg̑Nx </summary>
			public float Power ;
		}


		/// <summary> Cqbg`FbNʊi[p\ </summary>
	#if UNICODE
		[ StructLayout( LayoutKind.Sequential , CharSet = CharSet.Unicode ) ]
	#else
		[ StructLayout( LayoutKind.Sequential , CharSet = CharSet.Ansi ) ]
	#endif
		public struct HITRESULT_LINE
		{

			/// <summary> ǂ( 1:  0:Ȃ ) </summary>
			public bool HitFlag ;

			/// <summary> W </summary>
			public VECTOR Position ;
		}


		/// <summary> RWʑp|S </summary>
	#if UNICODE
		[ StructLayout( LayoutKind.Sequential , CharSet = CharSet.Unicode ) ]
	#else
		[ StructLayout( LayoutKind.Sequential , CharSet = CharSet.Ansi ) ]
	#endif
		public struct MV1_COLL_RESULT_POLY
		{

			/// <summary> ( MV1CollCheck_Line ł̂ݗL )qbgtO( 1:qbg  0:qbgȂ ) </summary>
			public bool HitFlag ;

			/// <summary> ( MV1CollCheck_Line ł̂ݗL )qbgW </summary>
			public VECTOR HitPosition ;

			/// <summary> |S܂܂t[̔ԍ </summary>
			public int FrameIndex ;

			/// <summary> |S̔ԍ </summary>
			public int PolygonIndex ;

			/// <summary> |SgpĂ}eA̔ԍ </summary>
			public int MaterialIndex ;

			/// <summary> |S`O_̍W </summary>
			public VECTOR Position_1 ;

			/// <summary> |S`O_̍W </summary>
			public VECTOR Position_2 ;

			/// <summary> |S`O_̍W </summary>
			public VECTOR Position_3 ;

			/// <summary> |S̖@ </summary>
			public VECTOR Normal ;
		}


		/// <summary> QƗp_\ </summary>
	#if UNICODE
		[ StructLayout( LayoutKind.Sequential , CharSet = CharSet.Unicode ) ]
	#else
		[ StructLayout( LayoutKind.Sequential , CharSet = CharSet.Ansi ) ]
	#endif
		public struct MV1_REF_VERTEX
		{

			/// <summary> ʒu </summary>
			public VECTOR Position ;

			/// <summary> @ </summary>
			public VECTOR Normal ;

			/// <summary> eNX`W </summary>
			public UV TexCoord_1 ;

			/// <summary> eNX`W </summary>
			public UV TexCoord_2 ;

			/// <summary> fBt[YJ[ </summary>
			public COLOR_U8 DiffuseColor ;

			/// <summary> XyLJ[ </summary>
			public COLOR_U8 SpecularColor ;
		}


		/// <summary> QƗp|S\ </summary>
	#if UNICODE
		[ StructLayout( LayoutKind.Sequential , CharSet = CharSet.Unicode ) ]
	#else
		[ StructLayout( LayoutKind.Sequential , CharSet = CharSet.Ansi ) ]
	#endif
		public struct MV1_REF_POLYGON
		{

			/// <summary> ̃|SĂt[ </summary>
			public int FrameIndex ;

			/// <summary> gpĂ}eA </summary>
			public int MaterialIndex ;

			/// <summary> VIndex wCfbNX̎QƐ( 1:t[  0:fS ) </summary>
			public int VIndexTarget ;

			/// <summary> Rp`|S𐬂Qƒ_̃CfbNX </summary>
			public int VIndex_1 ;

			/// <summary> Rp`|S𐬂Qƒ_̃CfbNX </summary>
			public int VIndex_2 ;

			/// <summary> Rp`|S𐬂Qƒ_̃CfbNX </summary>
			public int VIndex_3 ;

			/// <summary> |S𐬂_W̍ŏl </summary>
			public VECTOR MinPosition ;

			/// <summary> |S𐬂_W̍ől </summary>
			public VECTOR MaxPosition ;
		}


		/// <summary> QƗp|Sf[^\ </summary>
		public struct MV1_REF_POLYGONLIST
		{

			/// <summary> _W̍ŏl </summary>
			public VECTOR MinPosition ;

			/// <summary> _W̍ől </summary>
			public VECTOR MaxPosition ;

			/// <summary> QƗp|Sz </summary>
			public MV1_REF_POLYGON[] Polygons ;

			/// <summary> QƗp_z </summary>
			public MV1_REF_VERTEX[] Vertexs ;
		}


		/// <summary> Wf[^^ </summary>
	#if UNICODE
		[ StructLayout( LayoutKind.Sequential , CharSet = CharSet.Unicode ) ]
	#else
		[ StructLayout( LayoutKind.Sequential , CharSet = CharSet.Ansi ) ]
	#endif
		public struct POINTDATA
		{

			/// <summary> W </summary>
			public int x ;

			/// <summary> W </summary>
			public int y ;

			/// <summary> F </summary>
			public COLOR_U8 color ;

			/// <summary> p[^ </summary>
			public int pal ;
		}


		/// <summary> Cf[^^ </summary>
	#if UNICODE
		[ StructLayout( LayoutKind.Sequential , CharSet = CharSet.Unicode ) ]
	#else
		[ StructLayout( LayoutKind.Sequential , CharSet = CharSet.Ansi ) ]
	#endif
		public struct LINEDATA
		{

			/// <summary> W </summary>
			public int x1 ;

			/// <summary> W </summary>
			public int y1 ;

			/// <summary> W </summary>
			public int x2 ;

			/// <summary> W </summary>
			public int y2 ;

			/// <summary> F </summary>
			public COLOR_U8 color ;

			/// <summary> p[^ </summary>
			public int pal ;
		}


		/// <summary> C[WtH[}bgf[^ </summary>
	#if UNICODE
		[ StructLayout( LayoutKind.Sequential , CharSet = CharSet.Unicode ) ]
	#else
		[ StructLayout( LayoutKind.Sequential , CharSet = CharSet.Ansi ) ]
	#endif
		public struct IMAGEFORMATDESC
		{

			/// <summary> eNX`AtO( TRUE:eNX`  FALSE:WT[tFX ) </summary>
			[ MarshalAs( UnmanagedType.U1 ) ]
			public bool TextureFlag ;

			/// <summary> `l͂邩AtO	( TRUE:  FALSE:Ȃ ) </summary>
			[ MarshalAs( UnmanagedType.U1 ) ]
			public bool AlphaChFlag ;

			/// <summary> `\AtO( TRUE:\  FALSE:s\ ) </summary>
			[ MarshalAs( UnmanagedType.U1 ) ]
			public bool DrawValidFlag ;

			/// <summary> VXeɑ݂Ă邩AtO( TRUE:VXe  FALSE:uq`l )( WT[tFX̎̂ݗL ) </summary>
			[ MarshalAs( UnmanagedType.U1 ) ]
			public bool SystemMemFlag ;

			/// <summary> }l[WheNX`gpȂAtO </summary>
			[ MarshalAs( UnmanagedType.U1 ) ]
			public bool NotManagedTextureFlag ;

			/// <summary> {tH[}bg( DX_BASEIMAGE_FORMAT_NORMAL  ) </summary>
			[ MarshalAs( UnmanagedType.U1 ) ]
			public DX_BASEIMAGE_FORMAT BaseFormat ;

			/// <summary> ~bv}bv̐ </summary>
			[ MarshalAs( UnmanagedType.U1 ) ]
			public int MipMapCount ;

			/// <summary> eXg`l͂邩AtO( TRUE:  FALSE:Ȃ )( eNX`̏ꍇ̂ݗL ) </summary>
			[ MarshalAs( UnmanagedType.U1 ) ]
			public bool AlphaTestFlag ;

			/// <summary> F[x( eNX`̏ꍇ̂ݗL ) </summary>
			[ MarshalAs( UnmanagedType.U1 ) ]
			public int ColorBitDepth ;

			/// <summary> uhp摜AtO </summary>
			[ MarshalAs( UnmanagedType.U1 ) ]
			public bool BlendGraphFlag ;

			/// <summary> pbggpĂ邩AtO( SystemMemFlag  TRUE ̏ꍇ̂ݗL ) </summary>
			[ MarshalAs( UnmanagedType.U1 ) ]
			public bool UsePaletteFlag ;
		}


		/// <summary> WinSocketsgp̃AhXwp\ </summary>
	#if UNICODE
		[ StructLayout( LayoutKind.Explicit , CharSet = CharSet.Unicode ) ]
	#else
		[ StructLayout( LayoutKind.Explicit , CharSet = CharSet.Ansi ) ]
	#endif
		public struct IPDATA
		{

			/// <summary> AhXl </summary>
			[ FieldOffset( 0 ) ]
			public byte d1 ;

			/// <summary> AhXl </summary>
			[ FieldOffset( 1 ) ]
			public byte d2 ;

			/// <summary> AhXl </summary>
			[ FieldOffset( 2 ) ]
			public byte d3 ;

			/// <summary> AhXl </summary>
			[ FieldOffset( 3 ) ]
			public byte d4 ;

			/// <summary> AhXl </summary>
			[ FieldOffset( 0 ) ]
			public int dall ;
		}
	}
}
