using System ;
using System.Collections.Generic ;
using System.Runtime.InteropServices ;
using System.Text ;


namespace DxLibDLL
{


	public static partial class DX
	{


		public sealed class BlendGraph : Handler< BlendGraph >
		{

			internal static BlendGraph FromHandle( int handle )
			{
				BlendGraph handler = FindHandler( handle ) ;

				if( handler != null )
				{
					return handler ;
				}
				else
				{
					handler = new BlendGraph( handle ) ;
					AddHandler( handle, handler ) ;
					return handler ;
				}
			}

			private BlendGraph( int handle ) : base( handle )
			{
			}

			internal protected override sealed void DestructHandler( int handle )
			{
				lock( DX.locker )
				{
					int result = dx_DeleteGraph( handle , DX.LogOutFlag ) ;
				}
			}

		#if UNICODE
			[ DllImport( "DxLibW.dll" , CharSet = CharSet.Unicode , ExactSpelling = true ) ]
		#else
			[ DllImport( "DxLib.dll" , CharSet = CharSet.Ansi , ExactSpelling = true ) ]
		#endif
			internal static extern int dx_DeleteGraph( int GrHandle , bool LogOutFlag ) ;
		}

		/// <summary> w̃OtBbNnh폜 </summary>
		public static void DeleteGraph( BlendGraph GrHandle )
		{
			Disposable.Dispose( GrHandle ) ;
		}
	}
}
