﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Nlgp1.Utilities {
	/// <summary>
	/// フレームレートを計測します。
	/// </summary>
	public sealed class FrameRate {
		// http://www7.plala.or.jp/kfb/program/framerate.html
		private int    basetime;	//測定基準時間
		private int     flameCount;	//フレーム数

		/// <summary>
		/// フレームレートクラスの新しいインスタンスを初期化します。
		/// </summary>
		public FrameRate() {
			basetime = Environment.TickCount;
		}

		/// <summary>
		/// 現在のフレームレートを取得します。
		/// </summary>
		public float FlameRate {
			get;
			private set;
		}

		/// <summary>
		/// 描画時に呼び出してフレームレートを更新します。
		/// </summary>
		public void Update() {
			++flameCount;
			int now = Environment.TickCount;
			if( now - basetime >= 1000 ) {
				FlameRate = (float)( flameCount * 1000 ) / (float)( now - basetime );
				basetime = now;
				flameCount = 0;
			}
		}
	}

}
