﻿using System;
using System.Collections.Generic;
using DxLibDLL;
using Nlgp1.Common;
using Nlgp1.Drawers;
using Nlgp1.Stages;
using Nlgp1.Utilities;

namespace Nlgp1.Sprites {

	public struct ChipId : IComparable< ChipId > {

		public ChipId( LayerType layerType , int index ) {
			this.data = ( ( int )( ( ushort )( layerType ) ) << 16 ) | ( ( int )( ( ushort )( index ) ) << 0 );
		}

		public override int GetHashCode() {
			return this.data;
		}

		public override string ToString() {
			return this.data.ToString("X8");
		}

		public override bool Equals( object obj ) {
			return this.data == ( ( ChipId )( obj ) ).data;
		}

		public static bool operator ==( ChipId arg1 , ChipId arg2 ) {
			return arg1.data == arg2.data;
		}

		public static bool operator !=( ChipId arg1 , ChipId arg2 ) {
			return arg1.data != arg2.data;
		}

		public static bool operator <( ChipId arg1 , ChipId arg2 ) {
			return arg1.data < arg2.data;
		}

		public static bool operator >( ChipId arg1 , ChipId arg2 ) {
			return arg1.data > arg2.data;
		}

		public static bool operator <=( ChipId arg1 , ChipId arg2 ) {
			return arg1.data <= arg2.data;
		}

		public static bool operator >=( ChipId arg1 , ChipId arg2 ) {
			return arg1.data >= arg2.data;
		}

		public int CompareTo( ChipId other ) {
			return this.data - other.data;
		}

		public LayerType LayerType {
			get {
				return ( LayerType )( ( ushort )( this.data >> 16 ) );
			}
		}

		public int Index {
			get {
				return ( int )( ( ushort )( this.data >> 0 ) );
			}
		}

		private int data;
	}
}
