﻿using System;
using DxLibDLL;
using Nlgp1.Drawers;
using Nlgp1.Stages;

namespace Nlgp1 {

	public sealed class GameScreen : Screen , IDisposable {

		public GameScreen( int stageIndex ) {
			Stage.Load( stageIndex );
		}

		public void Dispose() {
		}

		public override void Draw() {
			StageDrawer.Draw();
		}

		public override Screen Update( Controller controller ) {
			if( controller.Select.IsDown ) {
				this.Dispose();
				return new MenuScreen( Stage.Index );
			}
			Stage.Update( controller );
			return this;
		}
	}
}
